/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.service.contract;

import java.util.List;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.persistence.EntityNotFoundException;
import javax.transaction.Transactional;
import javax.validation.Validator;
import org.optaweb.employeerostering.domain.common.AbstractPersistable;
import org.optaweb.employeerostering.domain.contract.Contract;
import org.optaweb.employeerostering.domain.contract.view.ContractView;
import org.optaweb.employeerostering.service.common.AbstractRestService;
import org.optaweb.employeerostering.service.contract.ContractRepository;

@ApplicationScoped
public class ContractService
extends AbstractRestService {
    private final ContractRepository contractRepository;

    @Inject
    public ContractService(Validator validator, ContractRepository contractRepository) {
        super(validator);
        this.contractRepository = contractRepository;
    }

    public Contract convertFromView(Integer tenantId, ContractView contractView) {
        this.validateBean(tenantId, contractView);
        Contract contract = new Contract(tenantId, contractView.getName(), contractView.getMaximumMinutesPerDay(), contractView.getMaximumMinutesPerWeek(), contractView.getMaximumMinutesPerMonth(), contractView.getMaximumMinutesPerYear());
        contract.setId(contractView.getId());
        contract.setVersion(contractView.getVersion());
        return contract;
    }

    public List<Contract> getContractList(Integer tenantId) {
        return this.contractRepository.findAllByTenantId(tenantId);
    }

    @Transactional
    public Contract getContract(Integer tenantId, Long id) {
        Contract contract = (Contract)this.contractRepository.findByIdOptional(id).orElseThrow(() -> new EntityNotFoundException("No Contract entity found with ID (" + id + ")."));
        this.validateBean(tenantId, contract);
        return contract;
    }

    @Transactional
    public Boolean deleteContract(Integer tenantId, Long id) {
        Optional contractOptional = this.contractRepository.findByIdOptional(id);
        if (!contractOptional.isPresent()) {
            return false;
        }
        this.validateBean(tenantId, (AbstractPersistable)contractOptional.get());
        this.contractRepository.deleteById(id);
        return true;
    }

    @Transactional
    public Contract createContract(Integer tenantId, ContractView contractView) {
        Contract contract = this.convertFromView(tenantId, contractView);
        this.contractRepository.persist(contract);
        return contract;
    }

    @Transactional
    public Contract updateContract(Integer tenantId, ContractView contractView) {
        Contract newContract = this.convertFromView(tenantId, contractView);
        Contract oldContract = (Contract)this.contractRepository.findByIdOptional(newContract.getId()).orElseThrow(() -> new EntityNotFoundException("Contract entity with ID (" + newContract.getId() + ") not found."));
        if (!oldContract.getTenantId().equals(newContract.getTenantId())) {
            throw new IllegalStateException("Contract entity with tenantId (" + oldContract.getTenantId() + ") cannot change tenants.");
        }
        oldContract.setName(newContract.getName());
        oldContract.setMaximumMinutesPerDay(newContract.getMaximumMinutesPerDay());
        oldContract.setMaximumMinutesPerWeek(newContract.getMaximumMinutesPerWeek());
        oldContract.setMaximumMinutesPerMonth(newContract.getMaximumMinutesPerMonth());
        oldContract.setMaximumMinutesPerYear(newContract.getMaximumMinutesPerYear());
        this.contractRepository.persist(oldContract);
        return oldContract;
    }

    @Transactional
    public Contract getOrCreateDefaultContract(Integer tenantId) {
        Optional<Contract> defaultContract = this.contractRepository.findAllByTenantId(tenantId).stream().filter(contract -> contract.getName().equals("Default Contract")).findAny();
        if (defaultContract.isPresent()) {
            return defaultContract.get();
        }
        Contract contract2 = new Contract();
        contract2.setName("Default Contract");
        contract2.setTenantId(tenantId);
        this.contractRepository.persist(contract2);
        return contract2;
    }
}

