package org.optaweb.employeerostering.shared.employee;

import com.github.nmorel.gwtjackson.client.ObjectMapper;
import com.github.nmorel.gwtjackson.client.ObjectReader;
import com.github.nmorel.gwtjackson.rest.api.RestCallback;
import com.github.nmorel.gwtjackson.rest.api.RestRequestBuilder;
import com.google.gwt.core.client.GWT;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Void;
import java.util.List;
import org.optaweb.employeerostering.shared.employee.view.EmployeeAvailabilityView;

/**
 * Generated REST service builder for {@link org.optaweb.employeerostering.shared.employee.EmployeeRestService}.
 */
public final class EmployeeRestServiceBuilder {
  private static ObjectReader1 objectreader1;

  private static ObjectReader2 objectreader2;

  private static ObjectMapper1 objectmapper1;

  private static ObjectMapper2 objectmapper2;

  private EmployeeRestServiceBuilder() {
  }

  private static ObjectReader1 getObjectReader1() {
    if (objectreader1 == null) {
      objectreader1 = GWT.create(ObjectReader1.class);
    }
    return objectreader1;
  }

  private static ObjectReader2 getObjectReader2() {
    if (objectreader2 == null) {
      objectreader2 = GWT.create(ObjectReader2.class);
    }
    return objectreader2;
  }

  private static ObjectMapper1 getObjectMapper1() {
    if (objectmapper1 == null) {
      objectmapper1 = GWT.create(ObjectMapper1.class);
    }
    return objectmapper1;
  }

  private static ObjectMapper2 getObjectMapper2() {
    if (objectmapper2 == null) {
      objectmapper2 = GWT.create(ObjectMapper2.class);
    }
    return objectmapper2;
  }

  public static final RestRequestBuilder<Void, List<Employee>> getEmployeeList(final Integer tenantId) {
    return new RestRequestBuilder<Void, List<Employee>>()
          .method(RequestBuilder.GET)
          .url("/tenant/{tenantId}/employee/")
          .addPathParam("tenantId", tenantId)
          .responseConverter(getObjectReader1());
  }

  public static final Request getEmployeeList(final Integer tenantId, RestCallback<List<Employee>> _callback_) {
    return getEmployeeList(tenantId)
          .callback(_callback_)
          .send();
  }

  public static final RestRequestBuilder<Void, Employee> getEmployee(final Integer tenantId, final Long id) {
    return new RestRequestBuilder<Void, Employee>()
          .method(RequestBuilder.GET)
          .url("/tenant/{tenantId}/employee/{id}")
          .addPathParam("tenantId", tenantId)
          .addPathParam("id", id)
          .responseConverter(getObjectMapper1());
  }

  public static final Request getEmployee(final Integer tenantId, final Long id, RestCallback<Employee> _callback_) {
    return getEmployee(tenantId, id)
          .callback(_callback_)
          .send();
  }

  public static final RestRequestBuilder<Employee, Employee> addEmployee(final Integer tenantId, final Employee employee) {
    return new RestRequestBuilder<Employee, Employee>()
          .method(RequestBuilder.POST)
          .url("/tenant/{tenantId}/employee/add")
          .body(employee)
          .bodyConverter(getObjectMapper1())
          .addPathParam("tenantId", tenantId)
          .responseConverter(getObjectMapper1());
  }

  public static final Request addEmployee(final Integer tenantId, final Employee employee, RestCallback<Employee> _callback_) {
    return addEmployee(tenantId, employee)
          .callback(_callback_)
          .send();
  }

  public static final RestRequestBuilder<Employee, Employee> updateEmployee(final Integer tenantId, final Employee employee) {
    return new RestRequestBuilder<Employee, Employee>()
          .method(RequestBuilder.POST)
          .url("/tenant/{tenantId}/employee/update")
          .body(employee)
          .bodyConverter(getObjectMapper1())
          .addPathParam("tenantId", tenantId)
          .responseConverter(getObjectMapper1());
  }

  public static final Request updateEmployee(final Integer tenantId, final Employee employee, RestCallback<Employee> _callback_) {
    return updateEmployee(tenantId, employee)
          .callback(_callback_)
          .send();
  }

  public static final RestRequestBuilder<Void, Boolean> removeEmployee(final Integer tenantId, final Long id) {
    return new RestRequestBuilder<Void, Boolean>()
          .method(RequestBuilder.DELETE)
          .url("/tenant/{tenantId}/employee/{id}")
          .addPathParam("tenantId", tenantId)
          .addPathParam("id", id)
          .responseConverter(getObjectReader2());
  }

  public static final Request removeEmployee(final Integer tenantId, final Long id, RestCallback<Boolean> _callback_) {
    return removeEmployee(tenantId, id)
          .callback(_callback_)
          .send();
  }

  public static final RestRequestBuilder<EmployeeAvailabilityView, EmployeeAvailabilityView> addEmployeeAvailability(final Integer tenantId, final EmployeeAvailabilityView employeeAvailability) {
    return new RestRequestBuilder<EmployeeAvailabilityView, EmployeeAvailabilityView>()
          .method(RequestBuilder.POST)
          .url("/tenant/{tenantId}/employee/availability/add")
          .body(employeeAvailability)
          .bodyConverter(getObjectMapper2())
          .addPathParam("tenantId", tenantId)
          .responseConverter(getObjectMapper2());
  }

  public static final Request addEmployeeAvailability(final Integer tenantId, final EmployeeAvailabilityView employeeAvailability, RestCallback<EmployeeAvailabilityView> _callback_) {
    return addEmployeeAvailability(tenantId, employeeAvailability)
          .callback(_callback_)
          .send();
  }

  public static final RestRequestBuilder<EmployeeAvailabilityView, EmployeeAvailabilityView> updateEmployeeAvailability(final Integer tenantId, final EmployeeAvailabilityView employeeAvailability) {
    return new RestRequestBuilder<EmployeeAvailabilityView, EmployeeAvailabilityView>()
          .method(RequestBuilder.PUT)
          .url("/tenant/{tenantId}/employee/availability/update")
          .body(employeeAvailability)
          .bodyConverter(getObjectMapper2())
          .addPathParam("tenantId", tenantId)
          .responseConverter(getObjectMapper2());
  }

  public static final Request updateEmployeeAvailability(final Integer tenantId, final EmployeeAvailabilityView employeeAvailability, RestCallback<EmployeeAvailabilityView> _callback_) {
    return updateEmployeeAvailability(tenantId, employeeAvailability)
          .callback(_callback_)
          .send();
  }

  public static final RestRequestBuilder<Void, Boolean> removeEmployeeAvailability(final Integer tenantId, final Long id) {
    return new RestRequestBuilder<Void, Boolean>()
          .method(RequestBuilder.DELETE)
          .url("/tenant/{tenantId}/employee/availability/{id}")
          .addPathParam("tenantId", tenantId)
          .addPathParam("id", id)
          .responseConverter(getObjectReader2());
  }

  public static final Request removeEmployeeAvailability(final Integer tenantId, final Long id, RestCallback<Boolean> _callback_) {
    return removeEmployeeAvailability(tenantId, id)
          .callback(_callback_)
          .send();
  }

  interface ObjectReader1 extends ObjectReader<List<Employee>> {
  }

  interface ObjectReader2 extends ObjectReader<Boolean> {
  }

  interface ObjectMapper1 extends ObjectMapper<Employee> {
  }

  interface ObjectMapper2 extends ObjectMapper<EmployeeAvailabilityView> {
  }
}
