package org.optaweb.employeerostering.shared.shift;

import com.github.nmorel.gwtjackson.client.ObjectMapper;
import com.github.nmorel.gwtjackson.client.ObjectReader;
import com.github.nmorel.gwtjackson.rest.api.RestCallback;
import com.github.nmorel.gwtjackson.rest.api.RestRequestBuilder;
import com.google.gwt.core.client.GWT;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Void;
import java.util.List;
import org.optaweb.employeerostering.shared.rotation.view.RotationView;
import org.optaweb.employeerostering.shared.shift.view.ShiftView;

/**
 * Generated REST service builder for {@link org.optaweb.employeerostering.shared.shift.ShiftRestService}.
 */
public final class ShiftRestServiceBuilder {
  private static ObjectReader1 objectreader1;

  private static ObjectReader2 objectreader2;

  private static ObjectMapper1 objectmapper1;

  private static ObjectMapper2 objectmapper2;

  private ShiftRestServiceBuilder() {
  }

  private static ObjectReader1 getObjectReader1() {
    if (objectreader1 == null) {
      objectreader1 = GWT.create(ObjectReader1.class);
    }
    return objectreader1;
  }

  private static ObjectReader2 getObjectReader2() {
    if (objectreader2 == null) {
      objectreader2 = GWT.create(ObjectReader2.class);
    }
    return objectreader2;
  }

  private static ObjectMapper1 getObjectMapper1() {
    if (objectmapper1 == null) {
      objectmapper1 = GWT.create(ObjectMapper1.class);
    }
    return objectmapper1;
  }

  private static ObjectMapper2 getObjectMapper2() {
    if (objectmapper2 == null) {
      objectmapper2 = GWT.create(ObjectMapper2.class);
    }
    return objectmapper2;
  }

  public static final RestRequestBuilder<Void, ShiftView> getShift(final Integer tenantId, final Long id) {
    return new RestRequestBuilder<Void, ShiftView>()
          .method(RequestBuilder.GET)
          .url("/tenant/{tenantId}/shift/{id}")
          .addPathParam("tenantId", tenantId)
          .addPathParam("id", id)
          .responseConverter(getObjectMapper1());
  }

  public static final Request getShift(final Integer tenantId, final Long id, RestCallback<ShiftView> _callback_) {
    return getShift(tenantId, id)
          .callback(_callback_)
          .send();
  }

  public static final RestRequestBuilder<Void, List<ShiftView>> getShifts(final Integer tenantId) {
    return new RestRequestBuilder<Void, List<ShiftView>>()
          .method(RequestBuilder.GET)
          .url("/tenant/{tenantId}/shift/")
          .addPathParam("tenantId", tenantId)
          .responseConverter(getObjectReader1());
  }

  public static final Request getShifts(final Integer tenantId, RestCallback<List<ShiftView>> _callback_) {
    return getShifts(tenantId)
          .callback(_callback_)
          .send();
  }

  public static final RestRequestBuilder<ShiftView, ShiftView> addShift(final Integer tenantId, final ShiftView shift) {
    return new RestRequestBuilder<ShiftView, ShiftView>()
          .method(RequestBuilder.POST)
          .url("/tenant/{tenantId}/shift/add")
          .body(shift)
          .bodyConverter(getObjectMapper1())
          .addPathParam("tenantId", tenantId)
          .responseConverter(getObjectMapper1());
  }

  public static final Request addShift(final Integer tenantId, final ShiftView shift, RestCallback<ShiftView> _callback_) {
    return addShift(tenantId, shift)
          .callback(_callback_)
          .send();
  }

  public static final RestRequestBuilder<ShiftView, ShiftView> updateShift(final Integer tenantId, final ShiftView shift) {
    return new RestRequestBuilder<ShiftView, ShiftView>()
          .method(RequestBuilder.PUT)
          .url("/tenant/{tenantId}/shift/update")
          .body(shift)
          .bodyConverter(getObjectMapper1())
          .addPathParam("tenantId", tenantId)
          .responseConverter(getObjectMapper1());
  }

  public static final Request updateShift(final Integer tenantId, final ShiftView shift, RestCallback<ShiftView> _callback_) {
    return updateShift(tenantId, shift)
          .callback(_callback_)
          .send();
  }

  public static final RestRequestBuilder<Void, Boolean> removeShift(final Integer tenantId, final Long id) {
    return new RestRequestBuilder<Void, Boolean>()
          .method(RequestBuilder.DELETE)
          .url("/tenant/{tenantId}/shift/{id}")
          .addPathParam("tenantId", tenantId)
          .addPathParam("id", id)
          .responseConverter(getObjectReader2());
  }

  public static final Request removeShift(final Integer tenantId, final Long id, RestCallback<Boolean> _callback_) {
    return removeShift(tenantId, id)
          .callback(_callback_)
          .send();
  }

  public static final RestRequestBuilder<RotationView, Void> updateRotation(final Integer tenantId, final RotationView rotationView) {
    return new RestRequestBuilder<RotationView, Void>()
          .method(RequestBuilder.PUT)
          .url("/tenant/{tenantId}/shift/template/update")
          .body(rotationView)
          .bodyConverter(getObjectMapper2())
          .addPathParam("tenantId", tenantId);
  }

  public static final Request updateRotation(final Integer tenantId, final RotationView rotationView, RestCallback<Void> _callback_) {
    return updateRotation(tenantId, rotationView)
          .callback(_callback_)
          .send();
  }

  public static final RestRequestBuilder<Void, RotationView> getRotation(final Integer tenantId) {
    return new RestRequestBuilder<Void, RotationView>()
          .method(RequestBuilder.GET)
          .url("/tenant/{tenantId}/shift/template")
          .addPathParam("tenantId", tenantId)
          .responseConverter(getObjectMapper2());
  }

  public static final Request getRotation(final Integer tenantId, RestCallback<RotationView> _callback_) {
    return getRotation(tenantId)
          .callback(_callback_)
          .send();
  }

  interface ObjectReader1 extends ObjectReader<List<ShiftView>> {
  }

  interface ObjectReader2 extends ObjectReader<Boolean> {
  }

  interface ObjectMapper1 extends ObjectMapper<ShiftView> {
  }

  interface ObjectMapper2 extends ObjectMapper<RotationView> {
  }
}
