package org.optaweb.employeerostering.shared.skill;

import com.github.nmorel.gwtjackson.client.ObjectMapper;
import com.github.nmorel.gwtjackson.client.ObjectReader;
import com.github.nmorel.gwtjackson.rest.api.RestCallback;
import com.github.nmorel.gwtjackson.rest.api.RestRequestBuilder;
import com.google.gwt.core.client.GWT;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Void;
import java.util.List;

/**
 * Generated REST service builder for {@link org.optaweb.employeerostering.shared.skill.SkillRestService}.
 */
public final class SkillRestServiceBuilder {
  private static ObjectReader1 objectreader1;

  private static ObjectReader2 objectreader2;

  private static ObjectMapper1 objectmapper1;

  private SkillRestServiceBuilder() {
  }

  private static ObjectReader1 getObjectReader1() {
    if (objectreader1 == null) {
      objectreader1 = GWT.create(ObjectReader1.class);
    }
    return objectreader1;
  }

  private static ObjectReader2 getObjectReader2() {
    if (objectreader2 == null) {
      objectreader2 = GWT.create(ObjectReader2.class);
    }
    return objectreader2;
  }

  private static ObjectMapper1 getObjectMapper1() {
    if (objectmapper1 == null) {
      objectmapper1 = GWT.create(ObjectMapper1.class);
    }
    return objectmapper1;
  }

  public static final RestRequestBuilder<Void, List<Skill>> getSkillList(final Integer tenantId) {
    return new RestRequestBuilder<Void, List<Skill>>()
          .method(RequestBuilder.GET)
          .url("/tenant/{tenantId}/skill/")
          .addPathParam("tenantId", tenantId)
          .responseConverter(getObjectReader1());
  }

  public static final Request getSkillList(final Integer tenantId, RestCallback<List<Skill>> _callback_) {
    return getSkillList(tenantId)
          .callback(_callback_)
          .send();
  }

  public static final RestRequestBuilder<Void, Skill> getSkill(final Integer tenantId, final Long id) {
    return new RestRequestBuilder<Void, Skill>()
          .method(RequestBuilder.GET)
          .url("/tenant/{tenantId}/skill/{id}")
          .addPathParam("tenantId", tenantId)
          .addPathParam("id", id)
          .responseConverter(getObjectMapper1());
  }

  public static final Request getSkill(final Integer tenantId, final Long id, RestCallback<Skill> _callback_) {
    return getSkill(tenantId, id)
          .callback(_callback_)
          .send();
  }

  public static final RestRequestBuilder<Skill, Skill> addSkill(final Integer tenantId, final Skill skill) {
    return new RestRequestBuilder<Skill, Skill>()
          .method(RequestBuilder.POST)
          .url("/tenant/{tenantId}/skill/add")
          .body(skill)
          .bodyConverter(getObjectMapper1())
          .addPathParam("tenantId", tenantId)
          .responseConverter(getObjectMapper1());
  }

  public static final Request addSkill(final Integer tenantId, final Skill skill, RestCallback<Skill> _callback_) {
    return addSkill(tenantId, skill)
          .callback(_callback_)
          .send();
  }

  public static final RestRequestBuilder<Skill, Skill> updateSkill(final Integer tenantId, final Skill skill) {
    return new RestRequestBuilder<Skill, Skill>()
          .method(RequestBuilder.POST)
          .url("/tenant/{tenantId}/skill/update")
          .body(skill)
          .bodyConverter(getObjectMapper1())
          .addPathParam("tenantId", tenantId)
          .responseConverter(getObjectMapper1());
  }

  public static final Request updateSkill(final Integer tenantId, final Skill skill, RestCallback<Skill> _callback_) {
    return updateSkill(tenantId, skill)
          .callback(_callback_)
          .send();
  }

  public static final RestRequestBuilder<Void, Boolean> removeSkill(final Integer tenantId, final Long id) {
    return new RestRequestBuilder<Void, Boolean>()
          .method(RequestBuilder.DELETE)
          .url("/tenant/{tenantId}/skill/{id}")
          .addPathParam("tenantId", tenantId)
          .addPathParam("id", id)
          .responseConverter(getObjectReader2());
  }

  public static final Request removeSkill(final Integer tenantId, final Long id, RestCallback<Boolean> _callback_) {
    return removeSkill(tenantId, id)
          .callback(_callback_)
          .send();
  }

  interface ObjectReader1 extends ObjectReader<List<Skill>> {
  }

  interface ObjectReader2 extends ObjectReader<Boolean> {
  }

  interface ObjectMapper1 extends ObjectMapper<Skill> {
  }
}
