/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.shared.employee.view;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import javax.validation.constraints.NotNull;
import org.optaweb.employeerostering.shared.common.AbstractPersistable;
import org.optaweb.employeerostering.shared.common.GwtJavaTimeWorkaroundUtil;
import org.optaweb.employeerostering.shared.common.HasTimeslot;
import org.optaweb.employeerostering.shared.employee.Employee;
import org.optaweb.employeerostering.shared.employee.EmployeeAvailability;
import org.optaweb.employeerostering.shared.employee.EmployeeAvailabilityState;

public class EmployeeAvailabilityView
extends AbstractPersistable
implements HasTimeslot {
    @NotNull
    private Long employeeId;
    @NotNull
    private LocalDateTime startDateTime;
    @NotNull
    private LocalDateTime endDateTime;
    private EmployeeAvailabilityState state;

    public EmployeeAvailabilityView() {
    }

    public EmployeeAvailabilityView(Integer tenantId, Employee employee, LocalDateTime startDateTime, LocalDateTime endDateTime, EmployeeAvailabilityState state) {
        super(tenantId);
        this.employeeId = employee.getId();
        this.startDateTime = startDateTime;
        this.endDateTime = endDateTime;
        this.state = state;
    }

    public EmployeeAvailabilityView(ZoneId zoneId, EmployeeAvailability employeeAvailability) {
        super(employeeAvailability);
        this.employeeId = employeeAvailability.getEmployee().getId();
        this.startDateTime = GwtJavaTimeWorkaroundUtil.toLocalDateTimeInZone(employeeAvailability.getStartDateTime(), zoneId);
        this.endDateTime = GwtJavaTimeWorkaroundUtil.toLocalDateTimeInZone(employeeAvailability.getEndDateTime(), zoneId);
        this.state = employeeAvailability.getState();
    }

    @Override
    public String toString() {
        return this.employeeId + ":" + this.startDateTime + "-" + this.endDateTime;
    }

    public Long getEmployeeId() {
        return this.employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public LocalDateTime getStartDateTime() {
        return this.startDateTime;
    }

    public void setStartDateTime(LocalDateTime startDateTime) {
        this.startDateTime = startDateTime;
    }

    public LocalDateTime getEndDateTime() {
        return this.endDateTime;
    }

    public void setEndDateTime(LocalDateTime endDateTime) {
        this.endDateTime = endDateTime;
    }

    public EmployeeAvailabilityState getState() {
        return this.state;
    }

    public void setState(EmployeeAvailabilityState state) {
        this.state = state;
    }

    @Override
    @JsonIgnore
    public Duration getDurationBetweenReferenceAndStart() {
        return Duration.between(HasTimeslot.EPOCH, this.getStartDateTime());
    }

    @Override
    @JsonIgnore
    public Duration getDurationOfTimeslot() {
        return Duration.between(this.getStartDateTime(), this.getEndDateTime());
    }
}

