/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.shared.roster;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.optaweb.employeerostering.shared.employee.Employee;
import org.optaweb.employeerostering.shared.roster.PublishResult;
import org.optaweb.employeerostering.shared.roster.Roster;
import org.optaweb.employeerostering.shared.roster.RosterState;
import org.optaweb.employeerostering.shared.roster.view.AvailabilityRosterView;
import org.optaweb.employeerostering.shared.roster.view.ShiftRosterView;
import org.optaweb.employeerostering.shared.spot.Spot;

@Api(tags={"Roster"})
@Path(value="/tenant/{tenantId}/roster")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface RosterRestService {
    @ApiOperation(value="Fetches the current Roster State")
    @GET
    @Path(value="/state")
    public RosterState getRosterState(@ApiParam(required=true) @PathParam(value="tenantId") Integer var1);

    @ApiOperation(value="Get the current shift roster view")
    @GET
    @Path(value="/shiftRosterView/current")
    public ShiftRosterView getCurrentShiftRosterView(@ApiParam(required=true) @PathParam(value="tenantId") Integer var1, @ApiParam @QueryParam(value="p") Integer var2, @ApiParam @QueryParam(value="n") Integer var3);

    @ApiOperation(value="Get a shift roster view between 2 dates")
    @GET
    @Path(value="/shiftRosterView")
    public ShiftRosterView getShiftRosterView(@ApiParam(required=true) @PathParam(value="tenantId") Integer var1, @ApiParam @QueryParam(value="p") Integer var2, @ApiParam @QueryParam(value="n") Integer var3, @ApiParam(value="inclusive", required=true) @QueryParam(value="startDate") String var4, @ApiParam(value="exclusive", required=true) @QueryParam(value="endDate") String var5);

    @ApiOperation(value="Get a shift roster view between 2 dates for a subset of the spots")
    @POST
    @Path(value="/shiftRosterView/for")
    public ShiftRosterView getShiftRosterViewFor(@ApiParam(required=true) @PathParam(value="tenantId") Integer var1, @ApiParam(value="inclusive", required=true) @QueryParam(value="startDate") String var2, @ApiParam(value="exclusive", required=true) @QueryParam(value="endDate") String var3, @ApiParam(required=true) List<Spot> var4);

    @ApiOperation(value="Get the current availability roster view")
    @GET
    @Path(value="/availabilityRosterView/current")
    public AvailabilityRosterView getCurrentAvailabilityRosterView(@ApiParam(required=true) @PathParam(value="tenantId") Integer var1, @ApiParam @QueryParam(value="p") Integer var2, @ApiParam @QueryParam(value="n") Integer var3);

    @ApiOperation(value="Get an availability roster view between 2 dates")
    @GET
    @Path(value="/availabilityRosterView")
    public AvailabilityRosterView getAvailabilityRosterView(@ApiParam(required=true) @PathParam(value="tenantId") Integer var1, @ApiParam @QueryParam(value="p") Integer var2, @ApiParam @QueryParam(value="n") Integer var3, @ApiParam(value="inclusive", required=true) @QueryParam(value="startDate") String var4, @ApiParam(value="exclusive", required=true) @QueryParam(value="endDate") String var5);

    @ApiOperation(value="Get an availability roster view between 2 dates for a subset of the employees")
    @POST
    @Path(value="/availabilityRosterView/for")
    public AvailabilityRosterView getAvailabilityRosterViewFor(@ApiParam(required=true) @PathParam(value="tenantId") Integer var1, @ApiParam(value="inclusive", required=true) @QueryParam(value="startDate") String var2, @ApiParam(value="exclusive", required=true) @QueryParam(value="endDate") String var3, @ApiParam(required=true) List<Employee> var4);

    @ApiOperation(value="Start solving the roster. This will assign each shift to an employee.")
    @POST
    @Path(value="/solve")
    public void solveRoster(@ApiParam(required=true) @PathParam(value="tenantId") Integer var1);

    @ApiOperation(value="Stop solving the roster, if it hasn't terminated automatically already.")
    @POST
    @Path(value="/terminate")
    public void terminateRosterEarly(@ApiParam(required=true) @PathParam(value="tenantId") Integer var1);

    @ApiOperation(value="Publishes the next set of draft shifts and creates new draft shift from the rotation template.")
    @POST
    @Path(value="/publishAndProvision")
    public PublishResult publishAndProvision(@ApiParam(required=true) @PathParam(value="tenantId") Integer var1);

    public Roster buildRoster(Integer var1);

    public void updateShiftsOfRoster(Roster var1);
}

