/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.shared.rotation.view;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.Duration;
import org.optaweb.employeerostering.shared.common.AbstractPersistable;
import org.optaweb.employeerostering.shared.common.HasTimeslot;
import org.optaweb.employeerostering.shared.rotation.ShiftTemplate;

public class ShiftTemplateView
extends AbstractPersistable
implements HasTimeslot {
    private Long spotId;
    private Long rotationEmployeeId;
    private Duration durationBetweenRotationStartAndTemplateStart;
    private Duration shiftTemplateDuration;

    public ShiftTemplateView() {
    }

    public ShiftTemplateView(Integer rotationLength, ShiftTemplate shiftTemplate) {
        super(shiftTemplate);
        this.spotId = shiftTemplate.getSpot().getId();
        this.rotationEmployeeId = shiftTemplate.getRotationEmployee() != null ? shiftTemplate.getRotationEmployee().getId() : null;
        this.durationBetweenRotationStartAndTemplateStart = Duration.ofDays(shiftTemplate.getStartDayOffset().intValue()).plusSeconds(shiftTemplate.getStartTime().toSecondOfDay());
        this.shiftTemplateDuration = Duration.ofDays(shiftTemplate.getEndDayOffset() < shiftTemplate.getStartDayOffset() ? (long)rotationLength.intValue() : 0L).plusDays(shiftTemplate.getEndDayOffset() - shiftTemplate.getStartDayOffset()).plusSeconds(shiftTemplate.getEndTime().toSecondOfDay()).minusSeconds(shiftTemplate.getStartTime().toSecondOfDay());
    }

    public ShiftTemplateView(Integer tenantId, Long spotId, Duration durationBetweenRotationStartAndTemplateStart, Duration shiftTemplateDuration, Long rotationEmployeeId) {
        super(tenantId);
        this.spotId = spotId;
        this.durationBetweenRotationStartAndTemplateStart = durationBetweenRotationStartAndTemplateStart;
        this.shiftTemplateDuration = shiftTemplateDuration;
        this.rotationEmployeeId = rotationEmployeeId;
    }

    public Long getSpotId() {
        return this.spotId;
    }

    public void setSpotId(Long spotId) {
        this.spotId = spotId;
    }

    public Long getRotationEmployeeId() {
        return this.rotationEmployeeId;
    }

    public void setRotationEmployeeId(Long rotationEmployeeId) {
        this.rotationEmployeeId = rotationEmployeeId;
    }

    public Duration getDurationBetweenRotationStartAndTemplateStart() {
        return this.durationBetweenRotationStartAndTemplateStart;
    }

    public void setDurationBetweenRotationStartAndTemplateStart(Duration durationBetweenRotationStartAndTemplateStart) {
        this.durationBetweenRotationStartAndTemplateStart = durationBetweenRotationStartAndTemplateStart;
    }

    public Duration getShiftTemplateDuration() {
        return this.shiftTemplateDuration;
    }

    public void setShiftTemplateDuration(Duration shiftTemplateDuration) {
        this.shiftTemplateDuration = shiftTemplateDuration;
    }

    @Override
    @JsonIgnore
    public Duration getDurationBetweenReferenceAndStart() {
        return this.getDurationBetweenRotationStartAndTemplateStart();
    }

    @Override
    @JsonIgnore
    public Duration getDurationOfTimeslot() {
        return this.getShiftTemplateDuration();
    }
}

