/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.shared.tenant;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.time.ZoneId;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.optaweb.employeerostering.shared.roster.RosterState;
import org.optaweb.employeerostering.shared.tenant.RosterParametrization;
import org.optaweb.employeerostering.shared.tenant.Tenant;

@Api(tags={"Tenant"})
@Path(value="/tenant")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface TenantRestService {
    @ApiOperation(value="Get a list of all tenants")
    @GET
    @Path(value="/")
    public List<Tenant> getTenantList();

    @ApiOperation(value="Get a tenant by id")
    @GET
    @Path(value="/{id : \\d+}")
    public Tenant getTenant(@ApiParam(required=true) @PathParam(value="id") Integer var1);

    @ApiOperation(value="Add a new tenant")
    @POST
    @Path(value="/add")
    public Tenant addTenant(@ApiParam(value="with no id", required=true) RosterState var1);

    @ApiOperation(value="Get a tenant roster parametrization")
    @GET
    @Path(value="/{id}")
    public RosterParametrization getRosterParametrization(@ApiParam(required=true) @PathParam(value="id") Integer var1);

    @ApiOperation(value="Update a tenant roster parametrization")
    @POST
    @Path(value="/parametrization/update")
    public RosterParametrization updateRosterParametrization(@ApiParam(required=true) RosterParametrization var1);

    @ApiOperation(value="Get supported timezones")
    @GET
    @Path(value="/supported/timezones")
    public List<ZoneId> getSupportedTimezones();
}

