/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.service.solver;

import java.time.OffsetDateTime;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.score.director.ScoreDirectorFactory;
import org.optaweb.employeerostering.domain.roster.Roster;
import org.optaweb.employeerostering.domain.shift.Shift;
import org.optaweb.employeerostering.service.roster.RosterService;
import org.optaweb.employeerostering.service.solver.SolverStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.web.context.annotation.ApplicationScope;

@ApplicationScope
@Component
public class WannabeSolverManager
implements ApplicationRunner {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SolverFactory<Roster> solverFactory;
    private ScoreDirectorFactory<Roster> scoreDirectorFactory;
    private ThreadPoolTaskExecutor taskExecutor;
    private RosterService rosterService;
    private ConcurrentMap<Integer, SolverStatus> tenantIdToSolverStateMap = new ConcurrentHashMap<Integer, SolverStatus>();
    private ConcurrentMap<Integer, Solver<Roster>> tenantIdToSolverMap = new ConcurrentHashMap<Integer, Solver<Roster>>();
    private ConcurrentMap<Integer, Roster> tenantIdToBestSolutionMap = new ConcurrentHashMap<Integer, Roster>();

    public WannabeSolverManager(ThreadPoolTaskExecutor taskExecutor, RosterService rosterService) {
        this.taskExecutor = taskExecutor;
        this.rosterService = rosterService;
    }

    public void run(ApplicationArguments args) {
        this.setUpSolverFactory();
    }

    public void setUpSolverFactory() {
        this.scoreDirectorFactory = this.solverFactory.getScoreDirectorFactory();
    }

    public void terminate(Integer tenantId) {
        Solver solver = (Solver)this.tenantIdToSolverMap.get(tenantId);
        if (null == solver) {
            throw new IllegalStateException("The roster with tenantId (" + tenantId + ") is not being solved currently.");
        }
        solver.terminateEarly();
    }

    public CountDownLatch solve(Integer tenantId) {
        return this.solveRoster(tenantId, this.rosterService.buildRoster(tenantId));
    }

    public CountDownLatch replan(Integer tenantId) {
        Roster roster = this.rosterService.buildRoster(tenantId);
        roster.setNondisruptivePlanning(true);
        roster.setNondisruptiveReplanFrom(OffsetDateTime.now());
        try (ScoreDirector<Roster> scoreDirector = this.getScoreDirector();){
            scoreDirector.setWorkingSolution((Object)roster);
            scoreDirector.calculateScore();
            Map constraintMatchTotalMap = scoreDirector.getConstraintMatchTotalMap();
            String CONSTRAINT_ID = ConstraintMatchTotal.composeConstraintId((String)"org.optaweb.employeerostering.service.solver", (String)"Unavailable time slot for an employee");
            ((ConstraintMatchTotal)constraintMatchTotalMap.get(CONSTRAINT_ID)).getConstraintMatchSet().forEach(cm -> {
                Shift shift = (Shift)cm.getJustificationList().stream().filter(o -> o instanceof Shift).findAny().get();
                if (!shift.isPinnedByUser()) {
                    shift.setEmployee(null);
                }
            });
        }
        return this.solveRoster(tenantId, roster);
    }

    public CountDownLatch solveRoster(Integer tenantId, Roster roster) {
        this.logger.info("Scheduling solver for tenantId ({})...", (Object)tenantId);
        this.tenantIdToSolverStateMap.compute(tenantId, (k, solverStatus) -> {
            if (solverStatus != null && solverStatus != SolverStatus.TERMINATED) {
                throw new IllegalStateException("The roster with tenantId (" + tenantId + ") is already solving with solverStatus (" + (Object)solverStatus + ").");
            }
            return SolverStatus.SCHEDULED;
        });
        CountDownLatch solvingEndedLatch = new CountDownLatch(1);
        this.taskExecutor.execute(() -> {
            try {
                Solver solver = this.solverFactory.buildSolver();
                this.tenantIdToSolverMap.put(tenantId, (Solver<Roster>)solver);
                solver.addEventListener(event -> {
                    if (event.isEveryProblemFactChangeProcessed()) {
                        this.logger.info("  New best solution found for tenantId ({}).", (Object)tenantId);
                        Roster newBestRoster = (Roster)event.getNewBestSolution();
                        this.tenantIdToBestSolutionMap.put(tenantId, newBestRoster);
                        this.rosterService.updateShiftsOfRoster(newBestRoster);
                    }
                });
                try {
                    this.tenantIdToSolverStateMap.put(tenantId, SolverStatus.SOLVING);
                    solver.solve((Object)roster);
                    solvingEndedLatch.countDown();
                }
                finally {
                    this.tenantIdToSolverMap.remove(tenantId);
                    this.tenantIdToSolverStateMap.put(tenantId, SolverStatus.TERMINATED);
                }
            }
            catch (Throwable e) {
                this.logger.error("Error solving for tenantId (" + tenantId + ").", e);
            }
        });
        return solvingEndedLatch;
    }

    public Roster getRoster(Integer tenantId) {
        return (Roster)this.tenantIdToBestSolutionMap.get(tenantId);
    }

    public SolverStatus getSolverStatus(Integer tenantId) {
        return this.tenantIdToSolverStateMap.getOrDefault(tenantId, SolverStatus.TERMINATED);
    }

    public ScoreDirector<Roster> getScoreDirector() {
        return this.scoreDirectorFactory.buildScoreDirector();
    }
}

