/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.domain.tenant;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.optaplanner.core.api.domain.lookup.PlanningId;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"name"})})
public class Tenant {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @PlanningId
    private Integer id;
    @Version
    private Long version;
    @NotNull
    @Size(min=1, max=120)
    private @NotNull @Size(min=1, max=120) String name;

    public Tenant() {
    }

    public Tenant(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tenant other = (Tenant)o;
        return !(this.id == null ? other.getId() != null : !this.id.equals(other.getId()));
    }

    public int hashCode() {
        return this.id == null ? 0 : this.id.hashCode();
    }

    public String toString() {
        return this.name;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

