/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.domain.rotation;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.persistence.CollectionTable;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;
import org.optaweb.employeerostering.domain.common.AbstractPersistable;
import org.optaweb.employeerostering.domain.rotation.Seat;
import org.optaweb.employeerostering.domain.shift.Shift;
import org.optaweb.employeerostering.domain.skill.Skill;
import org.optaweb.employeerostering.domain.spot.Spot;

@Entity
public class TimeBucket
extends AbstractPersistable {
    private LocalTime startTime;
    private LocalTime endTime;
    @ManyToOne
    private Spot spot;
    @NotNull
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="TimeBucketAdditionalSkillSet", joinColumns={@JoinColumn(name="timebucketId", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="skillId", referencedColumnName="id")})
    private Set<Skill> additionalSkillSet;
    @ElementCollection
    @CollectionTable(name="repeat_on_day_set", joinColumns={@JoinColumn(name="day_id", referencedColumnName="id", foreignKey=@ForeignKey(name="DAY_FK", foreignKeyDefinition="FOREIGN KEY (day_id) references public.time_bucket (id) ON UPDATE NO ACTION ON DELETE CASCADE"))})
    private Set<DayOfWeek> repeatOnDaySet;
    @ElementCollection
    @CollectionTable(name="seat_list", joinColumns={@JoinColumn(name="seat_id", referencedColumnName="id", foreignKey=@ForeignKey(name="SEAT_FK", foreignKeyDefinition="FOREIGN KEY (seat_id) references public.time_bucket (id) ON UPDATE NO ACTION ON DELETE CASCADE"))})
    private List<Seat> seatList;

    public TimeBucket() {
    }

    public TimeBucket(Integer tenantId, Spot spot, LocalTime startTime, LocalTime endTime, Set<Skill> additionalSkillSet, Set<DayOfWeek> repeatOnDaySet, DayOfWeek startOfWeek, int rotationLength) {
        this(tenantId, spot, startTime, endTime, additionalSkillSet, repeatOnDaySet, TimeBucket.generateDefaultSeatList(startOfWeek, repeatOnDaySet, rotationLength));
    }

    public TimeBucket(Integer tenantId, Spot spot, LocalTime startTime, LocalTime endTime, Set<Skill> additionalSkillSet, Set<DayOfWeek> repeatOnDaySet, List<Seat> seatList) {
        super(tenantId);
        this.spot = spot;
        this.startTime = startTime;
        this.endTime = endTime;
        this.additionalSkillSet = additionalSkillSet;
        this.repeatOnDaySet = repeatOnDaySet;
        this.seatList = new ArrayList<Seat>(seatList);
    }

    private static List<Seat> generateDefaultSeatList(DayOfWeek startOfWeek, Set<DayOfWeek> repeatOnDaySet, int rotationLength) {
        ArrayList<Seat> seatList = new ArrayList<Seat>();
        DayOfWeek rotationDay = startOfWeek;
        for (int i = 0; i < rotationLength; ++i) {
            if (repeatOnDaySet.contains(rotationDay)) {
                seatList.add(new Seat(i, null));
            }
            rotationDay = rotationDay.plus(1L);
        }
        return seatList;
    }

    public Spot getSpot() {
        return this.spot;
    }

    public void setSpot(Spot spot) {
        this.spot = spot;
    }

    public LocalTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(LocalTime startTime) {
        this.startTime = startTime;
    }

    public LocalTime getEndTime() {
        return this.endTime;
    }

    public void setEndTime(LocalTime endTime) {
        this.endTime = endTime;
    }

    public Set<Skill> getAdditionalSkillSet() {
        return this.additionalSkillSet;
    }

    public void setAdditionalSkillSet(Set<Skill> additionalSkillSet) {
        this.additionalSkillSet = additionalSkillSet;
    }

    public Set<DayOfWeek> getRepeatOnDaySet() {
        return this.repeatOnDaySet;
    }

    public void setRepeatOnDaySet(Set<DayOfWeek> repeatOnDaySet) {
        this.repeatOnDaySet = repeatOnDaySet;
    }

    public List<Seat> getSeatList() {
        return this.seatList;
    }

    public void setSeatList(List<Seat> seatList) {
        this.seatList = seatList;
    }

    public void setValuesFromTimeBucket(TimeBucket updatedTimeBucket) {
        this.setSpot(updatedTimeBucket.getSpot());
        this.setStartTime(updatedTimeBucket.getStartTime());
        this.setEndTime(updatedTimeBucket.getEndTime());
        this.setAdditionalSkillSet(updatedTimeBucket.getAdditionalSkillSet());
        this.setRepeatOnDaySet(updatedTimeBucket.getRepeatOnDaySet());
        this.setSeatList(updatedTimeBucket.getSeatList());
    }

    public Optional<Shift> createShiftForOffset(LocalDate startDate, int offset, ZoneId zoneId, boolean defaultToRotationEmployee) {
        return this.seatList.stream().filter(seat -> seat.getDayInRotation() == offset).findAny().map(seat -> {
            LocalDateTime startDateTime = startDate.atTime(this.getStartTime());
            LocalDate endDate = this.getStartTime().isBefore(this.getEndTime()) ? startDate : startDate.plusDays(1L);
            LocalDateTime endDateTime = endDate.atTime(this.getEndTime());
            OffsetDateTime startOffsetDateTime = OffsetDateTime.of(startDateTime, zoneId.getRules().getOffset(startDateTime));
            OffsetDateTime endOffsetDateTime = OffsetDateTime.of(endDateTime, zoneId.getRules().getOffset(endDateTime));
            Shift shift = new Shift(this.getTenantId(), this.getSpot(), startOffsetDateTime, endOffsetDateTime, seat.getEmployee(), new HashSet<Skill>(this.additionalSkillSet), null);
            if (defaultToRotationEmployee) {
                shift.setEmployee(seat.getEmployee());
            }
            return shift;
        });
    }
}

