/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.service.roster;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import org.optaplanner.core.api.solver.SolverStatus;
import org.optaweb.employeerostering.domain.employee.Employee;
import org.optaweb.employeerostering.domain.roster.PublishResult;
import org.optaweb.employeerostering.domain.roster.RosterState;
import org.optaweb.employeerostering.domain.roster.view.AvailabilityRosterView;
import org.optaweb.employeerostering.domain.roster.view.ShiftRosterView;
import org.optaweb.employeerostering.domain.spot.Spot;
import org.optaweb.employeerostering.service.roster.RosterService;
import org.optaweb.employeerostering.service.spot.SpotRepository;
import org.optaweb.employeerostering.util.ShiftRosterXlsxFileIO;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/tenant/{tenantId}/roster"})
@CrossOrigin
@Validated
@Api(tags={"Roster"})
public class RosterController {
    private final RosterService rosterService;
    private final SpotRepository spotRepository;

    public RosterController(RosterService rosterService, SpotRepository spotRepository) {
        this.rosterService = rosterService;
        Assert.notNull((Object)rosterService, (String)"rosterService must not be null.");
        this.spotRepository = spotRepository;
        Assert.notNull((Object)spotRepository, (String)"spotRepository must not be null.");
    }

    @ApiOperation(value="Get the current roster state")
    @GetMapping(value={"/{id}"})
    public ResponseEntity<RosterState> getRosterState(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId) {
        return new ResponseEntity((Object)this.rosterService.getRosterState(tenantId), HttpStatus.OK);
    }

    @ApiOperation(value="Get the current shift roster view")
    @GetMapping(value={"/shiftRosterView/current"})
    public ResponseEntity<ShiftRosterView> getCurrentShiftRosterView(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId, @RequestParam(name="p", required=false) Integer pageNumber, @RequestParam(name="n", required=false) Integer numberOfItemsPerPage) {
        return new ResponseEntity((Object)this.rosterService.getCurrentShiftRosterView(tenantId, pageNumber, numberOfItemsPerPage), HttpStatus.OK);
    }

    @ApiOperation(value="Get a shift roster view between two dates")
    @GetMapping(value={"/shiftRosterView"})
    public ResponseEntity<ShiftRosterView> getShiftRosterView(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId, @RequestParam(name="p", required=false) Integer pageNumber, @RequestParam(name="n", required=false) Integer numberOfItemsPerPage, @RequestParam(name="startDate") String startDateString, @RequestParam(name="endDate") String endDateString) {
        return new ResponseEntity((Object)this.rosterService.getShiftRosterView(tenantId, pageNumber, numberOfItemsPerPage, startDateString, endDateString), HttpStatus.OK);
    }

    @ApiOperation(value="Get a shift roster view between two dates for a subset of the spots")
    @PostMapping(value={"/shiftRosterView/for"})
    public ResponseEntity<ShiftRosterView> getShiftRosterViewFor(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId, @RequestParam(name="startDate") String startDateString, @RequestParam(name="endDate") String endDateString, @RequestBody @Valid List<Spot> spots) {
        return new ResponseEntity((Object)this.rosterService.getShiftRosterViewFor(tenantId, startDateString, endDateString, spots), HttpStatus.OK);
    }

    @ApiOperation(value="Get a shift roster view between two dates for a subset of the spots as an excel file")
    @GetMapping(value={"/shiftRosterView/excel"}, produces={"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"})
    public ResponseEntity<byte[]> getShiftRosterViewAsExcel(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId, @RequestParam(name="startDate") String startDateString, @RequestParam(name="endDate") String endDateString, @RequestParam(name="spotList") String spotListString) {
        Set spotIdSet = Arrays.stream(spotListString.split(",")).map(Long::parseLong).collect(Collectors.toSet());
        List<Spot> spotList = this.spotRepository.findAllByTenantId(tenantId, (Pageable)PageRequest.of((int)0, (int)Integer.MAX_VALUE)).stream().filter(s -> spotIdSet.contains(s.getId())).collect(Collectors.toList());
        if (spotList.size() != spotIdSet.size()) {
            return new ResponseEntity((Object)new byte[0], HttpStatus.BAD_REQUEST);
        }
        ShiftRosterView shiftRosterView = this.rosterService.getShiftRosterViewFor(tenantId, startDateString, endDateString, spotList);
        try {
            HttpHeaders responseHeaders = new HttpHeaders();
            responseHeaders.setContentDisposition(ContentDisposition.builder((String)"attachment").filename("Roster-" + startDateString + "--" + endDateString + ".xlsx").build());
            return new ResponseEntity((Object)ShiftRosterXlsxFileIO.getExcelBytesForShiftRoster(shiftRosterView), (MultiValueMap)responseHeaders, HttpStatus.OK);
        }
        catch (IOException e) {
            return new ResponseEntity((Object)new byte[0], HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @ApiOperation(value="Get the current availability roster view")
    @GetMapping(value={"/availabilityRosterView/current"})
    public ResponseEntity<AvailabilityRosterView> getCurrentAvailabilityRosterView(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId, @RequestParam(name="p", required=false) Integer pageNumber, @RequestParam(name="n", required=false) Integer numberOfItemsPerPage) {
        return new ResponseEntity((Object)this.rosterService.getCurrentAvailabilityRosterView(tenantId, pageNumber, numberOfItemsPerPage), HttpStatus.OK);
    }

    @ApiOperation(value="Get an availability roster view between two dates")
    @GetMapping(value={"/availabilityRosterView"})
    public ResponseEntity<AvailabilityRosterView> getAvailabilityRosterView(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId, @RequestParam(name="p", required=false) Integer pageNumber, @RequestParam(name="n", required=false) Integer numberOfItemsPerPage, @RequestParam(name="startDate") String startDateString, @RequestParam(name="endDate") String endDateString) {
        return new ResponseEntity((Object)this.rosterService.getAvailabilityRosterView(tenantId, pageNumber, numberOfItemsPerPage, startDateString, endDateString), HttpStatus.OK);
    }

    @ApiOperation(value="Get an availability roster view between two dates for a subset of the employees")
    @PostMapping(value={"/availabilityRosterView/for"})
    public ResponseEntity<AvailabilityRosterView> getAvailabilityRosterViewFor(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId, @RequestParam(name="startDate") String startDateString, @RequestParam(name="endDate") String endDateString, @RequestBody @Valid List<Employee> employees) {
        return new ResponseEntity((Object)this.rosterService.getAvailabilityRosterViewFor(tenantId, startDateString, endDateString, employees), HttpStatus.OK);
    }

    @ApiOperation(value="Start solving the roster. This will assign each shift to an employee")
    @PostMapping(value={"/solve"})
    public void solveRoster(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId) {
        this.rosterService.solveRoster(tenantId);
    }

    @ApiOperation(value="Start solving the roster in Nondisruptive mode. This will modify the publishschedule to make it feasible with minimal changes.")
    @PostMapping(value={"/replan"})
    public void replanRoster(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId) {
        this.rosterService.replanRoster(tenantId);
    }

    @ApiOperation(value="Stop solving the roster, if it hasn't terminated automatically already")
    @PostMapping(value={"/terminate"})
    public void terminateRosterEarly(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId) {
        this.rosterService.terminateRosterEarly(tenantId);
    }

    @ApiOperation(value="Get the status of the Solver")
    @GetMapping(value={"/status"})
    public ResponseEntity<SolverStatus> getSolverStatus(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId) {
        return new ResponseEntity((Object)this.rosterService.getSolverStatus(tenantId), HttpStatus.OK);
    }

    @ApiOperation(value="Provision shifts from particular time buckets into the given period")
    @PostMapping(value={"/provision"})
    public void provision(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId, @RequestParam Integer startRotationOffset, @RequestParam String fromDate, @RequestParam String toDate, @RequestBody List<Long> timeBucketIdList) {
        this.rosterService.provision(tenantId, startRotationOffset, LocalDate.parse(fromDate), LocalDate.parse(toDate), timeBucketIdList);
    }

    @ApiOperation(value="Publish the next set of draft shifts and create new draft shifts from the rotation template")
    @PostMapping(value={"/publishAndProvision"})
    public ResponseEntity<PublishResult> publishAndProvision(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId) {
        return new ResponseEntity((Object)this.rosterService.publishAndProvision(tenantId), HttpStatus.OK);
    }

    @ApiOperation(value="Updates the original employee to match adjusted schedule; essentially a republish without provision")
    @PostMapping(value={"/commitChanges"})
    public void commitChanges(@PathVariable @Min(value=0L) @Min(value=0L) Integer tenantId) {
        this.rosterService.commitChanges(tenantId);
    }
}

