/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.service.employee;

import java.util.List;
import org.optaweb.employeerostering.domain.employee.Employee;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface EmployeeRepository
extends JpaRepository<Employee, Long> {
    @Query(value="select e from Employee e where e.tenantId = :tenantId order by LOWER(e.name)")
    public List<Employee> findAllByTenantId(@Param(value="tenantId") Integer var1, Pageable var2);

    @Query(value="select e from Employee e where e.tenantId = :tenantId and e.name = :name")
    public Employee findEmployeeByName(@Param(value="tenantId") Integer var1, @Param(value="name") String var2);

    @Modifying(flushAutomatically=true, clearAutomatically=true)
    @Query(value="delete from Employee e where e.tenantId = :tenantId")
    public void deleteForTenant(@Param(value="tenantId") Integer var1);
}

