/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.persistence;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.plugin.persistence.LocationCrudRepository;
import org.optaweb.vehiclerouting.plugin.persistence.LocationEntity;
import org.optaweb.vehiclerouting.service.location.LocationRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
class LocationRepositoryImpl
implements LocationRepository {
    private static final Logger logger = LoggerFactory.getLogger(LocationRepositoryImpl.class);
    private final LocationCrudRepository repository;

    @Autowired
    LocationRepositoryImpl(LocationCrudRepository repository) {
        this.repository = repository;
    }

    public Location createLocation(Coordinates coordinates, String description) {
        LocationEntity locationEntity = (LocationEntity)this.repository.save((Object)new LocationEntity(coordinates.latitude(), coordinates.longitude(), description));
        Location location = LocationRepositoryImpl.toDomain((LocationEntity)locationEntity);
        logger.info("Created {}", (Object)location);
        return location;
    }

    public List<Location> locations() {
        return StreamSupport.stream(this.repository.findAll().spliterator(), false).map(LocationRepositoryImpl::toDomain).collect(Collectors.toList());
    }

    public Location removeLocation(long id) {
        Optional maybeLocation = this.repository.findById((Object)id);
        maybeLocation.ifPresent(locationEntity -> this.repository.deleteById((Object)id));
        LocationEntity locationEntity2 = (LocationEntity)maybeLocation.orElseThrow(() -> new IllegalArgumentException("Location{id=" + id + "} doesn't exist"));
        Location location = LocationRepositoryImpl.toDomain((LocationEntity)locationEntity2);
        logger.info("Deleted {}", (Object)location);
        return location;
    }

    public void removeAll() {
        this.repository.deleteAll();
    }

    public Optional<Location> find(long locationId) {
        return this.repository.findById((Object)locationId).map(LocationRepositoryImpl::toDomain);
    }

    private static Location toDomain(LocationEntity locationEntity) {
        return new Location(locationEntity.getId(), new Coordinates(locationEntity.getLatitude(), locationEntity.getLongitude()), locationEntity.getDescription());
    }
}

