/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.service.demo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.optaweb.vehiclerouting.domain.RoutingProblem;
import org.optaweb.vehiclerouting.service.demo.DemoProperties;
import org.optaweb.vehiclerouting.service.demo.DemoService;
import org.optaweb.vehiclerouting.service.demo.RoutingProblemList;
import org.optaweb.vehiclerouting.service.demo.dataset.DataSetMarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
class RoutingProblemConfig {
    private static final Logger logger = LoggerFactory.getLogger(RoutingProblemConfig.class);
    private final DemoProperties demoProperties;
    private final DataSetMarshaller dataSetMarshaller;

    @Autowired
    RoutingProblemConfig(DemoProperties demoProperties, DataSetMarshaller dataSetMarshaller) {
        this.demoProperties = demoProperties;
        this.dataSetMarshaller = dataSetMarshaller;
    }

    @Bean
    RoutingProblemList routingProblems() {
        ArrayList<RoutingProblem> problems = new ArrayList<RoutingProblem>();
        problems.add(this.dataSetMarshaller.unmarshal(RoutingProblemConfig.belgiumReader()));
        problems.addAll(this.localDataSets());
        return new RoutingProblemList(problems);
    }

    private static Reader belgiumReader() {
        return new InputStreamReader(DemoService.class.getResourceAsStream("belgium-cities.yaml"), StandardCharsets.UTF_8);
    }

    private static boolean isReadableDir(Path path) {
        File file = path.toFile();
        return file.exists() && file.canRead() && file.isDirectory();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<RoutingProblem> localDataSets() {
        Path dataSetDirPath = Paths.get(this.demoProperties.getDataSetDir(), new String[0]);
        if (!RoutingProblemConfig.isReadableDir((Path)dataSetDirPath)) {
            logger.warn("Data set directory '{}' doesn't exist or cannot be read. No external data sets will be loaded", (Object)dataSetDirPath.toAbsolutePath());
            return Collections.emptyList();
        }
        try (Stream<Path> dataSetPaths = Files.list(dataSetDirPath);){
            List<RoutingProblem> list = dataSetPaths.map(Path::toFile).filter(file -> file.getName().endsWith(".yaml") && file.exists() && file.canRead()).map(file -> {
                try {
                    return new InputStreamReader((InputStream)new FileInputStream((File)file), StandardCharsets.UTF_8);
                }
                catch (FileNotFoundException e) {
                    logger.error("Problem with dataset file {}", file, (Object)e);
                    return null;
                }
            }).filter(Objects::nonNull).map(arg_0 -> ((DataSetMarshaller)this.dataSetMarshaller).unmarshal(arg_0)).collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot list directory " + dataSetDirPath, e);
        }
    }
}

