/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.domain;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.optaweb.vehiclerouting.domain.LocationData;
import org.optaweb.vehiclerouting.domain.VehicleData;

public class RoutingProblem {
    private final String name;
    private final List<VehicleData> vehicles;
    private final LocationData depot;
    private final List<LocationData> visits;

    public RoutingProblem(String name, List<? extends VehicleData> vehicles, LocationData depot, List<? extends LocationData> visits) {
        this.name = Objects.requireNonNull(name);
        this.vehicles = new ArrayList(Objects.requireNonNull(vehicles));
        this.depot = depot;
        this.visits = new ArrayList(Objects.requireNonNull(visits));
    }

    public String name() {
        return this.name;
    }

    public Optional<LocationData> depot() {
        return Optional.ofNullable(this.depot);
    }

    public List<LocationData> visits() {
        return this.visits;
    }

    public List<VehicleData> vehicles() {
        return this.vehicles;
    }
}

