/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.domain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.domain.Vehicle;

public class Route {
    private final Vehicle vehicle;
    private final Location depot;
    private final List<Location> visits;

    public Route(Vehicle vehicle, Location depot, List<Location> visits) {
        this.vehicle = Objects.requireNonNull(vehicle);
        this.depot = Objects.requireNonNull(depot);
        this.visits = new ArrayList(Objects.requireNonNull(visits));
        if (visits.contains(depot)) {
            throw new IllegalArgumentException("Depot (" + depot + ") must not be one of the visits (" + visits + ")");
        }
        long uniqueVisits = visits.stream().distinct().count();
        if (uniqueVisits < (long)visits.size()) {
            long duplicates = (long)visits.size() - uniqueVisits;
            throw new IllegalArgumentException("Some visits have been visited multiple times (" + duplicates + ")");
        }
    }

    public Vehicle vehicle() {
        return this.vehicle;
    }

    public Location depot() {
        return this.depot;
    }

    public List<Location> visits() {
        return Collections.unmodifiableList(this.visits);
    }

    public String toString() {
        return "Route{vehicle=" + this.vehicle + ", depot=" + this.depot.id() + ", visits=" + this.visits.stream().map(Location::id).collect(Collectors.toList()) + "}";
    }
}

