/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.persistence;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.optaweb.vehiclerouting.domain.Vehicle;
import org.optaweb.vehiclerouting.domain.VehicleData;
import org.optaweb.vehiclerouting.domain.VehicleFactory;
import org.optaweb.vehiclerouting.plugin.persistence.VehicleCrudRepository;
import org.optaweb.vehiclerouting.plugin.persistence.VehicleEntity;
import org.optaweb.vehiclerouting.service.vehicle.VehicleRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class VehicleRepositoryImpl
implements VehicleRepository {
    private static final Logger logger = LoggerFactory.getLogger(VehicleRepositoryImpl.class);
    private final VehicleCrudRepository repository;

    public VehicleRepositoryImpl(VehicleCrudRepository repository) {
        this.repository = repository;
    }

    public Vehicle createVehicle(int capacity) {
        long id = ((VehicleEntity)this.repository.save((Object)new VehicleEntity(0L, null, capacity))).getId();
        VehicleEntity vehicleEntity = (VehicleEntity)this.repository.save((Object)new VehicleEntity(id, "Vehicle " + id, capacity));
        Vehicle vehicle = VehicleRepositoryImpl.toDomain((VehicleEntity)vehicleEntity);
        logger.info("Created vehicle {}.", (Object)vehicle);
        return vehicle;
    }

    public Vehicle createVehicle(VehicleData vehicleData) {
        VehicleEntity vehicleEntity = (VehicleEntity)this.repository.save((Object)new VehicleEntity(0L, vehicleData.name(), vehicleData.capacity()));
        Vehicle vehicle = VehicleRepositoryImpl.toDomain((VehicleEntity)vehicleEntity);
        logger.info("Created vehicle {}.", (Object)vehicle);
        return vehicle;
    }

    public List<Vehicle> vehicles() {
        return StreamSupport.stream(this.repository.findAll().spliterator(), false).map(VehicleRepositoryImpl::toDomain).collect(Collectors.toList());
    }

    public Vehicle removeVehicle(long id) {
        Optional optionalVehicleEntity = this.repository.findById((Object)id);
        VehicleEntity vehicleEntity = (VehicleEntity)optionalVehicleEntity.orElseThrow(() -> new IllegalArgumentException("Vehicle{id=" + id + "} doesn't exist"));
        this.repository.deleteById((Object)id);
        Vehicle vehicle = VehicleRepositoryImpl.toDomain((VehicleEntity)vehicleEntity);
        logger.info("Deleted vehicle {}.", (Object)vehicle);
        return vehicle;
    }

    public void removeAll() {
        this.repository.deleteAll();
    }

    public Optional<Vehicle> find(long vehicleId) {
        return this.repository.findById((Object)vehicleId).map(VehicleRepositoryImpl::toDomain);
    }

    public void update(Vehicle vehicle) {
        this.repository.save((Object)new VehicleEntity(vehicle.id(), vehicle.name(), vehicle.capacity()));
    }

    private static Vehicle toDomain(VehicleEntity vehicleEntity) {
        return VehicleFactory.createVehicle((long)vehicleEntity.getId(), (String)vehicleEntity.getName(), (int)vehicleEntity.getCapacity());
    }
}

