/*
 * Decompiled with CFR 0.152.
 */
package org.cts.crs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cts.IdentifiableComponent;
import org.cts.Identifier;
import org.cts.crs.CoordinateReferenceSystem;
import org.cts.cs.CoordinateSystem;
import org.cts.datum.GeodeticDatum;
import org.cts.op.CoordinateOperation;
import org.cts.op.CoordinateOperationSequence;
import org.cts.op.NonInvertibleOperationException;
import org.cts.op.projection.Projection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GeodeticCRS
extends IdentifiableComponent
implements CoordinateReferenceSystem {
    private GeodeticDatum geodeticDatum;
    private Map<GeodeticDatum, List<CoordinateOperation>> nadgridsTransformations = new HashMap<GeodeticDatum, List<CoordinateOperation>>();
    private Map<CoordinateReferenceSystem, List<CoordinateOperation>> crsTransformations = new HashMap<CoordinateReferenceSystem, List<CoordinateOperation>>();
    protected CoordinateSystem coordinateSystem;

    @Override
    public Projection getProjection() {
        return null;
    }

    protected GeodeticCRS(Identifier identifier, GeodeticDatum datum, CoordinateSystem coordinateSystem) {
        super(identifier);
        this.geodeticDatum = datum;
        this.coordinateSystem = coordinateSystem;
    }

    @Override
    public abstract CoordinateReferenceSystem.Type getType();

    @Override
    public CoordinateSystem getCoordinateSystem() {
        return this.coordinateSystem;
    }

    public int getDimension() {
        return this.coordinateSystem.getDimension();
    }

    @Override
    public GeodeticDatum getDatum() {
        return this.geodeticDatum;
    }

    public boolean isValid(double[] coord) {
        return this.geodeticDatum.getExtent().isInside(coord);
    }

    public void addGridTransformation(GeodeticDatum gd, CoordinateOperation coordOp) {
        if (this.nadgridsTransformations.get(gd) == null) {
            this.nadgridsTransformations.put(gd, new ArrayList());
        }
        this.nadgridsTransformations.get(gd).add(coordOp);
    }

    public Map<GeodeticDatum, List<CoordinateOperation>> getGridTransformations() {
        return this.nadgridsTransformations;
    }

    public List<CoordinateOperation> getGridTransformations(GeodeticDatum datum) {
        if (this.nadgridsTransformations.get(datum) == null && this.nadgridsTransformations.get(GeodeticDatum.WGS84) != null) {
            ArrayList<CoordinateOperation> opList = new ArrayList<CoordinateOperation>();
            opList.add(new CoordinateOperationSequence(new Identifier(CoordinateOperation.class), this.nadgridsTransformations.get(GeodeticDatum.WGS84).get(0), GeodeticDatum.WGS84.getCoordinateOperations(datum).get(0)));
            return opList;
        }
        return this.nadgridsTransformations.get(datum);
    }

    public void addCRSTransformation(CoordinateReferenceSystem crs, List<CoordinateOperation> opList) {
        this.crsTransformations.put(crs, opList);
    }

    public Map<CoordinateReferenceSystem, List<CoordinateOperation>> getCRSTransformations() {
        return this.crsTransformations;
    }

    public List<CoordinateOperation> getCRSTransformations(CoordinateReferenceSystem crs) {
        return this.crsTransformations.get(crs);
    }

    public abstract CoordinateOperation toGeographicCoordinateConverter() throws NonInvertibleOperationException;

    public abstract CoordinateOperation fromGeographicCoordinateConverter() throws NonInvertibleOperationException;

    @Override
    public abstract String toWKT();

    @Override
    public String toString() {
        return "[" + this.getAuthorityName() + ":" + this.getAuthorityKey() + "] " + this.getName();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof GeodeticCRS) {
            GeodeticCRS crs = (GeodeticCRS)o;
            if (!this.getType().equals((Object)crs.getType())) {
                return false;
            }
            if (this.getIdentifier().equals(crs.getIdentifier())) {
                return true;
            }
            boolean nadgrids = this.getGridTransformations() == null ? crs.getGridTransformations() == null : this.getGridTransformations().equals(crs.getGridTransformations());
            return this.getDatum().equals(crs.getDatum()) && nadgrids && this.getCoordinateSystem().equals(crs.getCoordinateSystem());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + (this.geodeticDatum != null ? this.geodeticDatum.hashCode() : 0);
        hash = 29 * hash + (this.coordinateSystem != null ? this.coordinateSystem.hashCode() : 0);
        return hash;
    }
}

