/*
 * Decompiled with CFR 0.152.
 */
package org.cts.cs;

import org.cts.CoordinateDimensionException;
import org.cts.cs.Axis;
import org.cts.units.Unit;

public class CoordinateSystem {
    private Axis[] axes;
    private Unit[] units;

    public CoordinateSystem(Axis[] axes, Unit[] units) {
        assert (axes.length == units.length);
        this.axes = axes;
        this.units = units;
    }

    public Axis getAxis(int i) throws ArrayIndexOutOfBoundsException {
        try {
            return this.axes[i];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Try to access Axis " + (i + 1) + " in a " + this.axes.length + "-d CoordinateSystem");
        }
    }

    public Unit getUnit(int i) throws ArrayIndexOutOfBoundsException {
        try {
            return this.units[i];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Try to access unit of Axis " + (i + 1) + " in a " + this.axes.length + "-d CoordinateSystem");
        }
    }

    public int getDimension() {
        return this.axes.length;
    }

    public int getIndex(Axis axis) {
        for (int i = 0; i < this.axes.length; ++i) {
            if (this.axes[i] != axis) continue;
            return i;
        }
        return -1;
    }

    public String format(double[] coord) throws CoordinateDimensionException {
        if (coord.length < this.axes.length) {
            throw new CoordinateDimensionException(coord, this.axes.length);
        }
        StringBuilder sb = new StringBuilder(64);
        for (int i = 0; i < this.axes.length; ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            sb.append("").append(this.axes[i]).append("=").append(coord[i]);
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.axes.length; ++i) {
            sb.append(i > 0 ? "|" : "").append(this.axes[i].toString()).append(" (").append(this.units[i].getSymbol()).append(")");
        }
        return sb.toString();
    }
}

