/*
 * Decompiled with CFR 0.152.
 */
package org.cts.datum;

import java.util.HashMap;
import java.util.Map;
import org.cts.IdentifiableComponent;
import org.cts.Identifier;

public class Ellipsoid
extends IdentifiableComponent {
    private static final double PI_2 = 1.5707963267948966;
    public static final Ellipsoid SPHERE = Ellipsoid.createEllipsoidFromSemiMinorAxis(new Identifier("EPSG", "7035", "SPHERE"), 6371000.0, 6371000.0);
    public static final Ellipsoid GRS80 = Ellipsoid.createEllipsoidFromInverseFlattening(new Identifier("EPSG", "7019", "GRS 1980", "GRS80"), 6378137.0, 298.257222101);
    public static final Ellipsoid WGS84 = Ellipsoid.createEllipsoidFromInverseFlattening(new Identifier("EPSG", "7030", "WGS 84", "WGS84"), 6378137.0, 298.257223563);
    public static final Ellipsoid INTERNATIONAL1924 = Ellipsoid.createEllipsoidFromInverseFlattening(new Identifier("EPSG", "7022", "Intenational 1924", "Int_1924"), 6378388.0, 297.0);
    public static final Ellipsoid BESSEL1841 = Ellipsoid.createEllipsoidFromInverseFlattening(new Identifier("EPSG", "7004", "Bessel 1841", "Bessel_1841"), 6377397.155, 299.1528128);
    public static final Ellipsoid CLARKE1866 = Ellipsoid.createEllipsoidFromSemiMinorAxis(new Identifier("EPSG", "7008", "Clarke 1866", "Clarke_1866"), 6378206.4, 6356583.8);
    public static final Ellipsoid CLARKE1880IGN = Ellipsoid.createEllipsoidFromSemiMinorAxis(new Identifier("EPSG", "7011", "Clarke 1880 (IGN)", "Clarke_1880_IGN"), 6378249.2, 6356515.0);
    public static final Ellipsoid CLARKE1880RGS = Ellipsoid.createEllipsoidFromInverseFlattening(new Identifier("EPSG", "7012", "Clarke 1880 (RGS)", "Clarke_1880_mod"), 6378249.2, 293.465);
    public static final Ellipsoid CLARKE1880ARC = Ellipsoid.createEllipsoidFromInverseFlattening(new Identifier("EPSG", "7013", "Clarke 1880 (Arc)", "Clarke_1880_Arc"), 6378249.145, 293.4663077);
    public static final Ellipsoid KRASSOWSKI = Ellipsoid.createEllipsoidFromInverseFlattening(new Identifier("EPSG", "7024", "Krassowski 1940", "Krassowski_1940"), 6378245.0, 298.3);
    public static final Ellipsoid EVERESTSS = Ellipsoid.createEllipsoidFromInverseFlattening(new Identifier("EPSG", "7016", "Everest 1830 (1967 Definition)", "evrstSS"), 6377298.556, 300.8017);
    public static final Ellipsoid GRS67 = Ellipsoid.createEllipsoidFromInverseFlattening(new Identifier("EPSG", "7036", "GRS 1967", "GRS67"), 6378160.0, 298.247167427);
    public static final Ellipsoid AustSA = Ellipsoid.createEllipsoidFromInverseFlattening(new Identifier("EPSG", "7050", "GRS 1967 (SAD 1969)", "aust_SA"), 6378160.0, 298.25);
    public static final Ellipsoid AIRY = Ellipsoid.createEllipsoidFromInverseFlattening(new Identifier("EPSG", "7001", "AIRY 1830", "airy"), 6377563.396, 299.3249646);
    public static final Ellipsoid BESSNAM = Ellipsoid.createEllipsoidFromInverseFlattening(new Identifier("EPSG", "7046", "Bessel Namibia (GLM)", "bess_nam"), 6377483.865280419, 299.1528128);
    public static final Ellipsoid HELMERT = Ellipsoid.createEllipsoidFromInverseFlattening(new Identifier("EPSG", "7020", "Helmert 1906", "helmert"), 6378200.0, 298.3);
    public static final Ellipsoid AIRYMOD = Ellipsoid.createEllipsoidFromInverseFlattening(new Identifier("EPSG", "7002", "Airy Modified 1849", "mod_airy"), 6377340.189, 299.3249646);
    public static final Ellipsoid WGS66 = Ellipsoid.createEllipsoidFromInverseFlattening(new Identifier("EPSG", "7025", "WGS 66", "WGS66"), 6378145.0, 298.25);
    public static final Ellipsoid WGS72 = Ellipsoid.createEllipsoidFromInverseFlattening(new Identifier("EPSG", "7043", "WGS 72", "WGS72"), 6378135.0, 298.26);
    final SecondParameter secondParameter;
    private final double a;
    private final double b;
    private final double f;
    private final double invf;
    private final double e;
    private final double e2;
    private final double eprime2;
    private transient double[] arc_coeff;
    private transient double[] dir_utm_coeff;
    private transient double[] inv_utm_coeff;
    private transient double[] kk;
    private transient double[] inv_merc_coeff;
    public static final Map<String, Ellipsoid> ellipsoidFromName = new HashMap<String, Ellipsoid>();

    private Ellipsoid(Identifier identifier, double semiMajorAxis, SecondParameter secondParameter, double secondParameterValue) throws IllegalArgumentException {
        super(identifier);
        this.a = semiMajorAxis;
        this.secondParameter = secondParameter;
        switch (secondParameter) {
            case InverseFlattening: {
                this.invf = secondParameterValue;
                this.f = 1.0 / this.invf;
                this.b = this.a - this.a / this.invf;
                this.e2 = (2.0 - 1.0 / this.invf) / this.invf;
                this.e = Math.sqrt(this.e2);
                break;
            }
            case SemiMinorAxis: {
                this.b = secondParameterValue;
                this.f = 1.0 - this.b / this.a;
                this.invf = this.a / (this.a - this.b);
                this.e2 = 1.0 - this.b * this.b / (this.a * this.a);
                this.e = Math.sqrt((this.a * this.a - this.b * this.b) / (this.a * this.a));
                break;
            }
            case Eccentricity: {
                this.e = secondParameterValue;
                this.e2 = this.e * this.e;
                this.b = this.a * Math.sqrt(1.0 - this.e2);
                this.f = 1.0 - Math.sqrt(1.0 - this.e2);
                this.invf = 1.0 / (1.0 - Math.sqrt(1.0 - this.e2));
                break;
            }
            default: {
                this.b = this.a;
                this.f = 0.0;
                this.invf = Double.POSITIVE_INFINITY;
                this.e = 0.0;
                this.e2 = 0.0;
            }
        }
        this.eprime2 = this.e2 / (1.0 - this.e2);
    }

    public double getSemiMajorAxis() {
        return this.a;
    }

    public double getInverseFlattening() {
        return this.invf;
    }

    public double getSemiMinorAxis() {
        return this.b;
    }

    public double getFlattening() {
        return this.f;
    }

    public double getEccentricity() {
        return this.e;
    }

    public double getSquareEccentricity() {
        return this.e2;
    }

    public double getSecondEccentricitySquared() {
        return this.e2 / (1.0 - this.e2);
    }

    public double[] getArcCoeff() {
        if (this.arc_coeff == null) {
            this.initMeridianArcCoefficients();
        }
        return this.arc_coeff;
    }

    public double[] getKCoeff(int max) {
        this.initKCoeff(max);
        return this.kk;
    }

    public static Ellipsoid createEllipsoidFromInverseFlattening(double semiMajorAxis, double invFlattening) throws IllegalArgumentException {
        Identifier id = new Identifier(Ellipsoid.class);
        Ellipsoid ellps = new Ellipsoid(id, semiMajorAxis, SecondParameter.InverseFlattening, invFlattening);
        return ellps.checkExistingEllipsoid();
    }

    public static Ellipsoid createEllipsoidFromInverseFlattening(Identifier identifier, double semiMajorAxis, double invFlattening) throws IllegalArgumentException {
        Ellipsoid ellps = new Ellipsoid(identifier, semiMajorAxis, SecondParameter.InverseFlattening, invFlattening);
        return ellps.checkExistingEllipsoid();
    }

    public static Ellipsoid createEllipsoidFromSemiMinorAxis(double semiMajorAxis, double semiMinorAxis) throws IllegalArgumentException {
        Identifier id = new Identifier(Ellipsoid.class);
        Ellipsoid ellps = new Ellipsoid(id, semiMajorAxis, SecondParameter.SemiMinorAxis, semiMinorAxis);
        return ellps.checkExistingEllipsoid();
    }

    public static Ellipsoid createEllipsoidFromSemiMinorAxis(Identifier identifier, double semiMajorAxis, double semiMinorAxis) throws IllegalArgumentException {
        Ellipsoid ellps = new Ellipsoid(identifier, semiMajorAxis, SecondParameter.SemiMinorAxis, semiMinorAxis);
        return ellps.checkExistingEllipsoid();
    }

    public static Ellipsoid createEllipsoidFromEccentricity(double semiMajorAxis, double eccentricity) throws IllegalArgumentException {
        Identifier id = new Identifier(Ellipsoid.class);
        Ellipsoid ellps = new Ellipsoid(id, semiMajorAxis, SecondParameter.Eccentricity, eccentricity);
        return ellps.checkExistingEllipsoid();
    }

    public static Ellipsoid createEllipsoidFromEccentricity(Identifier identifier, double semiMajorAxis, double eccentricity) throws IllegalArgumentException {
        Ellipsoid ellps = new Ellipsoid(identifier, semiMajorAxis, SecondParameter.Eccentricity, eccentricity);
        return ellps.checkExistingEllipsoid();
    }

    private Ellipsoid checkExistingEllipsoid() {
        if (this.equals(GRS80)) {
            return GRS80;
        }
        if (this.equals(WGS84)) {
            return WGS84;
        }
        if (this.equals(INTERNATIONAL1924)) {
            return INTERNATIONAL1924;
        }
        if (this.equals(CLARKE1866)) {
            return CLARKE1866;
        }
        if (this.equals(CLARKE1880ARC)) {
            return CLARKE1880ARC;
        }
        if (this.equals(CLARKE1880IGN)) {
            return CLARKE1880IGN;
        }
        if (this.equals(CLARKE1880RGS)) {
            return CLARKE1880RGS;
        }
        if (this.equals(SPHERE)) {
            return SPHERE;
        }
        if (this.equals(BESSEL1841)) {
            return BESSEL1841;
        }
        if (this.equals(KRASSOWSKI)) {
            return KRASSOWSKI;
        }
        if (this.equals(GRS67)) {
            return GRS67;
        }
        if (this.equals(AustSA)) {
            return AustSA;
        }
        if (this.equals(AIRY)) {
            return AIRY;
        }
        if (this.equals(AIRYMOD)) {
            return AIRYMOD;
        }
        if (this.equals(BESSNAM)) {
            return BESSNAM;
        }
        if (this.equals(HELMERT)) {
            return HELMERT;
        }
        if (this.equals(WGS66)) {
            return WGS66;
        }
        if (this.equals(WGS72)) {
            return WGS72;
        }
        return this;
    }

    private void initMeridianArcCoefficients() {
        double e4 = this.e2 * this.e2;
        double e6 = e4 * this.e2;
        double e8 = e4 * e4;
        this.arc_coeff = new double[5];
        this.arc_coeff[0] = 1.0 - this.e2 * 1.0 / 4.0 - e4 * 3.0 / 64.0 - e6 * 5.0 / 256.0 - e8 * 175.0 / 16384.0;
        this.arc_coeff[1] = -this.e2 * 3.0 / 8.0 - e4 * 3.0 / 32.0 - e6 * 45.0 / 1024.0 - e8 * 105.0 / 4096.0;
        this.arc_coeff[2] = e4 * 15.0 / 256.0 + e6 * 45.0 / 1024.0 + e8 * 525.0 / 16384.0;
        this.arc_coeff[3] = -e6 * 35.0 / 3072.0 - e8 * 175.0 / 12288.0;
        this.arc_coeff[4] = e8 * 315.0 / 131072.0;
    }

    public void initKCoeff(int max) {
        if (max < 1) {
            max = 1;
        }
        if (max > 8) {
            max = 8;
        }
        this.kk = new double[max];
        double c = 1.0;
        for (int n = 1; n <= max; ++n) {
            double n2 = 2.0 * (double)n;
            c *= (n2 - 1.0) * (n2 - 3.0) / n2 / n2 * this.e2;
            int m = 0;
            while (m < n) {
                int n3 = m++;
                this.kk[n3] = this.kk[n3] + c;
            }
        }
    }

    private double k1() {
        if (this.kk == null) {
            this.initKCoeff(5);
        }
        return 1.0 + this.kk[0];
    }

    private double k2(double beta_rad) {
        if (this.kk == null) {
            this.initKCoeff(5);
        }
        double cos2 = Math.cos(beta_rad) * Math.cos(beta_rad);
        double result = this.kk[0];
        double k = 1.0;
        for (int n = 1; n < this.kk.length; ++n) {
            result += this.kk[n] * (k *= 2.0 * (double)n / (2.0 * (double)n + 1.0) * cos2);
        }
        return result;
    }

    public double arcFromLat(double phi) {
        double beta = Math.atan((1.0 - this.f) * Math.tan(phi));
        return this.a * beta * this.k1() + this.a / 2.0 * Math.sin(2.0 * beta) * this.k2(beta);
    }

    public double latFromArc(double s) throws ArithmeticException {
        double beta0;
        int MAXITER = 10;
        double beta = beta0 = s / this.a / this.k1();
        double betaold = 1.0E30;
        int iter = 0;
        while (++iter < 10 && Math.abs(beta - betaold) > 1.0E-15) {
            betaold = beta;
            beta = beta0 - this.k2(beta) / 2.0 / this.k1() * Math.sin(2.0 * beta);
        }
        if (iter == 10) {
            throw new ArithmeticException("The latitudeFromArc method diverges");
        }
        return Math.atan(Math.tan(beta) / (1.0 - this.f));
    }

    public final double meridionalRadiusOfCurvature(double latitude) {
        double sinlat = Math.sin(latitude);
        return this.a * (1.0 - this.e2) / Math.pow(1.0 - this.e2 * sinlat * sinlat, 1.5);
    }

    public final double transverseRadiusOfCurvature(double latitude) {
        double sinlat = Math.sin(latitude);
        return this.a / Math.sqrt(1.0 - this.e2 * sinlat * sinlat);
    }

    public final double grandeNormale(double latitude) {
        double sinlat = Math.sin(latitude);
        return this.a / Math.sqrt(1.0 - this.e2 * sinlat * sinlat);
    }

    public final double isometricLatitude(double latitude) {
        double esinlat = this.e * Math.sin(latitude);
        return Math.log(Math.tan((1.5707963267948966 + latitude) / 2.0) * Math.pow((1.0 - esinlat) / (1.0 + esinlat), this.e / 2.0));
    }

    public final double latitude(double isoLatitude, double epsilon) {
        double lat0;
        double exp_isolatitude = Math.exp(isoLatitude);
        double lati = lat0 = 2.0 * Math.atan(exp_isolatitude) - 1.5707963267948966;
        double latj = 1000.0;
        while (Math.abs(latj - lati) >= epsilon) {
            lati = latj;
            double esinlat = this.e * Math.sin(lati);
            latj = 2.0 * Math.atan(Math.pow((1.0 + esinlat) / (1.0 - esinlat), this.e / 2.0) * exp_isolatitude) - 1.5707963267948966;
        }
        return latj;
    }

    public final double latitude(double isoLatitude) {
        return this.latitude(isoLatitude, 1.0E-11);
    }

    public double curvilinearAbscissa(double latitude) {
        if (this.arc_coeff == null) {
            this.initMeridianArcCoefficients();
        }
        return this.arc_coeff[0] * latitude + this.arc_coeff[1] * Math.sin(2.0 * latitude) + this.arc_coeff[2] * Math.sin(4.0 * latitude) + this.arc_coeff[3] * Math.sin(6.0 * latitude) + this.arc_coeff[4] * Math.sin(8.0 * latitude);
    }

    public String toWKT() {
        StringBuilder w = new StringBuilder();
        w.append("SPHEROID[\"");
        w.append(this.getName());
        w.append("\",");
        w.append(this.getSemiMajorAxis());
        w.append(',');
        if (this.getInverseFlattening() != Double.POSITIVE_INFINITY) {
            w.append(this.getInverseFlattening());
        } else {
            w.append(0);
        }
        if (!this.getAuthorityName().startsWith("LOCAL")) {
            w.append(',');
            w.append(this.getIdentifier().toWKT());
        }
        w.append(']');
        return w.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getIdentifier().toString());
        sb.append(" (Semi-major axis = ").append(this.a);
        switch (this.secondParameter) {
            case SemiMinorAxis: {
                sb.append(" | ").append("Semi-minor axis = ").append(this.b).append(")");
                break;
            }
            case InverseFlattening: {
                sb.append(" | ").append("Flattening = 1/").append(this.invf).append(")");
                break;
            }
            case Eccentricity: {
                sb.append(" | ").append("Eccentricity = ").append(this.e).append(")");
                break;
            }
            default: {
                sb.append(")");
            }
        }
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Ellipsoid) {
            Ellipsoid ell = (Ellipsoid)other;
            if (this.getCode().equals(ell.getCode())) {
                return true;
            }
            double a2 = ell.getSemiMajorAxis();
            double b2 = ell.getSemiMinorAxis();
            return Math.abs(a2 - this.a) < 1.0E-4 && Math.abs(b2 - this.b) < 1.0E-4;
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + (int)(Double.doubleToLongBits(this.a) ^ Double.doubleToLongBits(this.a) >>> 32);
        hash = 97 * hash + (int)(Double.doubleToLongBits(this.b) ^ Double.doubleToLongBits(this.b) >>> 32);
        return hash;
    }

    static {
        ellipsoidFromName.put("airy", AIRY);
        ellipsoidFromName.put("austsa", AustSA);
        ellipsoidFromName.put("bessel", BESSEL1841);
        ellipsoidFromName.put("bessnam", BESSNAM);
        ellipsoidFromName.put("clrk66", CLARKE1866);
        ellipsoidFromName.put("clrk80", CLARKE1880RGS);
        ellipsoidFromName.put("clrk80ign", CLARKE1880IGN);
        ellipsoidFromName.put("clrk80arc", CLARKE1880ARC);
        ellipsoidFromName.put("evrstss", EVERESTSS);
        ellipsoidFromName.put("grs67", GRS67);
        ellipsoidFromName.put("grs80", GRS80);
        ellipsoidFromName.put("helmert", HELMERT);
        ellipsoidFromName.put("intl", INTERNATIONAL1924);
        ellipsoidFromName.put("airymod", AIRYMOD);
        ellipsoidFromName.put("krass", KRASSOWSKI);
        ellipsoidFromName.put("wgs66", WGS66);
        ellipsoidFromName.put("wgs72", WGS72);
        ellipsoidFromName.put("wgs84", WGS84);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SecondParameter {
        InverseFlattening,
        SemiMinorAxis,
        Eccentricity;

    }
}

