/*
 * Decompiled with CFR 0.152.
 */
package org.cts.units;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.cts.Identifiable;
import org.cts.IdentifiableComponent;
import org.cts.Identifier;
import org.cts.parser.prj.PrjWriter;
import org.cts.units.Quantity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Unit
extends IdentifiableComponent
implements Serializable {
    private static Map<Quantity, Map<String, Unit>> map = new HashMap<Quantity, Map<String, Unit>>();
    private static Map<Quantity, Unit> baseUnits = new HashMap<Quantity, Unit>();
    public static final Unit RADIAN = new Unit(Quantity.ANGLE, new Identifier("EPSG", "9101", "radian", "rad"));
    public static final Unit DEGREE = new Unit(Quantity.ANGLE, Math.PI / 180, new Identifier("EPSG", "9122", "degree", "\u00b0"));
    public static final Unit ARC_MINUTE = new Unit(Quantity.ANGLE, 2.908882086657216E-4, new Identifier("EPSG", "9103", "minute", "'"));
    public static final Unit ARC_SECOND = new Unit(Quantity.ANGLE, 4.84813681109536E-6, new Identifier("EPSG", "9104", "second", "\""));
    public static final Unit GRAD = new Unit(Quantity.ANGLE, 0.015707963267948967, new Identifier("EPSG", "9105", "grad", "g"));
    public static final Unit METER;
    public static final Unit MILLIMETER;
    public static final Unit CENTIMETER;
    public static final Unit DECIMETER;
    public static final Unit KILOMETER;
    public static final Unit FOOT;
    public static final Unit USFOOT;
    public static final Unit YARD;
    public static final Unit UNIT;
    public static final Unit SECOND;
    private Quantity quantity;
    private double scale;
    private double offset = 0.0;

    public static Unit getUnit(Quantity quantity, String symbol) {
        Map<String, Unit> unts = map.get(quantity);
        if (unts == null) {
            return null;
        }
        return unts.get(symbol);
    }

    public static Unit getBaseUnit(Quantity quantity) {
        return baseUnits.get(quantity);
    }

    public ArrayList<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Identifiable id : this.getAliases()) {
            if (names.contains(id.getName())) continue;
            names.add(id.getName());
        }
        return names;
    }

    public Unit(Quantity quantity, Identifier id) {
        this(quantity, 1.0, 0.0, id);
    }

    public Unit(Quantity quantity, double scale, Identifier id) {
        this(quantity, scale, 0.0, id);
    }

    public Unit(Quantity quantity, double scale, double offset, Identifier id) {
        super(id);
        this.quantity = quantity;
        this.scale = scale;
        this.offset = offset;
        this.registerUnit();
    }

    private void registerUnit() {
        Map<String, Unit> unts = map.get(this.quantity);
        if (unts == null) {
            map.put(this.quantity, new HashMap());
        }
        map.get(this.quantity).put(this.getShortName(), this);
        if (this.scale == 1.0 && this.offset == 0.0) {
            baseUnits.put(this.quantity, this);
        }
    }

    public Quantity getQuantity() {
        return this.quantity;
    }

    public double getScale() {
        return this.scale;
    }

    public double getOffset() {
        return this.offset;
    }

    public double toBaseUnit(double measure) {
        return measure * this.scale + this.offset;
    }

    public double fromBaseUnit(double measure) {
        return (measure - this.offset) / this.scale;
    }

    public String getSymbol() {
        return this.getShortName();
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public Unit getBaseUnit() {
        Unit baseUnit = baseUnits.get(this.quantity);
        return baseUnits == null ? new Unit(this.quantity, new Identifier(Unit.class, "UNKNOWN", "")) : baseUnit;
    }

    public boolean isComparable(Unit anotherUnit) {
        return this.quantity.equals(anotherUnit.getQuantity());
    }

    public String toWKT() {
        StringBuilder w = new StringBuilder();
        w.append("UNIT[\"");
        w.append(this.getName());
        w.append("\",");
        w.append(PrjWriter.roundToString(this.getScale(), 1.0E-11));
        if (!this.getAuthorityName().startsWith("LOCAL")) {
            w.append(',');
            w.append(this.getIdentifier().toWKT());
        }
        w.append(']');
        return w.toString();
    }

    @Override
    public String toString() {
        return this.getName() + " (" + this.quantity + (this.scale != 1.0 ? " : " + this.scale + this.getBaseUnit().getSymbol() : "") + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Unit) {
            Unit unit = (Unit)o;
            return this.quantity.equals(unit.getQuantity()) && this.scale == unit.getScale() && this.offset == unit.getOffset();
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 59 * hash + (this.quantity != null ? this.quantity.hashCode() : 0);
        hash = 59 * hash + (int)(Double.doubleToLongBits(this.scale) ^ Double.doubleToLongBits(this.scale) >>> 32);
        hash = 59 * hash + (int)(Double.doubleToLongBits(this.offset) ^ Double.doubleToLongBits(this.offset) >>> 32);
        return hash;
    }

    static {
        FOOT = new Unit(Quantity.LENGTH, 0.3048, new Identifier("EPSG", "9002", "foot", "ft"));
        USFOOT = new Unit(Quantity.LENGTH, 0.0, new Identifier("EPSG", "9003", "foot_us", "us-ft"));
        YARD = new Unit(Quantity.LENGTH, 0.9144, new Identifier("EPSG", "9096", "yard", "yd"));
        UNIT = new Unit(Quantity.NODIM, new Identifier(Unit.class, "no dimension", ""));
        SECOND = new Unit(Quantity.TIME, new Identifier(Unit.class, "second", "s"));
        Identifier id = new Identifier("EPSG", "9001", "metre", "m");
        ArrayList<Identifiable> aliases = new ArrayList<Identifiable>();
        aliases.add(id);
        METER = new Unit(Quantity.LENGTH, new Identifier("EPSG", "9001", "meter", "m", "", aliases));
        id = new Identifier(Unit.class, "millimetre", "mm");
        aliases = new ArrayList();
        aliases.add(id);
        MILLIMETER = new Unit(Quantity.LENGTH, 0.001, new Identifier(Unit.class, "millimeter", "mm", aliases));
        id = new Identifier(Unit.class, "centimetre", "cm");
        aliases = new ArrayList();
        aliases.add(id);
        CENTIMETER = new Unit(Quantity.LENGTH, 0.01, new Identifier(Unit.class, "centimeter", "cm", aliases));
        id = new Identifier(Unit.class, "decimetre", "dm");
        aliases = new ArrayList();
        aliases.add(id);
        DECIMETER = new Unit(Quantity.LENGTH, 0.1, new Identifier(Unit.class, "decimeter", "dm", aliases));
        id = new Identifier("EPSG", "9036", "kilometre", "km");
        aliases = new ArrayList();
        aliases.add(id);
        KILOMETER = new Unit(Quantity.LENGTH, 1000.0, new Identifier("EPSG", "9036", "kilometer", "km", "", aliases));
    }
}

