/*
 * Decompiled with CFR 0.152.
 */
package org.cts.datum;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.cts.Identifier;
import org.cts.cs.GeographicExtent;
import org.cts.datum.AbstractDatum;
import org.cts.datum.Datum;
import org.cts.datum.Ellipsoid;
import org.cts.datum.PrimeMeridian;
import org.cts.op.AbstractCoordinateOperation;
import org.cts.op.CoordinateOperation;
import org.cts.op.CoordinateOperationSequence;
import org.cts.op.Geocentric2Geographic;
import org.cts.op.Geographic2Geocentric;
import org.cts.op.Identity;
import org.cts.op.LongitudeRotation;
import org.cts.op.NonInvertibleOperationException;
import org.cts.op.transformation.GeoTransformation;
import org.cts.op.transformation.GeocentricTranslation;
import org.cts.op.transformation.SevenParameterTransformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeodeticDatum
extends AbstractDatum {
    public static final Map<String, GeodeticDatum> datumFromName = new HashMap<String, GeodeticDatum>();
    private Map<Datum, List<CoordinateOperation>> datumTransformations = new HashMap<Datum, List<CoordinateOperation>>();
    private final PrimeMeridian primeMeridian;
    private final Ellipsoid ellipsoid;
    private CoordinateOperation toWGS84;
    public static final GeodeticDatum WGS84 = new GeodeticDatum(new Identifier("EPSG", "6326", "World Geodetic System 1984", "WGS 84"), PrimeMeridian.GREENWICH, Ellipsoid.WGS84, GeographicExtent.WORLD, null, null);
    public static final GeodeticDatum NTF_PARIS = new GeodeticDatum(new Identifier("EPSG", "6807", "Nouvelle Triangulation Fran\u00e7aise (Paris)", "NTF (Paris)"), PrimeMeridian.PARIS, Ellipsoid.CLARKE1880IGN, GeographicExtent.WORLD, "Fundamental point: Pantheon. Latitude: 48 deg 50 min 46.52 sec N; Longitude: 2 deg 20 min 48.67 sec E (of Greenwich).", "1895");
    public static final GeodeticDatum NTF = new GeodeticDatum(new Identifier("EPSG", "6275", "Nouvelle Triangulation Fran\u00e7aise", "NTF"), PrimeMeridian.GREENWICH, Ellipsoid.CLARKE1880IGN, GeographicExtent.WORLD, "Fundamental point: Pantheon. Latitude: 48 deg 50 min 46.522 sec N; Longitude: 2 deg 20 min 48.667 sec E (of Greenwich).", "1898");
    public static final GeodeticDatum RGF93 = new GeodeticDatum(new Identifier("EPSG", "6171", "R\u00e9seau g\u00e9od\u00e9sique fran\u00e7ais 1993", "RGF93"), PrimeMeridian.GREENWICH, Ellipsoid.GRS80, GeographicExtent.WORLD, "Coincident with ETRS89 at epoch 1993.0", "1993");
    public static final GeodeticDatum ED50 = new GeodeticDatum(new Identifier("EPSG", "6230", "European Datum 1950", "ED50"), PrimeMeridian.GREENWICH, Ellipsoid.INTERNATIONAL1924, GeographicExtent.WORLD, "Fundamental point: Potsdam (Helmert Tower). Latitude: 52 deg 22 min 51.4456 sec N; Longitude: 13 deg  3 min 58.9283 sec E (of Greenwich).", "1950");
    public static final GeodeticDatum WGS84GUAD = new GeodeticDatum(new Identifier(GeodeticDatum.class, "Guadeloupe : WGS84", "WGS84GUAD"), PrimeMeridian.GREENWICH, Ellipsoid.GRS80, new GeographicExtent("Guadeloupe", 15.875, 16.625, -61.85, -61.075), "", "");
    public static final GeodeticDatum WGS84MART = new GeodeticDatum(new Identifier(GeodeticDatum.class, "Martinique : WGS84", "WGS84GUAD"), PrimeMeridian.GREENWICH, Ellipsoid.GRS80, new GeographicExtent("Martinique", 14.25, 15.025, -61.25, -60.725), "", "");
    public static final GeodeticDatum WGS84SBSM = new GeodeticDatum(new Identifier(GeodeticDatum.class, "St-Martin St-Barth : WGS84", "WGS84SBSM"), PrimeMeridian.GREENWICH, Ellipsoid.GRS80, new GeographicExtent("St-Martin St-Barth", 17.8, 18.2, -63.2, -62.5), "", "");
    public static final GeodeticDatum NAD27 = new GeodeticDatum(new Identifier("EPSG", "6267", "North American Datum 1927", "NAD27"), PrimeMeridian.GREENWICH, Ellipsoid.CLARKE1866, GeographicExtent.WORLD, "", "1927");
    public static final GeodeticDatum NAD83 = new GeodeticDatum(new Identifier("EPSG", "6269", "North American Datum 1983", "NAD83"), PrimeMeridian.GREENWICH, Ellipsoid.GRS80, GeographicExtent.WORLD, "", "1983");

    public GeodeticDatum(PrimeMeridian primeMeridian, Ellipsoid ellipsoid) {
        this(new Identifier(GeodeticDatum.class), primeMeridian, ellipsoid, GeographicExtent.WORLD, null, null);
    }

    public GeodeticDatum(PrimeMeridian primeMeridian, Ellipsoid ellipsoid, CoordinateOperation toWGS84) {
        this(new Identifier(GeodeticDatum.class), primeMeridian, ellipsoid, GeographicExtent.WORLD, null, null);
        this.setDefaultToWGS84Operation(toWGS84);
    }

    public GeodeticDatum(Identifier identifier, PrimeMeridian primeMeridian, Ellipsoid ellipsoid, GeographicExtent extent, String origin, String epoch) {
        super(identifier, extent, origin, epoch);
        this.ellipsoid = ellipsoid;
        this.primeMeridian = primeMeridian;
    }

    @Override
    public PrimeMeridian getPrimeMeridian() {
        return this.primeMeridian;
    }

    @Override
    public Ellipsoid getEllipsoid() {
        return this.ellipsoid;
    }

    public final void setDefaultToWGS84Operation(CoordinateOperation toWGS84) {
        this.toWGS84 = toWGS84;
        this.setToOtherDatumOperation(toWGS84, WGS84);
    }

    public final void setToOtherDatumOperation(CoordinateOperation toOtherDatum, GeodeticDatum targetDatum) {
        ArrayList<CoordinateOperation> opList = new ArrayList<CoordinateOperation>();
        ArrayList<CoordinateOperation> opListInv = new ArrayList<CoordinateOperation>();
        boolean isInversible = true;
        if (toOtherDatum != null) {
            if (!this.primeMeridian.equals(PrimeMeridian.GREENWICH) && !this.primeMeridian.equals(targetDatum.getPrimeMeridian())) {
                opList.add(new LongitudeRotation(this.primeMeridian.getLongitudeFromGreenwichInRadians()));
            }
            if (!targetDatum.getPrimeMeridian().equals(PrimeMeridian.GREENWICH) && !this.primeMeridian.equals(targetDatum.getPrimeMeridian())) {
                opListInv.add(new LongitudeRotation(targetDatum.getPrimeMeridian().getLongitudeFromGreenwichInRadians()));
            }
            if (toOtherDatum != Identity.IDENTITY) {
                opList.add(new Geographic2Geocentric(this.getEllipsoid()));
                opList.add(toOtherDatum);
                opList.add(new Geocentric2Geographic(targetDatum.getEllipsoid()));
                try {
                    opListInv.add(new Geographic2Geocentric(targetDatum.getEllipsoid()));
                    opListInv.add(toOtherDatum.inverse());
                    opListInv.add(new Geocentric2Geographic(this.getEllipsoid()));
                }
                catch (NonInvertibleOperationException ex) {
                    isInversible = false;
                }
            } else if (!this.ellipsoid.equals(targetDatum.getEllipsoid())) {
                opList.add(new Geographic2Geocentric(this.getEllipsoid()));
                opList.add(new Geocentric2Geographic(targetDatum.getEllipsoid()));
                opListInv.add(new Geographic2Geocentric(targetDatum.getEllipsoid()));
                opListInv.add(new Geocentric2Geographic(this.getEllipsoid()));
            }
            if (!targetDatum.getPrimeMeridian().equals(PrimeMeridian.GREENWICH) && !this.primeMeridian.equals(targetDatum.getPrimeMeridian())) {
                opList.add(new LongitudeRotation(-targetDatum.getPrimeMeridian().getLongitudeFromGreenwichInRadians()));
            }
            if (!this.primeMeridian.equals(PrimeMeridian.GREENWICH) && !this.primeMeridian.equals(targetDatum.getPrimeMeridian())) {
                opListInv.add(new LongitudeRotation(-this.primeMeridian.getLongitudeFromGreenwichInRadians()));
            }
            if (opList.isEmpty()) {
                opList.add(Identity.IDENTITY);
                opListInv.add(Identity.IDENTITY);
            }
            this.addCoordinateOperation(targetDatum, new CoordinateOperationSequence(new Identifier(CoordinateOperation.class, this.getName() + " to " + targetDatum.getName()), opList));
            if (isInversible) {
                targetDatum.addCoordinateOperation(this, new CoordinateOperationSequence(new Identifier(CoordinateOperation.class, targetDatum.getName() + " to " + this.getName()), opListInv));
            }
        }
    }

    public void addCoordinateOperation(Datum datum, CoordinateOperation coordOp) {
        if (this.datumTransformations.get(datum) == null) {
            this.datumTransformations.put(datum, new ArrayList());
        }
        if (!this.datumTransformations.get(datum).contains(coordOp)) {
            this.datumTransformations.get(datum).add(coordOp);
        }
    }

    public List<CoordinateOperation> getCoordinateOperations(GeodeticDatum datum) {
        if (this.datumTransformations.get(datum) == null) {
            if (!this.getCoordinateOperations(WGS84).isEmpty() && !WGS84.getCoordinateOperations(datum).isEmpty()) {
                try {
                    AbstractCoordinateOperation toDatum = !this.getToWGS84().equals(datum.getToWGS84()) ? new CoordinateOperationSequence(new Identifier(CoordinateOperationSequence.class), this.getToWGS84(), datum.getToWGS84().inverse()) : Identity.IDENTITY;
                    this.setToOtherDatumOperation(toDatum, datum);
                }
                catch (NonInvertibleOperationException nonInvertibleOperationException) {}
            } else {
                this.datumTransformations.put(datum, new ArrayList());
            }
        }
        return this.datumTransformations.get(datum);
    }

    @Override
    public CoordinateOperation getToWGS84() {
        return this.toWGS84;
    }

    public GeodeticDatum checkExistingGeodeticDatum() {
        if (this.equals(WGS84)) {
            return WGS84;
        }
        if (this.equals(RGF93)) {
            return RGF93;
        }
        if (this.equals(NTF)) {
            return NTF;
        }
        if (this.equals(NTF_PARIS)) {
            return NTF_PARIS;
        }
        if (this.equals(ED50)) {
            return ED50;
        }
        return this;
    }

    public String toWKT() {
        StringBuilder w = new StringBuilder();
        w.append("DATUM[\"");
        w.append(this.getName());
        w.append("\",");
        w.append(this.getEllipsoid().toWKT());
        CoordinateOperation towgs84 = this.getToWGS84();
        if (towgs84 != null && towgs84 instanceof GeoTransformation) {
            GeoTransformation geoTransformation = (GeoTransformation)((Object)towgs84);
            w.append(geoTransformation.toWKT());
        } else if (towgs84 instanceof Identity) {
            w.append(",TOWGS84[0,0,0,0,0,0,0]");
        }
        if (!this.getAuthorityName().startsWith("LOCAL")) {
            w.append(',');
            w.append(this.getIdentifier().toWKT());
        }
        w.append(']');
        return w.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getIdentifier().toString());
        sb.append(" [");
        Iterator<Datum> it = this.datumTransformations.keySet().iterator();
        while (it.hasNext()) {
            sb.append("").append(it.next().getShortName());
            if (!it.hasNext()) continue;
            sb.append(" - ");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof GeodeticDatum) {
            GeodeticDatum gd = (GeodeticDatum)o;
            if (this.getIdentifier().equals(gd.getIdentifier())) {
                return true;
            }
            boolean toWGS84rs = this.getToWGS84() == null ? gd.getToWGS84() == null : this.getToWGS84().equals(gd.getToWGS84());
            return this.ellipsoid.equals(gd.getEllipsoid()) && this.primeMeridian.equals(gd.getPrimeMeridian()) && toWGS84rs;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + (this.primeMeridian != null ? this.primeMeridian.hashCode() : 0);
        hash = 83 * hash + (this.ellipsoid != null ? this.ellipsoid.hashCode() : 0);
        hash = 83 * hash + (this.toWGS84 != null ? this.toWGS84.hashCode() : 0);
        return hash;
    }

    static {
        WGS84.setDefaultToWGS84Operation(Identity.IDENTITY);
        RGF93.setDefaultToWGS84Operation(Identity.IDENTITY);
        NTF.setDefaultToWGS84Operation(new GeocentricTranslation(-168.0, -60.0, 320.0, 1.0));
        NTF_PARIS.setDefaultToWGS84Operation(new GeocentricTranslation(-168.0, -60.0, 320.0, 1.0));
        ED50.setDefaultToWGS84Operation(new GeocentricTranslation(-84.0, -97.0, -117.0, 1.0));
        WGS84GUAD.setDefaultToWGS84Operation(SevenParameterTransformation.createBursaWolfTransformation(1.2239, 2.4156, -1.7598, 0.038, -0.16101, -0.04925, 0.2387));
        WGS84MART.setDefaultToWGS84Operation(SevenParameterTransformation.createBursaWolfTransformation(0.7696, -0.8692, -12.0631, -0.32511, -0.21041, -0.0239, 0.2829));
        WGS84SBSM.setDefaultToWGS84Operation(SevenParameterTransformation.createBursaWolfTransformation(14.6642, 5.2493, 0.1981, -0.06838, 0.09141, -0.58131, -0.4067));
        datumFromName.put("wgs84", WGS84);
        datumFromName.put("ntfparis", NTF_PARIS);
        datumFromName.put("ntf", NTF);
        datumFromName.put("rgf93", RGF93);
        datumFromName.put("ed50", ED50);
        datumFromName.put("nad27", NAD27);
        datumFromName.put("nad83", NAD83);
    }
}

