/*
 * Decompiled with CFR 0.152.
 */
package org.cts.op.transformation.grids;

import org.cts.cs.GeographicExtent;
import org.cts.cs.OutOfExtentException;
import org.cts.op.transformation.grids.Grid;
import org.cts.op.transformation.grids.InterpolationMethodException;

public class GeographicGrid
implements Grid {
    protected int colNumber;
    protected int rowNumber;
    protected int dim;
    protected double x0;
    protected double y0;
    protected double xL;
    protected double yL;
    protected double dx;
    protected double dy;
    protected GeographicExtent extent;
    protected double modulo;
    int scale = 1;
    protected double[][][] values;
    protected Object context;

    protected GeographicGrid() {
    }

    public GeographicGrid(double westernLongitude, double northernLatitude, double easternLongitude, double southernLatitude, int colNumber, int rowNumber, int dim, double modulo, int scale, Object context) {
        this.x0 = westernLongitude;
        this.y0 = northernLatitude;
        this.xL = easternLongitude < westernLongitude ? easternLongitude + modulo : easternLongitude;
        this.yL = southernLatitude;
        this.colNumber = colNumber;
        this.rowNumber = rowNumber;
        this.dim = dim;
        this.modulo = modulo;
        this.dx = (this.xL - this.x0) / (double)(colNumber - 1);
        this.dy = (this.yL - this.y0) / (double)(rowNumber - 1);
        this.extent = new GeographicExtent("GG", this.yL, this.y0, this.x0, this.xL, modulo);
        this.scale = scale;
        this.context = context;
        this.values = new double[rowNumber][colNumber][dim];
    }

    public int getColumnNumber() {
        return this.colNumber;
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public double getX0() {
        return this.x0;
    }

    public double getY0() {
        return this.y0;
    }

    public double getXL() {
        return this.xL;
    }

    public double getYL() {
        return this.yL;
    }

    public double getDX() {
        return (this.xL - this.x0) / (double)(this.colNumber - 1);
    }

    public double getDY() {
        return (this.yL - this.y0) / (double)(this.rowNumber - 1);
    }

    public double getGridWidth() {
        return Math.abs(this.xL - this.x0);
    }

    public double getGridHeight() {
        return Math.abs(this.yL - this.y0);
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public Object getContext() {
        return this.context;
    }

    public double[] getValues(int r, int c) {
        return this.values[r][c];
    }

    public void setValue(int r, int c, double[] values) {
        System.arraycopy(values, 0, this.values[r][c], 0, this.dim);
    }

    public double[] getValue(double x, double y, Grid.InterpolationMethod method) throws OutOfExtentException, InterpolationMethodException {
        switch (method) {
            case BILINEAR: {
                return this.bilinearInterpolation(x, y);
            }
        }
        throw new InterpolationMethodException(method, this.getClass());
    }

    public double[][][] getValues() {
        return this.values;
    }

    public double[] bilinearInterpolation(double latitude, double longitude) throws OutOfExtentException {
        if (!this.extent.isInside(latitude, longitude)) {
            throw new OutOfExtentException(new double[]{latitude, longitude}, this.extent);
        }
        double x = longitude < this.x0 ? longitude + this.modulo : longitude;
        double y = latitude;
        int j = (int)Math.floor((x - this.x0) / this.dx);
        double fx = (x - this.x0) / this.dx - (double)j;
        int i = (int)Math.floor((y - this.y0) / this.dy);
        double fy = (y - this.y0) / this.dy - (double)i;
        double[] shift = new double[this.dim];
        for (int k = 0; k < this.dim; ++k) {
            double d1 = this.values[i][j][k];
            double d2 = this.values[i < this.rowNumber - 1 ? i + 1 : i][j][k];
            double d3 = this.values[i][j < this.colNumber - 1 ? j + 1 : j][k];
            double d4 = this.values[i < this.rowNumber - 1 ? i + 1 : i][j < this.colNumber - 1 ? j + 1 : j][k];
            shift[k] = (1.0 - fx) * (1.0 - fy) * d1 + (1.0 - fx) * fy * d2 + fx * (1.0 - fy) * d3 + fx * fy * d4;
        }
        return shift;
    }

    public String toString() {
        return "Geographic grid (westLon=" + this.x0 + " northLat=" + this.y0 + " eastLon=" + this.xL + " southLat=" + this.yL + " Column[" + this.colNumber + "] Row[" + this.rowNumber + "])";
    }

    public String toStringAll() {
        StringBuilder sb = new StringBuilder("Geographic grid (westLon=" + this.x0 + " northLat=" + this.y0 + " eastLon=" + this.xL + " southLat=" + this.yL + " Column[" + this.colNumber + "] Row[" + this.rowNumber + "])\n");
        for (int i = 0; i < this.rowNumber; ++i) {
            for (int j = 0; j < this.colNumber; ++j) {
                sb.append(this.values[i][j]);
                if (j >= this.colNumber - 1) continue;
                sb.append("\t");
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

