/*
 * Decompiled with CFR 0.152.
 */
package org.cts.registry;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.cts.registry.AbstractProjRegistry;
import org.cts.registry.RegistryException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Nad27Registry
extends AbstractProjRegistry {
    static final Pattern NAD27_REGEX = Pattern.compile("\\s+");

    @Override
    public String getRegistryName() {
        return "nad27";
    }

    @Override
    public Map<String, String> getParameters(String code) throws RegistryException {
        try {
            Map<String, String> crsParameters = this.projParser.readParameters(code, NAD27_REGEX);
            return crsParameters;
        }
        catch (IOException ex) {
            throw new RegistryException("Cannot load the NAD27 registry", ex);
        }
    }

    @Override
    public Set<String> getSupportedCodes() throws RegistryException {
        try {
            return this.projParser.getSupportedCodes(NAD27_REGEX);
        }
        catch (IOException ex) {
            throw new RegistryException("Cannot load the NAD27 registry", ex);
        }
    }
}

