/*
 * Decompiled with CFR 0.152.
 */
package org.cts.parser.prj;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cts.IdentifiableComponent;
import org.cts.Identifier;
import org.cts.parser.prj.PrjElement;
import org.cts.parser.prj.PrjNodeElement;
import org.cts.parser.prj.PrjNodeMatcher;
import org.cts.parser.prj.PrjNumberElement;
import org.cts.parser.prj.PrjParserException;
import org.cts.parser.prj.PrjStringElement;
import org.cts.parser.prj.PrjValueParameters;
import org.cts.parser.proj.ProjValueParameters;
import org.cts.units.Quantity;
import org.cts.units.Unit;

public final class PrjMatcher {
    private Map<String, String> params = new HashMap<String, String>();
    private int indexAxis = 0;
    private boolean isHorizontalCRS = false;
    private boolean isVerticalCRS = false;

    private PrjMatcher() {
    }

    static Map<String, String> match(PrjElement el) {
        PrjMatcher m = new PrjMatcher();
        return m.doMatch(el);
    }

    private Map<String, String> doMatch(PrjElement el) {
        List<PrjElement> ll = this.matchNode(el, "compd_cs", false);
        if (ll == null) {
            ll = this.matchNode(el, "projcs", false);
            if (ll == null) {
                ll = this.matchNode(el, "geogcs", false);
                if (ll == null) {
                    ll = this.matchNode(el, "geoccs", false);
                    if (ll == null) {
                        ll = this.matchNode(el, "vert_cs");
                        this.parseVertcs(ll, true);
                    } else {
                        this.parseGeoccs(ll);
                    }
                } else {
                    this.parseGeogcs(ll, true);
                }
            } else {
                this.parseProjcs(ll, true);
            }
        } else {
            this.parseCompdcs(ll);
        }
        this.cleanUnits();
        return this.params;
    }

    private void cleanUnits() {
        String lat0;
        String lon0;
        String y0;
        String x0;
        String[] unitRefname;
        String units = this.params.get("units");
        String unitval = this.params.get("to_meter");
        String unitAuth = this.params.get("unitrefname");
        Unit unit = Unit.getUnit(Quantity.LENGTH, units);
        if (unitAuth != null) {
            unitRefname = unitAuth.split(":");
            if (unit == null) {
                unit = (Unit)IdentifiableComponent.getComponent(new Identifier(unitRefname[0], unitRefname[1], ""));
            }
        }
        if (unit != null && !unit.equals(Unit.METER) && unit.getQuantity().equals(Quantity.LENGTH)) {
            x0 = this.params.remove("x_0");
            if (x0 != null) {
                x0 = Double.toString(unit.toBaseUnit(Double.valueOf(x0)));
                this.params.put("x_0", x0);
            }
            if ((y0 = this.params.remove("y_0")) != null) {
                y0 = Double.toString(unit.toBaseUnit(Double.valueOf(y0)));
                this.params.put("y_0", y0);
            }
        } else if (unitval != null && !Unit.METER.equals(unit)) {
            x0 = this.params.remove("x_0");
            if (x0 != null) {
                x0 = Double.toString(Double.valueOf(x0) * Double.valueOf(unitval));
                this.params.put("x_0", x0);
            }
            if ((y0 = this.params.remove("y_0")) != null) {
                y0 = Double.toString(Double.valueOf(y0) * Double.valueOf(unitval));
                this.params.put("y_0", y0);
            }
        }
        units = this.params.get("geogunit");
        unitval = this.params.get("geogunitval");
        unitAuth = this.params.get("geogunitrefname");
        unit = Unit.getUnit(Quantity.ANGLE, units);
        if (unitAuth != null) {
            unitRefname = unitAuth.split(":");
            if (unit == null) {
                unit = (Unit)IdentifiableComponent.getComponent(new Identifier(unitRefname[0], unitRefname[1], ""));
            }
        }
        if (Unit.DEGREE.equals(unit)) {
            return;
        }
        if (unit != null) {
            String gamma;
            String alpha;
            String lonc;
            String lat_ts;
            String lat2;
            String lat1;
            lon0 = this.params.remove("lon_0");
            if (lon0 != null) {
                lon0 = Double.toString(Unit.DEGREE.fromBaseUnit(unit.toBaseUnit(Double.valueOf(lon0))));
                this.params.put("lon_0", lon0);
            }
            if ((lat0 = this.params.remove("lat_0")) != null) {
                lat0 = Double.toString(Unit.DEGREE.fromBaseUnit(unit.toBaseUnit(Double.valueOf(lat0))));
                this.params.put("lat_0", lat0);
            }
            if ((lat1 = this.params.remove("lat_1")) != null) {
                lat1 = Double.toString(Unit.DEGREE.fromBaseUnit(unit.toBaseUnit(Double.valueOf(lat1))));
                this.params.put("lat_1", lat1);
            }
            if ((lat2 = this.params.remove("lat_2")) != null) {
                lat2 = Double.toString(Unit.DEGREE.fromBaseUnit(unit.toBaseUnit(Double.valueOf(lat2))));
                this.params.put("lat_2", lat2);
            }
            if ((lat_ts = this.params.remove("lat_ts")) != null) {
                lat_ts = Double.toString(Unit.DEGREE.fromBaseUnit(unit.toBaseUnit(Double.valueOf(lat_ts))));
                this.params.put("lat_ts", lat_ts);
            }
            if ((lonc = this.params.remove("lonc")) != null) {
                lonc = Double.toString(Unit.DEGREE.fromBaseUnit(unit.toBaseUnit(Double.valueOf(lonc))));
                this.params.put("lonc", lonc);
            }
            if ((alpha = this.params.remove("alpha")) != null) {
                alpha = Double.toString(Unit.DEGREE.fromBaseUnit(unit.toBaseUnit(Double.valueOf(alpha))));
                this.params.put("alpha", alpha);
            }
            if ((gamma = this.params.remove("gamma")) != null) {
                gamma = Double.toString(Unit.DEGREE.fromBaseUnit(unit.toBaseUnit(Double.valueOf(gamma))));
                this.params.put("gamma", gamma);
            }
        } else if (unitval != null) {
            String gamma;
            String alpha;
            String lonc;
            String lat_ts;
            String lat2;
            String lat1;
            lon0 = this.params.remove("lon_0");
            if (lon0 != null) {
                lon0 = Double.toString(Unit.DEGREE.fromBaseUnit(Double.valueOf(lon0) * Double.valueOf(unitval)));
                this.params.put("lon_0", lon0);
            }
            if ((lat0 = this.params.remove("lat_0")) != null) {
                lat0 = Double.toString(Unit.DEGREE.fromBaseUnit(Double.valueOf(lat0) * Double.valueOf(unitval)));
                this.params.put("lat_0", lat0);
            }
            if ((lat1 = this.params.remove("lat_1")) != null) {
                lat1 = Double.toString(Unit.DEGREE.fromBaseUnit(Double.valueOf(lat1) * Double.valueOf(unitval)));
                this.params.put("lat_1", lat1);
            }
            if ((lat2 = this.params.remove("lat_2")) != null) {
                lat2 = Double.toString(Unit.DEGREE.fromBaseUnit(Double.valueOf(lat2) * Double.valueOf(unitval)));
                this.params.put("lat_2", lat2);
            }
            if ((lat_ts = this.params.remove("lat_ts")) != null) {
                lat_ts = Double.toString(Unit.DEGREE.fromBaseUnit(Double.valueOf(lat_ts) * Double.valueOf(unitval)));
                this.params.put("lat_ts", lat_ts);
            }
            if ((lonc = this.params.remove("lonc")) != null) {
                lonc = Double.toString(Unit.DEGREE.fromBaseUnit(Double.valueOf(lonc) * Double.valueOf(unitval)));
                this.params.put("lonc", lonc);
            }
            if ((alpha = this.params.remove("alpha")) != null) {
                alpha = Double.toString(Unit.DEGREE.fromBaseUnit(Double.valueOf(alpha) * Double.valueOf(unitval)));
                this.params.put("alpha", alpha);
            }
            if ((gamma = this.params.remove("gamma")) != null) {
                gamma = Double.toString(Unit.DEGREE.fromBaseUnit(Double.valueOf(gamma) * Double.valueOf(unitval)));
                this.params.put("gamma", gamma);
            }
        }
    }

    private void parseProjcs(List<PrjElement> ll, boolean rootElement) {
        if (!rootElement) {
            this.parseString(ll.get(0), "projcs");
        } else {
            this.parseString(ll.get(0), "name");
        }
        this.indexAxis = 0;
        PrjNodeMatcher[] matchers = new PrjNodeMatcher[]{new PrjNodeMatcher(){

            @Override
            public String getName() {
                return "geogcs";
            }

            @Override
            public void run(List<PrjElement> list) {
                PrjMatcher.this.parseGeogcs(list, false);
                PrjMatcher.this.params.remove("geogcs");
                PrjMatcher.this.params.remove("geogrefname");
            }
        }, new PrjNodeMatcher(){

            @Override
            public String getName() {
                return "unit";
            }

            @Override
            public void run(List<PrjElement> list) {
                List<String> info = PrjMatcher.this.getUnit(list);
                PrjMatcher.this.params.put("geogunit", PrjMatcher.this.params.remove("units"));
                PrjMatcher.this.params.put("geogunitval", PrjMatcher.this.params.remove("to_meter"));
                PrjMatcher.this.params.put("units", info.get(0));
                PrjMatcher.this.params.put("to_meter", info.get(1));
                if (info.size() > 2) {
                    PrjMatcher.this.params.put("geogunitrefname", PrjMatcher.this.params.remove("unitrefname"));
                    PrjMatcher.this.params.put("unitrefname", info.get(2));
                }
            }
        }, new PrjNodeMatcher(){

            @Override
            public String getName() {
                return "projection";
            }

            @Override
            public void run(List<PrjElement> list) {
                PrjMatcher.this.parseProjection(list);
            }
        }, new PrjNodeMatcher(){

            @Override
            public String getName() {
                return "parameter";
            }

            @Override
            public void run(List<PrjElement> list) {
                PrjMatcher.this.parseParameter(list);
            }
        }, !rootElement ? new PrjNodeMatcher(){

            @Override
            public String getName() {
                return "authority";
            }

            @Override
            public void run(List<PrjElement> list) {
                String refname = PrjMatcher.this.getAuthority(list);
                PrjMatcher.this.params.put("projrefname", refname);
            }
        } : new PrjNodeMatcher(){

            @Override
            public String getName() {
                return "authority";
            }

            @Override
            public void run(List<PrjElement> list) {
                String refname = PrjMatcher.this.getAuthority(list);
                PrjMatcher.this.params.put("refname", refname);
            }
        }, new PrjNodeMatcher(){

            @Override
            public String getName() {
                return "axis";
            }

            @Override
            public void run(List<PrjElement> list) {
                List<String> info = PrjMatcher.this.getAxis(list);
                switch (PrjMatcher.this.indexAxis) {
                    case 0: {
                        PrjMatcher.this.params.put("axis1", info.get(0));
                        PrjMatcher.this.params.put("axis1type", info.get(1));
                        ++PrjMatcher.this.indexAxis;
                        break;
                    }
                    case 1: {
                        PrjMatcher.this.params.put("axis2", info.get(0));
                        PrjMatcher.this.params.put("axis2type", info.get(1));
                        ++PrjMatcher.this.indexAxis;
                        break;
                    }
                    default: {
                        throw new PrjParserException("Failed to parse PRJ. Found '" + list + "', completely unexpected!");
                    }
                }
            }
        }};
        for (int i = 1; i < ll.size(); ++i) {
            this.matchAnyNode(ll.get(i), matchers);
        }
    }

    private void parseCompdcs(List<PrjElement> ll) {
        this.parseString(ll.get(0), "name");
        PrjNodeMatcher[] matchers = new PrjNodeMatcher[]{new PrjNodeMatcher(){

            @Override
            public String getName() {
                return "geogcs";
            }

            @Override
            public void run(List<PrjElement> list) {
                if (PrjMatcher.this.isHorizontalCRS) {
                    throw new PrjParserException("Failed to parse PRJ, because of multiple horizontal CRS definition.");
                }
                PrjMatcher.this.parseGeogcs(list, false);
                PrjMatcher.this.isHorizontalCRS = true;
            }
        }, new PrjNodeMatcher(){

            @Override
            public String getName() {
                return "projcs";
            }

            @Override
            public void run(List<PrjElement> list) {
                if (PrjMatcher.this.isHorizontalCRS) {
                    throw new PrjParserException("Failed to parse PRJ, because of multiple horizontal CRS definition.");
                }
                PrjMatcher.this.parseProjcs(list, false);
                PrjMatcher.this.isHorizontalCRS = true;
            }
        }, new PrjNodeMatcher(){

            @Override
            public String getName() {
                return "vert_cs";
            }

            @Override
            public void run(List<PrjElement> list) {
                if (PrjMatcher.this.isVerticalCRS) {
                    throw new PrjParserException("Failed to parse PRJ, because of multiple vertical CRS definition.");
                }
                PrjMatcher.this.parseVertcs(list, false);
                PrjMatcher.this.isVerticalCRS = true;
            }
        }, new PrjNodeMatcher(){

            @Override
            public String getName() {
                return "authority";
            }

            @Override
            public void run(List<PrjElement> list) {
                String refname = PrjMatcher.this.getAuthority(list);
                PrjMatcher.this.params.put("refname", refname);
            }
        }};
        for (int i = 1; i < ll.size(); ++i) {
            this.matchAnyNode(ll.get(i), matchers);
        }
        if (!this.isHorizontalCRS || !this.isVerticalCRS) {
            throw new PrjParserException("Failed to parse PRJ. Missing definition for an horizontal CRS or for a VerticalCRS.");
        }
    }

    private void parseGeoccs(List<PrjElement> ll) {
        this.parseString(ll.get(0), "name");
        this.params.put("proj", ProjValueParameters.GEOCENT);
        this.indexAxis = 0;
        PrjNodeMatcher[] matchers = new PrjNodeMatcher[]{new PrjNodeMatcher(){

            @Override
            public String getName() {
                return "datum";
            }

            @Override
            public void run(List<PrjElement> list) {
                PrjMatcher.this.parseDatum(list);
            }
        }, new PrjNodeMatcher(){

            @Override
            public String getName() {
                return "primem";
            }

            @Override
            public void run(List<PrjElement> list) {
                PrjMatcher.this.parsePrimeM(list);
            }
        }, new PrjNodeMatcher(){

            @Override
            public String getName() {
                return "unit";
            }

            @Override
            public void run(List<PrjElement> list) {
                List<String> info = PrjMatcher.this.getUnit(list);
                PrjMatcher.this.params.put("units", info.get(0));
                PrjMatcher.this.params.put("to_meter", info.get(1));
                if (info.size() > 2) {
                    PrjMatcher.this.params.put("unitrefname", info.get(2));
                }
            }
        }, new PrjNodeMatcher(){

            @Override
            public String getName() {
                return "authority";
            }

            @Override
            public void run(List<PrjElement> list) {
                String refname = PrjMatcher.this.getAuthority(list);
                PrjMatcher.this.params.put("refname", refname);
            }
        }, new PrjNodeMatcher(){

            @Override
            public String getName() {
                return "axis";
            }

            @Override
            public void run(List<PrjElement> list) {
                List<String> info = PrjMatcher.this.getAxis(list);
                switch (PrjMatcher.this.indexAxis) {
                    case 0: {
                        PrjMatcher.this.params.put("axis1", info.get(0));
                        PrjMatcher.this.params.put("axis1type", info.get(1));
                        ++PrjMatcher.this.indexAxis;
                        break;
                    }
                    case 1: {
                        PrjMatcher.this.params.put("axis2", info.get(0));
                        PrjMatcher.this.params.put("axis2type", info.get(1));
                        ++PrjMatcher.this.indexAxis;
                        break;
                    }
                    case 2: {
                        PrjMatcher.this.params.put("axis3", info.get(0));
                        PrjMatcher.this.params.put("axis3type", info.get(1));
                        ++PrjMatcher.this.indexAxis;
                        break;
                    }
                    default: {
                        throw new PrjParserException("Failed to parse PRJ. Found '" + list + "', completely unexpected!");
                    }
                }
            }
        }};
        for (int i = 1; i < ll.size(); ++i) {
            this.matchAnyNode(ll.get(i), matchers);
        }
    }

    private void parseGeogcs(List<PrjElement> ll, boolean rootElement) {
        if (!rootElement) {
            this.parseString(ll.get(0), "geogcs");
        } else {
            this.parseString(ll.get(0), "name");
        }
        if (!this.params.containsKey("proj")) {
            this.params.put("proj", ProjValueParameters.LONGLAT);
        }
        this.indexAxis = 0;
        PrjNodeMatcher[] matchers = new PrjNodeMatcher[5];
        matchers[0] = new PrjNodeMatcher(){

            @Override
            public String getName() {
                return "datum";
            }

            @Override
            public void run(List<PrjElement> list) {
                PrjMatcher.this.parseDatum(list);
            }
        };
        matchers[1] = new PrjNodeMatcher(){

            @Override
            public String getName() {
                return "primem";
            }

            @Override
            public void run(List<PrjElement> list) {
                PrjMatcher.this.parsePrimeM(list);
            }
        };
        matchers[2] = new PrjNodeMatcher(){

            @Override
            public String getName() {
                return "unit";
            }

            @Override
            public void run(List<PrjElement> list) {
                if (!PrjMatcher.this.params.containsKey("units")) {
                    List<String> info = PrjMatcher.this.getUnit(list);
                    PrjMatcher.this.params.put("units", info.get(0));
                    PrjMatcher.this.params.put("to_meter", info.get(1));
                    if (info.size() > 2) {
                        PrjMatcher.this.params.put("unitrefname", info.get(2));
                    }
                }
            }
        };
        if (!rootElement) {
            this.parseString(ll.get(0), "geogcs");
            matchers[3] = new PrjNodeMatcher(){

                @Override
                public String getName() {
                    return "authority";
                }

                @Override
                public void run(List<PrjElement> list) {
                    String refname = PrjMatcher.this.getAuthority(list);
                    PrjMatcher.this.params.put("geogrefname", refname);
                }
            };
        } else {
            matchers[3] = new PrjNodeMatcher(){

                @Override
                public String getName() {
                    return "authority";
                }

                @Override
                public void run(List<PrjElement> list) {
                    String refname = PrjMatcher.this.getAuthority(list);
                    PrjMatcher.this.params.put("refname", refname);
                }
            };
        }
        matchers[4] = new PrjNodeMatcher(){

            @Override
            public String getName() {
                return "axis";
            }

            @Override
            public void run(List<PrjElement> list) {
                if (!PrjMatcher.this.params.containsKey("axis1")) {
                    List<String> info = PrjMatcher.this.getAxis(list);
                    switch (PrjMatcher.this.indexAxis) {
                        case 0: {
                            PrjMatcher.this.params.put("axis1", info.get(0));
                            PrjMatcher.this.params.put("axis1type", info.get(1));
                            ++PrjMatcher.this.indexAxis;
                            break;
                        }
                        case 1: {
                            PrjMatcher.this.params.put("axis2", info.get(0));
                            PrjMatcher.this.params.put("axis2type", info.get(1));
                            ++PrjMatcher.this.indexAxis;
                            break;
                        }
                        case 2: {
                            PrjMatcher.this.params.put("axis3", info.get(0));
                            PrjMatcher.this.params.put("axis3type", info.get(1));
                            ++PrjMatcher.this.indexAxis;
                            break;
                        }
                        default: {
                            throw new PrjParserException("Failed to parse PRJ. Found '" + list + "', completely unexpected!");
                        }
                    }
                }
            }
        };
        for (int i = 1; i < ll.size(); ++i) {
            this.matchAnyNode(ll.get(i), matchers);
        }
        this.indexAxis = 0;
    }

    private void parseVertcs(List<PrjElement> ll, boolean rootElement) {
        if (!rootElement) {
            this.parseString(ll.get(0), "vert_cs");
        } else {
            this.parseString(ll.get(0), "name");
        }
        this.indexAxis = 0;
        PrjNodeMatcher[] matchers = new PrjNodeMatcher[]{new PrjNodeMatcher(){

            @Override
            public String getName() {
                return "vert_datum";
            }

            @Override
            public void run(List<PrjElement> list) {
                PrjMatcher.this.parseVertDatum(list);
            }
        }, new PrjNodeMatcher(){

            @Override
            public String getName() {
                return "unit";
            }

            @Override
            public void run(List<PrjElement> list) {
                List<String> info = PrjMatcher.this.getUnit(list);
                PrjMatcher.this.params.put("vertunit", info.get(0));
                PrjMatcher.this.params.put("vertunitval", info.get(1));
                if (info.size() > 2) {
                    PrjMatcher.this.params.put("vertunitrefname", info.get(2));
                }
            }
        }, !rootElement ? new PrjNodeMatcher(){

            @Override
            public String getName() {
                return "authority";
            }

            @Override
            public void run(List<PrjElement> list) {
                String refname = PrjMatcher.this.getAuthority(list);
                PrjMatcher.this.params.put("vertrefname", refname);
            }
        } : new PrjNodeMatcher(){

            @Override
            public String getName() {
                return "authority";
            }

            @Override
            public void run(List<PrjElement> list) {
                String refname = PrjMatcher.this.getAuthority(list);
                PrjMatcher.this.params.put("refname", refname);
            }
        }, new PrjNodeMatcher(){

            @Override
            public String getName() {
                return "axis";
            }

            @Override
            public void run(List<PrjElement> list) {
                List<String> info = PrjMatcher.this.getAxis(list);
                switch (PrjMatcher.this.indexAxis) {
                    case 0: {
                        PrjMatcher.this.params.put("vertaxis", info.get(0));
                        PrjMatcher.this.params.put("vertaxistype", info.get(1));
                        ++PrjMatcher.this.indexAxis;
                        break;
                    }
                    default: {
                        throw new PrjParserException("Failed to parse PRJ. Found '" + list + "', completely unexpected!");
                    }
                }
            }
        }};
        for (int i = 1; i < ll.size(); ++i) {
            this.matchAnyNode(ll.get(i), matchers);
        }
    }

    private String getAuthority(List<PrjElement> ll) {
        String auth = this.getString(ll.get(0));
        PrjElement authorityCode = ll.get(1);
        String code = authorityCode instanceof PrjNumberElement ? String.valueOf(Math.round(this.getNumber(authorityCode))) : this.getString(authorityCode);
        return auth + ":" + code;
    }

    private void parseDatum(List<PrjElement> ll) {
        String datum = this.getString(ll.get(0));
        String datm = PrjValueParameters.DATUMNAMES.get(datum.toLowerCase().replaceAll("^d_", "").replaceAll("[^a-zA-Z0-9]", "").replaceAll("datum", ""));
        datum = datm != null ? datm : datum;
        this.params.put("datum", datum);
        PrjNodeMatcher[] matchers = new PrjNodeMatcher[]{new PrjNodeMatcher(){

            @Override
            public String getName() {
                return "spheroid";
            }

            @Override
            public void run(List<PrjElement> list) {
                PrjMatcher.this.parseSpheroid(list);
            }
        }, new PrjNodeMatcher(){

            @Override
            public String getName() {
                return "towgs84";
            }

            @Override
            public void run(List<PrjElement> list) {
                PrjMatcher.this.parseToWGS84(list);
            }
        }, new PrjNodeMatcher(){

            @Override
            public String getName() {
                return "authority";
            }

            @Override
            public void run(List<PrjElement> list) {
                String refname = PrjMatcher.this.getAuthority(list);
                PrjMatcher.this.params.put("datumrefname", refname);
            }
        }};
        for (int i = 1; i < ll.size(); ++i) {
            this.matchAnyNode(ll.get(i), matchers);
        }
    }

    private void parseSpheroid(List<PrjElement> ll) {
        String ellps = this.getString(ll.get(0));
        String elps = PrjValueParameters.ELLIPSOIDNAMES.get(ellps.toLowerCase().replaceAll("[^a-zA-Z0-9]", ""));
        ellps = elps != null ? elps : ellps;
        this.params.put("ellps", ellps);
        this.parseNumber(ll.get(1), "a");
        this.parseNumber(ll.get(2), "rf");
        if (ll.size() > 3) {
            String auth = this.getAuthority(this.matchNode(ll.get(3), "authority"));
            this.params.put("spheroidrefname", auth);
        }
    }

    private void parseToWGS84(List<PrjElement> ll) {
        StringBuilder b = new StringBuilder();
        b.append(this.getNumber(ll.get(0)));
        for (int i = 1; i < ll.size(); ++i) {
            b.append(',').append(this.getNumber(ll.get(i)));
        }
        this.params.put("towgs84", b.toString());
    }

    private void parseVertDatum(List<PrjElement> ll) {
        String datum = this.getString(ll.get(0));
        String datm = PrjValueParameters.DATUMNAMES.get(datum.toLowerCase().replaceAll("[^a-zA-Z0-9]", ""));
        datum = datm != null ? datm : datum;
        this.params.put("vert_datum", datum);
        this.parseNumber(ll.get(1), "vertdatumtype");
        if (ll.size() > 2) {
            String auth = this.getAuthority(this.matchNode(ll.get(2), "authority"));
            this.params.put("vertdatumrefname", auth);
        }
    }

    private List<String> getUnit(List<PrjElement> ll) {
        ArrayList<String> result = new ArrayList<String>();
        String unit = this.getString(ll.get(0));
        String unt = PrjValueParameters.UNITNAMES.get(unit.replaceAll("[^a-zA-Z0-9]", "").toLowerCase());
        if (unt != null) {
            result.add(unt);
        } else {
            result.add(unit);
        }
        result.add(String.valueOf(this.getNumber(ll.get(1))));
        if (ll.size() > 2) {
            result.add(this.getAuthority(this.matchNode(ll.get(2), "authority")));
        }
        return result;
    }

    private void parseProjection(List<PrjElement> ll) {
        String proj = this.getString(ll.get(0));
        String prj = PrjValueParameters.PROJNAMES.get(proj.replaceAll("[^a-zA-Z0-9]", "").toLowerCase());
        proj = prj != null ? prj : proj;
        this.params.put("proj", proj);
    }

    private void parsePrimeM(List<PrjElement> ll) {
        String pm = this.getString(ll.get(0));
        String prm = PrjValueParameters.PRIMEMERIDIANNAMES.get(pm.replaceAll("[^a-zA-Z0-9]", "").toLowerCase());
        if (prm != null) {
            this.params.put("pm", prm);
        } else {
            this.params.put("pm", pm);
            this.parseNumber(ll.get(1), "pmvalue");
            if (ll.size() > 2) {
                String auth = this.getAuthority(this.matchNode(ll.get(2), "authority"));
                this.params.put("primemrefname", auth);
            }
        }
    }

    private void parseParameter(List<PrjElement> ll) {
        String param = this.getString(ll.get(0));
        String parm = PrjValueParameters.PARAMNAMES.get(param.toLowerCase().replaceAll("[^a-zA-Z0-9]", ""));
        if (parm != null) {
            this.parseNumber(ll.get(1), parm);
        }
    }

    private List<String> getAxis(List<PrjElement> ll) {
        ArrayList<String> result = new ArrayList<String>();
        String axisName = this.getString(ll.get(0));
        String axis = PrjValueParameters.AXISNAMES.get(axisName.replaceAll("[^a-zA-Z0-9]", "").toLowerCase());
        if (axis != null) {
            result.add(axis);
        } else {
            result.add(axisName);
        }
        result.add(this.getString(ll.get(1)));
        return result;
    }

    private void matchAnyNode(PrjElement e, PrjNodeMatcher[] nn) {
        this.matchAnyNode(e, nn, false);
    }

    private void matchAnyNode(PrjElement e, PrjNodeMatcher[] nn, boolean strict) {
        if (e instanceof PrjNodeElement) {
            PrjNodeElement ne = (PrjNodeElement)e;
            for (PrjNodeMatcher m : nn) {
                if (!ne.getName().equalsIgnoreCase(m.getName())) continue;
                m.run(ne.getChildren());
                return;
            }
        }
        if (strict) {
            throw new PrjParserException("Failed to parse PRJ. Found '" + e + "', completely unexpected!");
        }
    }

    private List<PrjElement> matchNode(PrjElement e, String name) {
        return this.matchNode(e, name, true);
    }

    private List<PrjElement> matchNode(PrjElement e, String name, boolean strict) {
        PrjNodeElement n;
        if (e instanceof PrjNodeElement && (n = (PrjNodeElement)e).getName().equalsIgnoreCase(name)) {
            return n.getChildren();
        }
        if (strict) {
            throw new PrjParserException("Failed to parse PRJ. Found '" + e + "', expected PrjNodeElement[" + name + "].");
        }
        return null;
    }

    private void parseString(PrjElement e, String name) {
        if (!(e instanceof PrjStringElement)) {
            throw new PrjParserException("Failed to parse PRJ. Found '" + e + "', expected PrjStringElement with " + name + " in it.");
        }
        PrjStringElement s = (PrjStringElement)e;
        this.params.put(name, s.getValue().trim());
    }

    private String getString(PrjElement e) {
        if (e instanceof PrjStringElement) {
            PrjStringElement s = (PrjStringElement)e;
            return s.getValue().trim();
        }
        throw new PrjParserException("Failed to parse PRJ. Found '" + e + "', expected some PrjStringElement.");
    }

    private void parseNumber(PrjElement e, String name) {
        if (!(e instanceof PrjNumberElement)) {
            throw new PrjParserException("Failed to parse PRJ. Found '" + e + "', expected PrjNumberElement with " + name + " in it.");
        }
        PrjNumberElement n = (PrjNumberElement)e;
        this.params.put(name, String.valueOf(n.getValue()));
    }

    private double getNumber(PrjElement e) {
        if (e instanceof PrjNumberElement) {
            PrjNumberElement n = (PrjNumberElement)e;
            return n.getValue();
        }
        throw new PrjParserException("Failed to parse PRJ. Found '" + e + "', expected PrjNumberElement.");
    }
}

