/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.drivers.dbf;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.h2.table.Column;
import org.h2gis.drivers.dbf.internal.DBFDriver;
import org.h2gis.drivers.dbf.internal.DbaseFileException;
import org.h2gis.drivers.dbf.internal.DbaseFileHeader;
import org.h2gis.drivers.file_table.FileEngine;
import org.h2gis.drivers.utility.FileUtil;
import org.h2gis.h2spatialapi.DriverFunction;
import org.h2gis.h2spatialapi.EmptyProgressVisitor;
import org.h2gis.h2spatialapi.ProgressVisitor;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.TableLocation;

public class DBFDriverFunction
implements DriverFunction {
    public static String DESCRIPTION = "dBase III format";
    private static final int BATCH_MAX_SIZE = 100;

    public void exportTable(Connection connection, String tableReference, File fileName, ProgressVisitor progress) throws SQLException, IOException {
        this.exportTable(connection, tableReference, fileName, progress, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportTable(Connection connection, String tableReference, File fileName, ProgressVisitor progress, String encoding) throws SQLException, IOException {
        block16: {
            if (FileUtil.isExtensionWellFormated(fileName, "dbf")) {
                ResultSet rs;
                int recordCount = JDBCUtilities.getRowCount((Connection)connection, (String)tableReference);
                boolean isH2 = JDBCUtilities.isH2DataBase((DatabaseMetaData)connection.getMetaData());
                Statement st = connection.createStatement();
                ProgressVisitor lineProgress = null;
                if (!(progress instanceof EmptyProgressVisitor)) {
                    rs = st.executeQuery(String.format("select count(*) from %s", TableLocation.parse((String)tableReference, (Boolean)isH2).toString(isH2)));
                    try {
                        if (rs.next()) {
                            lineProgress = progress.subProcess(rs.getInt(1));
                        }
                    }
                    finally {
                        rs.close();
                    }
                }
                try {
                    rs = st.executeQuery(String.format("select * from %s", TableLocation.parse((String)tableReference, (Boolean)isH2).toString(isH2)));
                    try {
                        ResultSetMetaData resultSetMetaData = rs.getMetaData();
                        ArrayList<Integer> columnIndexes = new ArrayList<Integer>();
                        DbaseFileHeader header = DBFDriverFunction.dBaseHeaderFromMetaData(resultSetMetaData, columnIndexes);
                        if (encoding != null) {
                            header.setEncoding(encoding);
                        }
                        header.setNumRecords(recordCount);
                        DBFDriver dbfDriver = new DBFDriver();
                        dbfDriver.initDriver(fileName, header);
                        Object[] row = new Object[header.getNumFields()];
                        while (rs.next()) {
                            int i = 0;
                            for (Integer index : columnIndexes) {
                                row[i++] = rs.getObject(index);
                            }
                            dbfDriver.insertRow(row);
                            if (lineProgress == null) continue;
                            lineProgress.endStep();
                        }
                        dbfDriver.close();
                        break block16;
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    st.close();
                }
            }
            throw new SQLException("Only .dbf extension is supported");
        }
    }

    public String getFormatDescription(String format) {
        if (format.equalsIgnoreCase("dbf")) {
            return DESCRIPTION;
        }
        return "";
    }

    public DriverFunction.IMPORT_DRIVER_TYPE getImportDriverType() {
        return DriverFunction.IMPORT_DRIVER_TYPE.COPY;
    }

    public String[] getImportFormats() {
        return new String[]{"dbf"};
    }

    public String[] getExportFormats() {
        return new String[]{"dbf"};
    }

    public boolean isSpatialFormat(String extension) {
        return false;
    }

    public void importFile(Connection connection, String tableReference, File fileName, ProgressVisitor progress) throws SQLException, IOException {
        this.importFile(connection, tableReference, fileName, progress, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importFile(Connection connection, String tableReference, File fileName, ProgressVisitor progress, String forceFileEncoding) throws SQLException, IOException {
        if (FileUtil.isFileImportable(fileName, "dbf")) {
            DBFDriver dbfDriver = new DBFDriver();
            dbfDriver.initDriverFromFile(fileName, forceFileEncoding);
            boolean isH2 = JDBCUtilities.isH2DataBase((DatabaseMetaData)connection.getMetaData());
            String parsedTable = TableLocation.parse((String)tableReference, (Boolean)isH2).toString(isH2);
            DbaseFileHeader dbfHeader = dbfDriver.getDbaseFileHeader();
            ProgressVisitor copyProgress = progress.subProcess((int)(dbfDriver.getRowCount() / 100L));
            try {
                Statement st = connection.createStatement();
                ArrayList<Column> otherCols = new ArrayList<Column>(dbfHeader.getNumFields() + 1);
                for (int idColumn = 0; idColumn < dbfHeader.getNumFields(); ++idColumn) {
                    otherCols.add(new Column(dbfHeader.getFieldName(idColumn), 0));
                }
                String pkColName = FileEngine.getUniqueColumnName("PK", otherCols);
                st.execute(String.format("CREATE TABLE %s (" + pkColName + " SERIAL PRIMARY KEY, %s)", parsedTable, DBFDriverFunction.getSQLColumnTypes(dbfHeader, isH2)));
                st.close();
                try {
                    PreparedStatement preparedStatement = connection.prepareStatement(String.format("INSERT INTO %s VALUES ( %s )", parsedTable, DBFDriverFunction.getQuestionMark(dbfHeader.getNumFields() + 1)));
                    try {
                        long batchSize = 0L;
                        int rowId = 0;
                        while ((long)rowId < dbfDriver.getRowCount()) {
                            preparedStatement.setObject(1, rowId + 1);
                            Object[] values = dbfDriver.getRow(rowId);
                            for (int columnId = 0; columnId < values.length; ++columnId) {
                                preparedStatement.setObject(columnId + 2, values[columnId]);
                            }
                            preparedStatement.addBatch();
                            if (++batchSize >= 100L) {
                                preparedStatement.executeBatch();
                                preparedStatement.clearBatch();
                                batchSize = 0L;
                                copyProgress.endStep();
                            }
                            ++rowId;
                        }
                        if (batchSize > 0L) {
                            preparedStatement.executeBatch();
                        }
                    }
                    finally {
                        preparedStatement.close();
                    }
                }
                catch (Exception ex) {
                    connection.createStatement().execute("DROP TABLE IF EXISTS " + parsedTable);
                    throw new SQLException(ex.getLocalizedMessage(), ex);
                }
            }
            finally {
                dbfDriver.close();
                copyProgress.endOfProgress();
            }
        }
    }

    public static String getQuestionMark(int count) {
        StringBuilder qMark = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                qMark.append(", ");
            }
            qMark.append("?");
        }
        return qMark.toString();
    }

    public static String getSQLColumnTypes(DbaseFileHeader header, boolean isH2Database) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        block7: for (int idColumn = 0; idColumn < header.getNumFields(); ++idColumn) {
            if (idColumn > 0) {
                stringBuilder.append(", ");
            }
            String fieldName = TableLocation.capsIdentifier((String)header.getFieldName(idColumn), (Boolean)isH2Database);
            stringBuilder.append(TableLocation.quoteIdentifier((String)fieldName, (boolean)isH2Database));
            stringBuilder.append(" ");
            switch (header.getFieldType(idColumn)) {
                case 'L': 
                case 'l': {
                    stringBuilder.append("BOOLEAN");
                    continue block7;
                }
                case 'C': 
                case 'c': {
                    stringBuilder.append("VARCHAR(");
                    int length = header.getFieldLength(idColumn);
                    stringBuilder.append(String.valueOf(length));
                    stringBuilder.append(")");
                    continue block7;
                }
                case 'D': 
                case 'd': {
                    stringBuilder.append("DATE");
                    continue block7;
                }
                case 'N': 
                case 'n': {
                    if (header.getFieldDecimalCount(idColumn) == 0) {
                        if (header.getFieldLength(idColumn) >= 0 && header.getFieldLength(idColumn) < 10) {
                            stringBuilder.append("INT4");
                            continue block7;
                        }
                        stringBuilder.append("INT8");
                        continue block7;
                    }
                    stringBuilder.append("FLOAT8");
                    continue block7;
                }
                case 'F': 
                case 'O': 
                case 'f': 
                case 'o': {
                    stringBuilder.append("FLOAT8");
                    continue block7;
                }
                default: {
                    throw new IOException("Unknown DBF field type " + header.getFieldType(idColumn));
                }
            }
        }
        return stringBuilder.toString();
    }

    public static DbaseFileHeader dBaseHeaderFromMetaData(ResultSetMetaData metaData, List<Integer> retainedColumns) throws SQLException {
        DbaseFileHeader dbaseFileHeader = new DbaseFileHeader();
        for (int fieldId = 1; fieldId <= metaData.getColumnCount(); ++fieldId) {
            String fieldTypeName = metaData.getColumnTypeName(fieldId);
            if (fieldTypeName.equalsIgnoreCase("geometry")) continue;
            DBFType dbfType = DBFDriverFunction.getDBFType(metaData.getColumnType(fieldId), fieldTypeName, metaData.getColumnDisplaySize(fieldId), metaData.getPrecision(fieldId));
            try {
                dbaseFileHeader.addColumn(metaData.getColumnName(fieldId), dbfType.type, dbfType.fieldLength, dbfType.decimalCount);
                retainedColumns.add(fieldId);
                continue;
            }
            catch (DbaseFileException ex) {
                throw new SQLException(ex.getLocalizedMessage(), ex);
            }
        }
        return dbaseFileHeader;
    }

    private static DBFType getDBFType(int sqlTypeId, String sqlTypeName, int length, int precision) throws SQLException {
        switch (sqlTypeId) {
            case 16: {
                return new DBFType('l', 1, 0);
            }
            case -7: {
                return new DBFType('n', Math.min(3, length), 0);
            }
            case 91: {
                return new DBFType('d', 8, 0);
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return new DBFType('f', Math.min(20, length + 1), Math.min(18, precision));
            }
            case 4: {
                return new DBFType('n', Math.min(10, length), 0);
            }
            case -5: {
                return new DBFType('n', Math.min(18, length), 0);
            }
            case 5: {
                return new DBFType('n', Math.min(5, length), 0);
            }
            case -15: 
            case 1: 
            case 12: {
                return new DBFType('c', Math.min(254, length), 0);
            }
        }
        throw new SQLException("Field type not supported by DBF : " + sqlTypeName);
    }

    private static class DBFType {
        char type;
        int fieldLength;
        int decimalCount;

        DBFType(char type, int fieldLength, int decimalCount) {
            this.type = type;
            this.fieldLength = fieldLength;
            this.decimalCount = decimalCount;
        }
    }
}

