/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.drivers.dbf;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.h2.command.ddl.CreateTableData;
import org.h2.table.Column;
import org.h2gis.drivers.dbf.internal.DBFDriver;
import org.h2gis.drivers.dbf.internal.DbaseFileHeader;
import org.h2gis.drivers.file_table.FileEngine;

public class DBFEngine
extends FileEngine<DBFDriver> {
    @Override
    protected DBFDriver createDriver(File filePath, List<String> args) throws IOException {
        DBFDriver driver = new DBFDriver();
        driver.initDriverFromFile(filePath, args.size() > 1 ? args.get(1) : null);
        return driver;
    }

    @Override
    protected void feedCreateTableData(DBFDriver driver, CreateTableData data) throws IOException {
        DbaseFileHeader header = driver.getDbaseFileHeader();
        DBFEngine.feedTableDataFromHeader(header, data);
    }

    public static void feedTableDataFromHeader(DbaseFileHeader header, CreateTableData data) throws IOException {
        for (int i = 0; i < header.getNumFields(); ++i) {
            String fieldsName = header.getFieldName(i);
            int type = DBFEngine.dbfTypeToH2Type(header, i);
            Column column = new Column(fieldsName.toUpperCase(), type);
            column.setPrecision((long)header.getFieldLength(i));
            data.columns.add(column);
        }
    }

    private static int dbfTypeToH2Type(DbaseFileHeader header, int i) throws IOException {
        switch (header.getFieldType(i)) {
            case 'L': 
            case 'l': {
                return 1;
            }
            case 'C': 
            case 'c': {
                return 21;
            }
            case 'D': 
            case 'd': {
                return 10;
            }
            case 'N': 
            case 'n': {
                if (header.getFieldDecimalCount(i) == 0) {
                    if (header.getFieldLength(i) >= 0 && header.getFieldLength(i) < 10) {
                        return 4;
                    }
                    return 5;
                }
            }
            case 'F': 
            case 'O': 
            case 'f': 
            case 'o': {
                return 7;
            }
        }
        throw new IOException("Unknown DBF field type " + header.getFieldType(i));
    }
}

