/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.drivers.dbf;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.h2gis.drivers.dbf.DBFDriverFunction;
import org.h2gis.h2spatialapi.AbstractFunction;
import org.h2gis.h2spatialapi.EmptyProgressVisitor;
import org.h2gis.h2spatialapi.ProgressVisitor;
import org.h2gis.h2spatialapi.ScalarFunction;
import org.h2gis.utilities.URIUtility;

public class DBFWrite
extends AbstractFunction
implements ScalarFunction {
    public DBFWrite() {
        this.addProperty("remarks", "Transfer the content of a table into a DBF\nCALL DBFWRITE('FILENAME', 'TABLE'[,'ENCODING'])");
    }

    public String getJavaStaticMethod() {
        return "exportTable";
    }

    public static void exportTable(Connection connection, String fileName, String tableReference) throws IOException, SQLException {
        DBFDriverFunction driverFunction = new DBFDriverFunction();
        driverFunction.exportTable(connection, tableReference, URIUtility.fileFromString((String)fileName), (ProgressVisitor)new EmptyProgressVisitor());
    }

    public static void exportTable(Connection connection, String fileName, String tableReference, String encoding) throws IOException, SQLException {
        DBFDriverFunction driverFunction = new DBFDriverFunction();
        driverFunction.exportTable(connection, tableReference, new File(fileName), (ProgressVisitor)new EmptyProgressVisitor(), encoding);
    }
}

