/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.drivers.dbf.internal;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.h2gis.drivers.dbf.internal.DbaseFileException;
import org.h2gis.drivers.utility.ReadBufferManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbaseFileHeader {
    private Logger log = LoggerFactory.getLogger(DbaseFileHeader.class);
    public static String DEFAULT_ENCODING = "cp1252";
    public static byte DEFAULT_ENCODING_FLAG = (byte)3;
    private static final String FIELD_LENGTH_FOR = "Field Length for ";
    private static final int FILE_DESCRIPTOR_SIZE = 32;
    private static Map<Byte, String> CODE_PAGE_ENCODING = new HashMap<Byte, String>();
    private static final byte MAGIC = 3;
    private static final int MINIMUM_HEADER = 33;
    private static final String SET_TO = " set to ";
    private Date date = new Date();
    private int recordCnt = 0;
    private int fieldCnt = 0;
    private int recordLength = 1;
    private int headerLength = -1;
    private int largestFieldSize = 0;
    private String fileEncoding = DEFAULT_ENCODING;
    private DbaseField[] fields = new DbaseField[0];

    public void addColumn(String inFieldName, char inFieldType, int inFieldLength, int inDecimalCount) throws DbaseFileException {
        if (inFieldLength <= 0) {
            throw new DbaseFileException("field length <= 0");
        }
        if (this.fields == null) {
            this.fields = new DbaseField[0];
        }
        int tempLength = 1;
        DbaseField[] tempFieldDescriptors = new DbaseField[this.fields.length + 1];
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i].fieldDataAddress = tempLength;
            tempLength += this.fields[i].fieldLength;
            tempFieldDescriptors[i] = this.fields[i];
        }
        tempFieldDescriptors[this.fields.length] = new DbaseField();
        tempFieldDescriptors[this.fields.length].fieldLength = inFieldLength;
        tempFieldDescriptors[this.fields.length].decimalCount = inDecimalCount;
        tempFieldDescriptors[this.fields.length].fieldDataAddress = tempLength;
        String tempFieldName = inFieldName;
        if (tempFieldName == null) {
            tempFieldName = "NoName";
        }
        if (tempFieldName.length() > 10) {
            tempFieldName = tempFieldName.substring(0, 10);
            this.log.warn("FieldName " + inFieldName + " is longer than 10 characters, truncating to " + tempFieldName);
        }
        tempFieldDescriptors[this.fields.length].fieldName = tempFieldName;
        if (inFieldType == 'C' || inFieldType == 'c') {
            tempFieldDescriptors[this.fields.length].fieldType = (char)67;
            if (inFieldLength > 254) {
                this.log.warn(FIELD_LENGTH_FOR + inFieldName + SET_TO + inFieldLength + " Which is longer than 254, not consistent with dbase III");
            }
        } else if (inFieldType == 'S' || inFieldType == 's') {
            tempFieldDescriptors[this.fields.length].fieldType = (char)67;
            this.log.warn("Field type for " + inFieldName + " set to S which is flat out wrong people!, I am setting this to C, in the hopes you meant character.");
            if (inFieldLength > 254) {
                this.log.warn(FIELD_LENGTH_FOR + inFieldName + SET_TO + inFieldLength + " Which is longer than 254, not consistent with dbase III");
            }
            tempFieldDescriptors[this.fields.length].fieldLength = 8;
        } else if (inFieldType == 'D' || inFieldType == 'd') {
            tempFieldDescriptors[this.fields.length].fieldType = (char)68;
            if (inFieldLength != 8) {
                this.log.warn(FIELD_LENGTH_FOR + inFieldName + SET_TO + inFieldLength + " Setting to 8 digets YYYYMMDD");
            }
            tempFieldDescriptors[this.fields.length].fieldLength = 8;
        } else if (inFieldType == 'F' || inFieldType == 'f') {
            tempFieldDescriptors[this.fields.length].fieldType = (char)70;
            if (inFieldLength > 20) {
                this.log.warn(FIELD_LENGTH_FOR + inFieldName + SET_TO + inFieldLength + " Preserving length, but should be set to Max of 20 not valid for dbase IV, and UP specification, not present in dbaseIII.");
            }
        } else if (inFieldType == 'N' || inFieldType == 'n') {
            tempFieldDescriptors[this.fields.length].fieldType = (char)78;
            if (inFieldLength > 18) {
                this.log.warn(FIELD_LENGTH_FOR + inFieldName + SET_TO + inFieldLength + " Preserving length, but should be set to Max of 18 for dbase III specification.");
            }
            if (inDecimalCount < 0) {
                this.log.warn("Field Decimal Position for " + inFieldName + SET_TO + inDecimalCount + " Setting to 0 no decimal data will be saved.");
                tempFieldDescriptors[this.fields.length].decimalCount = 0;
            }
            if (inDecimalCount > inFieldLength - 1) {
                this.log.warn("Field Decimal Position for " + inFieldName + SET_TO + inDecimalCount + " Setting to " + (inFieldLength - 1) + " no non decimal data will be saved.");
                tempFieldDescriptors[this.fields.length].decimalCount = inFieldLength - 1;
            }
        } else if (inFieldType == 'L' || inFieldType == 'l') {
            tempFieldDescriptors[this.fields.length].fieldType = (char)76;
            if (inFieldLength != 1) {
                this.log.warn(FIELD_LENGTH_FOR + inFieldName + SET_TO + inFieldLength + " Setting to length of 1 for logical fields.");
            }
            tempFieldDescriptors[this.fields.length].fieldLength = 1;
        } else {
            throw new DbaseFileException("Undefined field type " + inFieldType + " For column " + inFieldName);
        }
        this.fields = tempFieldDescriptors;
        this.fieldCnt = this.fields.length;
        this.headerLength = 33 + 32 * this.fields.length;
        this.recordLength = tempLength += tempFieldDescriptors[this.fields.length].fieldLength;
    }

    public int removeColumn(String inFieldName) {
        int retCol = -1;
        int tempLength = 1;
        DbaseField[] tempFieldDescriptors = new DbaseField[this.fields.length - 1];
        int j = 0;
        for (int i = 0; i < this.fields.length; ++i) {
            if (!inFieldName.equalsIgnoreCase(this.fields[i].fieldName.trim())) {
                if (i == j && i == this.fields.length - 1) {
                    throw new IllegalArgumentException("Could not find a field named '" + inFieldName + "' for removal");
                }
                tempFieldDescriptors[j] = this.fields[i];
                tempFieldDescriptors[j].fieldDataAddress = tempLength;
                tempLength += tempFieldDescriptors[j].fieldLength;
                ++j;
                continue;
            }
            retCol = i;
        }
        this.fields = tempFieldDescriptors;
        this.headerLength = 33 + 32 * this.fields.length;
        this.recordLength = tempLength;
        return retCol;
    }

    public int getFieldLength(int inIndex) {
        return this.fields[inIndex].fieldLength;
    }

    public String getFileEncoding() {
        return this.fileEncoding;
    }

    public int getFieldDecimalCount(int inIndex) {
        return this.fields[inIndex].decimalCount;
    }

    public String getFieldName(int inIndex) {
        return this.fields[inIndex].fieldName;
    }

    public char getFieldType(int inIndex) {
        return this.fields[inIndex].fieldType;
    }

    public Date getLastUpdateDate() {
        return this.date;
    }

    public int getNumFields() {
        return this.fields.length;
    }

    public int getNumRecords() {
        return this.recordCnt;
    }

    public int getRecordLength() {
        return this.recordLength;
    }

    public int getHeaderLength() {
        return this.headerLength;
    }

    public void readHeader(FileChannel channel, String forceEncoding) throws IOException {
        if (forceEncoding != null) {
            this.fileEncoding = forceEncoding;
        }
        ReadBufferManager in = new ReadBufferManager(channel);
        in.order(ByteOrder.LITTLE_ENDIAN);
        byte magic = in.get();
        if (magic != 3) {
            this.log.warn("Unsupported DBF file Type " + Integer.toHexString(magic));
        }
        int tempUpdateYear = in.get();
        byte tempUpdateMonth = in.get();
        byte tempUpdateDay = in.get();
        tempUpdateYear = tempUpdateYear > 90 ? (tempUpdateYear += 1900) : (tempUpdateYear += 2000);
        Calendar c = Calendar.getInstance();
        c.set(1, tempUpdateYear);
        c.set(2, tempUpdateMonth - 1);
        c.set(5, tempUpdateDay);
        this.date = c.getTime();
        this.recordCnt = in.getInt();
        this.headerLength = in.get() & 0xFF | (in.get() & 0xFF) << 8;
        this.recordLength = in.get() & 0xFF | (in.get() & 0xFF) << 8;
        in.skip(17);
        byte lngDriver = in.get();
        String encoding = CODE_PAGE_ENCODING.get(lngDriver);
        if (encoding != null && forceEncoding == null) {
            this.fileEncoding = encoding;
        }
        in.skip(2);
        this.fieldCnt = (this.headerLength - 32 - 1) / 32;
        ArrayList<DbaseField> lfields = new ArrayList<DbaseField>();
        for (int i = 0; i < this.fieldCnt; ++i) {
            DbaseField field = new DbaseField();
            byte[] buffer = new byte[11];
            in.get(buffer);
            String name = new String(buffer, this.fileEncoding);
            int nullPoint = name.indexOf(0);
            if (nullPoint != -1) {
                name = name.substring(0, nullPoint);
            }
            field.fieldName = name.trim();
            field.fieldType = (char)in.get();
            field.fieldDataAddress = in.getInt();
            int length = in.get();
            if (length < 0) {
                length += 256;
            }
            field.fieldLength = length;
            if (length > this.largestFieldSize) {
                this.largestFieldSize = length;
            }
            field.decimalCount = in.get();
            in.skip(14);
            if (field.fieldLength <= 0) continue;
            lfields.add(field);
        }
        in.skip(1);
        this.fields = new DbaseField[lfields.size()];
        this.fields = lfields.toArray(this.fields);
    }

    public int getLargestFieldSize() {
        return this.largestFieldSize;
    }

    public void setNumRecords(int inNumRecords) {
        this.recordCnt = inNumRecords;
    }

    public boolean setEncoding(String encoding) {
        for (Map.Entry<Byte, String> entry : CODE_PAGE_ENCODING.entrySet()) {
            if (!entry.getValue().equalsIgnoreCase(encoding)) continue;
            this.fileEncoding = entry.getValue();
            return true;
        }
        return false;
    }

    private byte getEncodingByte() {
        for (Map.Entry<Byte, String> entry : CODE_PAGE_ENCODING.entrySet()) {
            if (!entry.getValue().equalsIgnoreCase(this.fileEncoding)) continue;
            return entry.getKey();
        }
        return DEFAULT_ENCODING_FLAG;
    }

    public void writeHeader(WritableByteChannel out) throws IOException {
        if (this.headerLength == -1) {
            this.headerLength = 33;
        }
        ByteBuffer buffer = ByteBuffer.allocateDirect(this.headerLength);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put((byte)3);
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        buffer.put((byte)(c.get(1) % 100));
        buffer.put((byte)(c.get(2) + 1));
        buffer.put((byte)c.get(5));
        buffer.putInt(this.recordCnt);
        buffer.putShort((short)this.headerLength);
        buffer.putShort((short)this.recordLength);
        buffer.position(buffer.position() + 17);
        buffer.put(this.getEncodingByte());
        buffer.position(buffer.position() + 2);
        int tempOffset = 0;
        for (DbaseField field : this.fields) {
            byte[] fieldName = field.fieldName.getBytes(this.fileEncoding);
            for (int j = 0; j < 11; ++j) {
                if (fieldName.length > j) {
                    buffer.put(fieldName[j]);
                    continue;
                }
                buffer.put((byte)0);
            }
            buffer.put((byte)field.fieldType);
            buffer.putInt(tempOffset);
            tempOffset += field.fieldLength;
            buffer.put((byte)field.fieldLength);
            buffer.put((byte)field.decimalCount);
            buffer.position(buffer.position() + 14);
        }
        buffer.put((byte)13);
        buffer.position(0);
        int r = buffer.remaining();
        while ((r -= out.write(buffer)) > 0) {
        }
    }

    public String toString() {
        StringBuilder fs = new StringBuilder();
        for (DbaseField f : this.fields) {
            fs.append(f.fieldName).append(" ").append(f.fieldType).append(" ").append(f.fieldLength).append(" ").append(f.decimalCount).append(" ").append(f.fieldDataAddress).append("\n");
        }
        return "DB3 Header\nDate : " + this.date + "\n" + "Records : " + this.recordCnt + "\n" + "Fields : " + this.fieldCnt + "\n" + fs;
    }

    static {
        CODE_PAGE_ENCODING.put((byte)0, "UTF-8");
        CODE_PAGE_ENCODING.put((byte)1, "cp437");
        CODE_PAGE_ENCODING.put((byte)2, "cp850");
        CODE_PAGE_ENCODING.put((byte)3, DEFAULT_ENCODING);
        CODE_PAGE_ENCODING.put((byte)8, "cp865");
        CODE_PAGE_ENCODING.put((byte)9, "cp437");
        CODE_PAGE_ENCODING.put((byte)10, "cp850");
        CODE_PAGE_ENCODING.put((byte)11, "cp437");
        CODE_PAGE_ENCODING.put((byte)13, "cp437");
        CODE_PAGE_ENCODING.put((byte)14, "cp850");
        CODE_PAGE_ENCODING.put((byte)15, "cp437");
        CODE_PAGE_ENCODING.put((byte)16, "cp850");
        CODE_PAGE_ENCODING.put((byte)17, "cp437");
        CODE_PAGE_ENCODING.put((byte)18, "cp850");
        CODE_PAGE_ENCODING.put((byte)19, "cp932");
        CODE_PAGE_ENCODING.put((byte)20, "cp850");
        CODE_PAGE_ENCODING.put((byte)21, "cp437");
        CODE_PAGE_ENCODING.put((byte)22, "cp850");
        CODE_PAGE_ENCODING.put((byte)23, "cp865");
        CODE_PAGE_ENCODING.put((byte)24, "cp437");
        CODE_PAGE_ENCODING.put((byte)25, "cp437");
        CODE_PAGE_ENCODING.put((byte)26, "cp850");
        CODE_PAGE_ENCODING.put((byte)27, "cp437");
        CODE_PAGE_ENCODING.put((byte)28, "cp863");
        CODE_PAGE_ENCODING.put((byte)29, "cp850");
        CODE_PAGE_ENCODING.put((byte)31, "cp852");
        CODE_PAGE_ENCODING.put((byte)34, "cp852");
        CODE_PAGE_ENCODING.put((byte)35, "cp852");
        CODE_PAGE_ENCODING.put((byte)36, "cp860");
        CODE_PAGE_ENCODING.put((byte)37, "cp850");
        CODE_PAGE_ENCODING.put((byte)38, "cp866");
        CODE_PAGE_ENCODING.put((byte)55, "cp850");
        CODE_PAGE_ENCODING.put((byte)64, "cp852");
        CODE_PAGE_ENCODING.put((byte)77, "cp936");
        CODE_PAGE_ENCODING.put((byte)78, "cp949");
        CODE_PAGE_ENCODING.put((byte)79, "cp950");
        CODE_PAGE_ENCODING.put((byte)80, "cp874");
        CODE_PAGE_ENCODING.put((byte)87, DEFAULT_ENCODING);
        CODE_PAGE_ENCODING.put((byte)88, DEFAULT_ENCODING);
        CODE_PAGE_ENCODING.put((byte)89, DEFAULT_ENCODING);
        CODE_PAGE_ENCODING.put((byte)100, "cp852");
        CODE_PAGE_ENCODING.put((byte)101, "cp866");
        CODE_PAGE_ENCODING.put((byte)102, "cp865");
        CODE_PAGE_ENCODING.put((byte)103, "cp861");
        CODE_PAGE_ENCODING.put((byte)106, "cp737");
        CODE_PAGE_ENCODING.put((byte)107, "cp857");
        CODE_PAGE_ENCODING.put((byte)108, "cp863");
        CODE_PAGE_ENCODING.put((byte)120, "cp950");
        CODE_PAGE_ENCODING.put((byte)121, "cp949");
        CODE_PAGE_ENCODING.put((byte)122, "cp936");
        CODE_PAGE_ENCODING.put((byte)123, "cp932");
        CODE_PAGE_ENCODING.put((byte)124, "cp874");
        CODE_PAGE_ENCODING.put((byte)-122, "cp737");
        CODE_PAGE_ENCODING.put((byte)-121, "cp852");
        CODE_PAGE_ENCODING.put((byte)-120, "cp857");
        CODE_PAGE_ENCODING.put((byte)-56, "cp1250");
        CODE_PAGE_ENCODING.put((byte)-55, "cp1251");
        CODE_PAGE_ENCODING.put((byte)-54, "cp1254");
        CODE_PAGE_ENCODING.put((byte)-53, "cp1253");
        CODE_PAGE_ENCODING.put((byte)-52, "cp1257");
    }

    static class DbaseField {
        String fieldName;
        char fieldType;
        int fieldDataAddress;
        int fieldLength;
        int decimalCount;

        DbaseField() {
        }
    }
}

