/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.drivers.file_table;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.h2.command.ddl.CreateTableData;
import org.h2.engine.Session;
import org.h2.engine.SysProperties;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.SpatialTreeIndex;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.schema.SchemaObject;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableBase;
import org.h2.util.MathUtils;
import org.h2.util.New;
import org.h2gis.drivers.FileDriver;
import org.h2gis.drivers.file_table.H2TableIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2Table
extends TableBase {
    private FileDriver driver;
    private static final Logger LOG = LoggerFactory.getLogger(H2Table.class);
    private final ArrayList<Index> indexes = New.arrayList();
    private Column rowIdColumn;

    public H2Table(FileDriver driver, CreateTableData data) throws IOException {
        super(data);
        this.indexes.add((Index)new H2TableIndex(driver, (Table)this, this.getId(), (Column)data.columns.get(0), data.schema.getUniqueIndexName(data.session, (Table)this, data.tableName + "." + ((Column)data.columns.get(0)).getName() + "_INDEX_")));
        this.driver = driver;
    }

    public void init(Session session) {
        this.indexes.add(0, (Index)new H2TableIndex(this.driver, (Table)this, this.getId()));
    }

    public boolean lock(Session session, boolean exclusive, boolean force) {
        return false;
    }

    public void close(Session session) {
        for (Index index : this.indexes) {
            index.close(session);
        }
        try {
            this.driver.close();
        }
        catch (IOException ex) {
            LOG.error("Error while closing the SHP driver", (Throwable)ex);
        }
    }

    public void unlock(Session s) {
    }

    public Row getRow(Session session, long key) {
        return this.indexes.get(0).getRow(session, key);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Index addIndex(Session session, String indexName, int indexId, IndexColumn[] cols, IndexType indexType, boolean create, String indexComment) {
        SpatialTreeIndex index;
        boolean isSessionTemporary;
        boolean bl = isSessionTemporary = this.isTemporary() && !this.isGlobalTemporary();
        if (!isSessionTemporary) {
            this.database.lockMeta(session);
        }
        if (this.isPersistIndexes() && indexType.isPersistent()) {
            if (!indexType.isSpatial()) throw DbException.getUnsupportedException((String)"VIEW");
            index = new SpatialTreeIndex((Table)this, indexId, indexName, cols, indexType, true, create, session);
        } else {
            if (!indexType.isSpatial()) throw DbException.getUnsupportedException((String)"VIEW");
            index = new SpatialTreeIndex((Table)this, indexId, indexName, cols, indexType, false, true, session);
        }
        if (index.needRebuild() && this.getRowCount(session) > 0L) {
            try {
                long remaining;
                Index scan = this.getScanIndex(session);
                long total = remaining = scan.getRowCount(session);
                Cursor cursor = scan.find(session, null, null);
                long i = 0L;
                int bufferSize = (int)Math.min(this.getRowCount(session), (long)this.database.getMaxMemoryRows());
                ArrayList buffer = New.arrayList((int)bufferSize);
                String n = this.getName() + ":" + index.getName();
                int t = MathUtils.convertLongToInt((long)total);
                while (cursor.next()) {
                    this.database.setProgress(1, n, MathUtils.convertLongToInt((long)i++), t);
                    Row row = cursor.get();
                    buffer.add(row);
                    if (buffer.size() >= bufferSize) {
                        H2Table.addRowsToIndex(session, buffer, (Index)index);
                    }
                    --remaining;
                }
                H2Table.addRowsToIndex(session, buffer, (Index)index);
                if (SysProperties.CHECK && remaining != 0L) {
                    throw DbException.throwInternalError((String)("rowcount remaining=" + remaining + " " + this.getName()));
                }
            }
            catch (DbException e) {
                this.getSchema().freeUniqueName(indexName);
                try {
                    index.remove(session);
                    throw e;
                }
                catch (DbException e2) {
                    this.trace.error((Throwable)e2, "could not remove index");
                    throw e2;
                }
            }
        }
        index.setTemporary(this.isTemporary());
        if (index.getCreateSQL() != null) {
            index.setComment(indexComment);
            if (isSessionTemporary) {
                session.addLocalTempTableIndex((Index)index);
            } else {
                this.database.addSchemaObject(session, (SchemaObject)index);
            }
        }
        this.indexes.add((Index)index);
        this.setModified();
        return index;
    }

    private static void addRowsToIndex(Session session, ArrayList<Row> list, Index index) {
        final Index idx = index;
        Collections.sort(list, new Comparator<Row>(){

            @Override
            public int compare(Row r1, Row r2) {
                return idx.compareRows((SearchRow)r1, (SearchRow)r2);
            }
        });
        for (Row row : list) {
            index.add(session, row);
        }
        list.clear();
    }

    public void removeRow(Session session, Row row) {
        throw DbException.get((int)50100, (String)"removeRow in Shape files");
    }

    public void truncate(Session session) {
        for (Index index : this.indexes) {
            index.truncate(session);
        }
    }

    public void addRow(Session session, Row row) {
        throw DbException.get((int)50100, (String)"addRow in Shape files");
    }

    public void checkSupportAlter() {
        throw DbException.get((int)50100, (String)"addRow in Shape files");
    }

    public String getTableType() {
        return "EXTERNAL";
    }

    public Index getScanIndex(Session session) {
        for (Index index : this.indexes) {
            if (!index.getIndexType().isScan()) continue;
            return index;
        }
        return null;
    }

    public Index getUniqueIndex() {
        for (Index idx : this.indexes) {
            if (!idx.getIndexType().isUnique()) continue;
            return idx;
        }
        return null;
    }

    public ArrayList<Index> getIndexes() {
        return this.indexes;
    }

    public boolean isLockedExclusively() {
        return false;
    }

    public long getMaxDataModificationId() {
        return 0L;
    }

    public boolean isDeterministic() {
        return true;
    }

    public boolean canGetRowCount() {
        return true;
    }

    public boolean canDrop() {
        return true;
    }

    public long getRowCount(Session session) {
        return this.driver.getRowCount();
    }

    public long getRowCountApproximation() {
        return this.driver.getRowCount();
    }

    public long getDiskSpaceUsed() {
        return 0L;
    }

    public void checkRename() {
    }

    public Column getRowIdColumn() {
        if (this.rowIdColumn == null) {
            this.rowIdColumn = new Column("_ROWID_", 5);
            this.rowIdColumn.setTable((Table)this, -1);
        }
        return this.rowIdColumn;
    }
}

