/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.drivers.geojson;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.h2gis.drivers.utility.FileUtil;
import org.h2gis.h2spatialapi.ProgressVisitor;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.SFSUtilities;
import org.h2gis.utilities.TableLocation;

public class GeoJsonWriteDriver {
    private final String tableName;
    private final File fileName;
    private final Connection connection;
    private Map<String, Integer> cachedColumnNames;
    private int columnCountProperties = -1;

    public GeoJsonWriteDriver(Connection connection, String tableName, File fileName) {
        this.connection = connection;
        this.tableName = tableName;
        this.fileName = fileName;
    }

    public void write(ProgressVisitor progress) throws SQLException, IOException {
        if (!FileUtil.isExtensionWellFormated(this.fileName, "geojson")) {
            throw new SQLException("Only .geojson extension is supported");
        }
        this.writeGeoJson(progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeGeoJson(ProgressVisitor progress) throws SQLException, IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.fileName);
            TableLocation parse = TableLocation.parse((String)this.tableName, (Boolean)JDBCUtilities.isH2DataBase((DatabaseMetaData)this.connection.getMetaData()));
            List spatialFieldNames = SFSUtilities.getGeometryFields((Connection)this.connection, (TableLocation)parse);
            if (spatialFieldNames.isEmpty()) {
                throw new SQLException(String.format("The table %s does not contain a geometry field", this.tableName));
            }
            Statement st = this.connection.createStatement();
            try {
                JsonFactory jsonFactory = new JsonFactory();
                JsonGenerator jsonGenerator = jsonFactory.createGenerator((OutputStream)new BufferedOutputStream(fos), JsonEncoding.UTF8);
                jsonGenerator.writeStartObject();
                jsonGenerator.writeStringField("type", "FeatureCollection");
                this.writeCRS(jsonGenerator, SFSUtilities.getAuthorityAndSRID((Connection)this.connection, (TableLocation)parse, (String)((String)spatialFieldNames.get(0))));
                jsonGenerator.writeArrayFieldStart("features");
                ResultSet rs = st.executeQuery(String.format("select * from %s", this.tableName));
                try {
                    ResultSetMetaData resultSetMetaData = rs.getMetaData();
                    int geoFieldIndex = JDBCUtilities.getFieldIndex((ResultSetMetaData)resultSetMetaData, (String)((String)spatialFieldNames.get(0)));
                    this.cacheMetadata(resultSetMetaData);
                    while (rs.next()) {
                        this.writeFeature(jsonGenerator, rs, geoFieldIndex);
                    }
                    progress.endStep();
                    jsonGenerator.writeEndArray();
                    jsonGenerator.writeEndObject();
                    jsonGenerator.flush();
                    jsonGenerator.close();
                }
                finally {
                    rs.close();
                }
            }
            finally {
                st.close();
            }
        }
        catch (FileNotFoundException ex) {
            throw new SQLException(ex);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException ex) {
                throw new SQLException(ex);
            }
        }
    }

    private void writeFeature(JsonGenerator jsonGenerator, ResultSet rs, int geoFieldIndex) throws IOException, SQLException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("type", "Feature");
        this.writeGeometry((Geometry)rs.getObject(geoFieldIndex), jsonGenerator);
        this.writeProperties(jsonGenerator, rs);
        jsonGenerator.writeEndObject();
    }

    private void cacheMetadata(ResultSetMetaData resultSetMetaData) throws SQLException {
        this.cachedColumnNames = new LinkedHashMap<String, Integer>();
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            String fieldTypeName = resultSetMetaData.getColumnTypeName(i);
            if (fieldTypeName.equalsIgnoreCase("geometry") || !this.isSupportedPropertyType(resultSetMetaData.getColumnType(i), fieldTypeName)) continue;
            this.cachedColumnNames.put(resultSetMetaData.getColumnName(i).toUpperCase(), i);
            ++this.columnCountProperties;
        }
    }

    private void writeGeometry(Geometry geom, JsonGenerator gen) throws IOException {
        gen.writeObjectFieldStart("geometry");
        if (geom instanceof Point) {
            this.write((Point)geom, gen);
        } else if (geom instanceof MultiPoint) {
            this.write((MultiPoint)geom, gen);
        } else if (geom instanceof LineString) {
            this.write((LineString)geom, gen);
        } else if (geom instanceof MultiLineString) {
            this.write((MultiLineString)geom, gen);
        } else if (geom instanceof Polygon) {
            this.write((Polygon)geom, gen);
        } else if (geom instanceof MultiPolygon) {
            this.write((MultiPolygon)geom, gen);
        } else if (geom instanceof GeometryCollection) {
            this.write((GeometryCollection)geom, gen);
        } else {
            throw new RuntimeException("Unsupported Geomery type");
        }
        gen.writeEndObject();
    }

    private void write(Point point, JsonGenerator gen) throws IOException {
        gen.writeStringField("type", "Point");
        gen.writeFieldName("coordinates");
        this.writeCoordinate(point.getCoordinate(), gen);
    }

    private void write(MultiPoint points, JsonGenerator gen) throws IOException {
        gen.writeStringField("type", "MultiPoint");
        gen.writeFieldName("coordinates");
        this.writeCoordinates(points.getCoordinates(), gen);
    }

    private void write(LineString geom, JsonGenerator gen) throws IOException {
        gen.writeStringField("type", "LineString");
        gen.writeFieldName("coordinates");
        this.writeCoordinates(geom.getCoordinates(), gen);
    }

    private void write(MultiLineString geom, JsonGenerator gen) throws IOException {
        gen.writeStringField("type", "MultiLineString");
        gen.writeFieldName("coordinates");
        gen.writeStartArray();
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            this.writeCoordinates(geom.getGeometryN(i).getCoordinates(), gen);
        }
        gen.writeEndArray();
    }

    private void write(GeometryCollection coll, JsonGenerator gen) throws IOException {
        gen.writeStringField("type", "GeometryCollection");
        gen.writeArrayFieldStart("geometries");
        for (int i = 0; i < coll.getNumGeometries(); ++i) {
            Geometry geom = coll.getGeometryN(i);
            gen.writeStartObject();
            if (geom instanceof Point) {
                this.write((Point)geom, gen);
            } else if (geom instanceof MultiPoint) {
                this.write((MultiPoint)geom, gen);
            } else if (geom instanceof LineString) {
                this.write((LineString)geom, gen);
            } else if (geom instanceof MultiLineString) {
                this.write((MultiLineString)geom, gen);
            } else if (geom instanceof Polygon) {
                this.write((Polygon)geom, gen);
            } else if (geom instanceof MultiPolygon) {
                this.write((MultiPolygon)geom, gen);
            } else if (geom instanceof GeometryCollection) {
                this.write((GeometryCollection)geom, gen);
            } else {
                throw new RuntimeException("Unsupported Geomery type");
            }
            gen.writeEndObject();
        }
        gen.writeEndArray();
    }

    private void write(Polygon geom, JsonGenerator gen) throws IOException {
        gen.writeStringField("type", "Polygon");
        gen.writeFieldName("coordinates");
        gen.writeStartArray();
        this.writeCoordinates(geom.getExteriorRing().getCoordinates(), gen);
        for (int i = 0; i < geom.getNumInteriorRing(); ++i) {
            this.writeCoordinates(geom.getInteriorRingN(i).getCoordinates(), gen);
        }
        gen.writeEndArray();
    }

    private void write(MultiPolygon geom, JsonGenerator gen) throws IOException {
        gen.writeStringField("type", "MultiPolygon");
        gen.writeFieldName("coordinates");
        gen.writeStartArray();
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            Polygon p = (Polygon)geom.getGeometryN(i);
            gen.writeStartArray();
            this.writeCoordinates(p.getExteriorRing().getCoordinates(), gen);
            for (int j = 0; j < p.getNumInteriorRing(); ++j) {
                this.writeCoordinates(p.getInteriorRingN(j).getCoordinates(), gen);
            }
            gen.writeEndArray();
        }
        gen.writeEndArray();
    }

    private void writeCoordinate(Coordinate coordinate, JsonGenerator gen) throws IOException {
        gen.writeStartArray();
        gen.writeNumber(coordinate.x);
        gen.writeNumber(coordinate.y);
        if (!Double.isNaN(coordinate.z)) {
            gen.writeNumber(coordinate.z);
        }
        gen.writeEndArray();
    }

    private void writeCoordinates(Coordinate[] coordinates, JsonGenerator gen) throws IOException {
        gen.writeStartArray();
        for (Coordinate coord : coordinates) {
            this.writeCoordinate(coord, gen);
        }
        gen.writeEndArray();
    }

    private void writeProperties(JsonGenerator jsonGenerator, ResultSet rs) throws IOException, SQLException {
        if (this.columnCountProperties != -1) {
            jsonGenerator.writeObjectFieldStart("properties");
            for (Map.Entry<String, Integer> entry : this.cachedColumnNames.entrySet()) {
                String string = entry.getKey();
                Integer fieldId = entry.getValue();
                jsonGenerator.writeObjectField(string, rs.getObject(fieldId));
            }
            jsonGenerator.writeEndObject();
        }
    }

    public boolean isSupportedPropertyType(int sqlTypeId, String sqlTypeName) throws SQLException {
        switch (sqlTypeId) {
            case -15: 
            case -5: 
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 12: 
            case 16: 
            case 91: {
                return true;
            }
        }
        throw new SQLException("Field type not supported by GeoJSON driver: " + sqlTypeName);
    }

    private void writeCRS(JsonGenerator jsonGenerator, String[] authorityAndSRID) throws IOException {
        if (authorityAndSRID[1] != null) {
            jsonGenerator.writeObjectFieldStart("crs");
            jsonGenerator.writeStringField("type", "name");
            jsonGenerator.writeObjectFieldStart("properties");
            StringBuilder sb = new StringBuilder("urn:ogc:def:crs:");
            sb.append(authorityAndSRID[0]).append("::").append(authorityAndSRID[1]);
            jsonGenerator.writeStringField("name", sb.toString());
            jsonGenerator.writeEndObject();
            jsonGenerator.writeEndObject();
        }
    }
}

