/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.drivers.geojson;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import org.h2gis.h2spatialapi.DeterministicScalarFunction;

public class ST_AsGeoJSON
extends DeterministicScalarFunction {
    public ST_AsGeoJSON() {
        this.addProperty("remarks", "Return the geometry as a Geometry Javascript Object Notation (GeoJSON 1.0) element.\n2D and 3D Geometries are both supported.\nGeoJSON only supports SFS 1.1 geometry types (POINT, LINESTRING, POLYGON and COLLECTION).");
    }

    public String getJavaStaticMethod() {
        return "toGeojson";
    }

    public static String toGeojson(Geometry geom) {
        StringBuilder sb = new StringBuilder();
        ST_AsGeoJSON.toGeojsonGeometry(geom, sb);
        return sb.toString();
    }

    public static void toGeojsonGeometry(Geometry geom, StringBuilder sb) {
        if (geom instanceof Point) {
            ST_AsGeoJSON.toGeojsonPoint((Point)geom, sb);
        } else if (geom instanceof LineString) {
            ST_AsGeoJSON.toGeojsonLineString((LineString)geom, sb);
        } else if (geom instanceof Polygon) {
            ST_AsGeoJSON.toGeojsonPolygon((Polygon)geom, sb);
        } else if (geom instanceof MultiPoint) {
            ST_AsGeoJSON.toGeojsonMultiPoint((MultiPoint)geom, sb);
        } else if (geom instanceof MultiLineString) {
            ST_AsGeoJSON.toGeojsonMultiLineString((MultiLineString)geom, sb);
        } else if (geom instanceof MultiPolygon) {
            ST_AsGeoJSON.toGeojsonMultiPolygon((MultiPolygon)geom, sb);
        } else {
            ST_AsGeoJSON.toGeojsonGeometryCollection((GeometryCollection)geom, sb);
        }
    }

    public static void toGeojsonPoint(Point point, StringBuilder sb) {
        Coordinate coord = point.getCoordinate();
        sb.append("{\"type\":\"Point\",\"coordinates\":[");
        sb.append(coord.x).append(",").append(coord.y);
        if (!Double.isNaN(coord.z)) {
            sb.append(",").append(coord.z);
        }
        sb.append("]}");
    }

    public static void toGeojsonMultiPoint(MultiPoint multiPoint, StringBuilder sb) {
        sb.append("{\"type\":\"MultiPoint\",\"coordinates\":");
        ST_AsGeoJSON.toGeojsonCoordinates(multiPoint.getCoordinates(), sb);
        sb.append("}");
    }

    public static void toGeojsonLineString(LineString lineString, StringBuilder sb) {
        sb.append("{\"type\":\"LineString\",\"coordinates\":");
        ST_AsGeoJSON.toGeojsonCoordinates(lineString.getCoordinates(), sb);
        sb.append("}");
    }

    public static void toGeojsonMultiLineString(MultiLineString multiLineString, StringBuilder sb) {
        sb.append("{\"type\":\"MultiLineString\",\"coordinates\":[");
        for (int i = 0; i < multiLineString.getNumGeometries(); ++i) {
            ST_AsGeoJSON.toGeojsonCoordinates(multiLineString.getGeometryN(i).getCoordinates(), sb);
            if (i >= multiLineString.getNumGeometries() - 1) continue;
            sb.append(",");
        }
        sb.append("]}");
    }

    public static void toGeojsonPolygon(Polygon polygon, StringBuilder sb) {
        sb.append("{\"type\":\"Polygon\",\"coordinates\":[");
        ST_AsGeoJSON.toGeojsonCoordinates(polygon.getExteriorRing().getCoordinates(), sb);
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            sb.append(",");
            ST_AsGeoJSON.toGeojsonCoordinates(polygon.getInteriorRingN(i).getCoordinates(), sb);
        }
        sb.append("]}");
    }

    public static void toGeojsonMultiPolygon(MultiPolygon multiPolygon, StringBuilder sb) {
        sb.append("{\"type\":\"MultiPolygon\",\"coordinates\":[");
        for (int i = 0; i < multiPolygon.getNumGeometries(); ++i) {
            Polygon p = (Polygon)multiPolygon.getGeometryN(i);
            sb.append("[");
            ST_AsGeoJSON.toGeojsonCoordinates(p.getExteriorRing().getCoordinates(), sb);
            for (int j = 0; j < p.getNumInteriorRing(); ++j) {
                sb.append(",");
                ST_AsGeoJSON.toGeojsonCoordinates(p.getInteriorRingN(j).getCoordinates(), sb);
            }
            sb.append("]");
            if (i >= multiPolygon.getNumGeometries() - 1) continue;
            sb.append(",");
        }
        sb.append("]}");
    }

    public static void toGeojsonGeometryCollection(GeometryCollection geometryCollection, StringBuilder sb) {
        sb.append("{\"type\":\"GeometryCollection\",\"geometries\":[");
        for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
            Geometry geom = geometryCollection.getGeometryN(i);
            if (geom instanceof Point) {
                ST_AsGeoJSON.toGeojsonPoint((Point)geom, sb);
            } else if (geom instanceof LineString) {
                ST_AsGeoJSON.toGeojsonLineString((LineString)geom, sb);
            } else if (geom instanceof Polygon) {
                ST_AsGeoJSON.toGeojsonPolygon((Polygon)geom, sb);
            }
            if (i >= geometryCollection.getNumGeometries() - 1) continue;
            sb.append(",");
        }
        sb.append("]}");
    }

    public static void toGeojsonCoordinates(Coordinate[] coords, StringBuilder sb) {
        sb.append("[");
        for (int i = 0; i < coords.length; ++i) {
            ST_AsGeoJSON.toGeojsonCoordinate(coords[i], sb);
            if (i >= coords.length - 1) continue;
            sb.append(",");
        }
        sb.append("]");
    }

    public static void toGeojsonCoordinate(Coordinate coord, StringBuilder sb) {
        sb.append("[");
        sb.append(coord.x).append(",").append(coord.y);
        if (!Double.isNaN(coord.z)) {
            sb.append(",").append(coord.z);
        }
        sb.append("]");
    }

    public String toGeoJsonEnvelope(Envelope e) {
        return new StringBuffer().append("[").append(e.getMinX()).append(",").append(e.getMinY()).append(",").append(e.getMaxX()).append(",").append(e.getMaxY()).append("]").toString();
    }
}

