/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.drivers.geojson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.io.IOException;
import java.sql.SQLException;
import org.h2gis.drivers.geojson.GJGeometryReader;
import org.h2gis.h2spatialapi.DeterministicScalarFunction;

public class ST_GeomFromGeoJSON
extends DeterministicScalarFunction {
    private static JsonFactory jsFactory;
    private static GJGeometryReader reader;

    public ST_GeomFromGeoJSON() {
        this.addProperty("remarks", "Convert a geojson representation of a geometry to a geometry object.");
    }

    public String getJavaStaticMethod() {
        return "geomFromGeoJSON";
    }

    public static Geometry geomFromGeoJSON(String geojson) throws IOException, SQLException {
        if (geojson == null) {
            return null;
        }
        if (jsFactory == null) {
            jsFactory = new JsonFactory();
            jsFactory.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
            jsFactory.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            jsFactory.configure(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS, true);
            reader = new GJGeometryReader(new GeometryFactory());
        }
        JsonParser jp = jsFactory.createParser(geojson);
        return reader.parseGeometry(jp);
    }
}

