/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.drivers.gpx;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.h2gis.drivers.gpx.GPXDriverFunction;
import org.h2gis.drivers.utility.FileUtil;
import org.h2gis.h2spatialapi.AbstractFunction;
import org.h2gis.h2spatialapi.EmptyProgressVisitor;
import org.h2gis.h2spatialapi.ProgressVisitor;
import org.h2gis.h2spatialapi.ScalarFunction;
import org.h2gis.utilities.URIUtility;

public class GPXRead
extends AbstractFunction
implements ScalarFunction {
    public GPXRead() {
        this.addProperty("remarks", "Read a GPX file and copy the content in the specified tables.");
    }

    public String getJavaStaticMethod() {
        return "readGPX";
    }

    public static void readGPX(Connection connection, String fileName, String tableReference) throws IOException, SQLException {
        File file = URIUtility.fileFromString((String)fileName);
        if (FileUtil.isFileImportable(file, "gpx")) {
            GPXDriverFunction gpxdf = new GPXDriverFunction();
            gpxdf.importFile(connection, tableReference, URIUtility.fileFromString((String)fileName), (ProgressVisitor)new EmptyProgressVisitor());
        }
    }

    public static void readGPX(Connection connection, String fileName) throws IOException, SQLException {
        String name = URIUtility.fileFromString((String)fileName).getName();
        GPXRead.readGPX(connection, fileName, name.substring(0, name.lastIndexOf(".")).toUpperCase());
    }
}

