/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.drivers.gpx.model;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2gis.drivers.gpx.model.AbstractGpxParser;
import org.h2gis.drivers.gpx.model.AbstractGpxParserDefault;
import org.h2gis.drivers.gpx.model.GPXTags;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class AbstractGpxParserWpt
extends AbstractGpxParser {
    private AbstractGpxParserDefault parent;

    public void initialise(XMLReader reader, AbstractGpxParserDefault parent) {
        this.setReader(reader);
        this.setParent(parent);
        this.setContentBuffer(parent.getContentBuffer());
        this.setWptPreparedStmt(parent.getWptPreparedStmt());
        this.setElementNames(parent.getElementNames());
        this.setCurrentPoint(parent.getCurrentPoint());
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.getContentBuffer().delete(0, this.getContentBuffer().length());
        this.getElementNames().push(qName);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.setCurrentElement(this.getElementNames().pop());
        if (this.getCurrentElement().equalsIgnoreCase(GPXTags.WPT)) {
            try {
                Object[] values;
                PreparedStatement pStm = this.getWptPreparedStmt();
                int i = 1;
                for (Object object : values = this.getCurrentPoint().getValues()) {
                    pStm.setObject(i, object);
                    ++i;
                }
                pStm.execute();
            }
            catch (SQLException ex) {
                throw new SAXException("Cannot import the waypoint.", ex);
            }
            this.getReader().setContentHandler(this.parent);
        } else {
            this.getCurrentPoint().setAttribute(this.getCurrentElement(), this.getContentBuffer());
        }
    }

    public void setParent(AbstractGpxParserDefault parent) {
        this.parent = parent;
    }
}

