/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.drivers.gpx.model;

import com.vividsolutions.jts.geom.Coordinate;
import org.h2gis.drivers.gpx.model.GPXTags;
import org.xml.sax.Attributes;

public class GPXCoordinate {
    public static Coordinate createCoordinate(Attributes attributes) throws NumberFormatException {
        double lon;
        double lat;
        try {
            lat = Double.parseDouble(attributes.getValue(GPXTags.LAT));
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Cannot parse the latitude value");
        }
        try {
            lon = Double.parseDouble(attributes.getValue(GPXTags.LON));
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Cannot parse the longitude value");
        }
        String eleValue = attributes.getValue(GPXTags.ELE);
        double ele = Double.NaN;
        if (eleValue != null) {
            try {
                ele = Double.parseDouble(eleValue);
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException("Cannot parse the elevation value");
            }
        }
        return new Coordinate(lon, lat, ele);
    }
}

