/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.drivers.kml;

import com.vividsolutions.jts.geom.Geometry;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.h2gis.drivers.kml.ExtrudeMode;
import org.h2gis.drivers.kml.KMLGeometry;
import org.h2gis.drivers.utility.FileUtil;
import org.h2gis.h2spatialapi.ProgressVisitor;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.SFSUtilities;
import org.h2gis.utilities.TableLocation;

public class KMLWriterDriver {
    private final String tableName;
    private final File fileName;
    private final Connection connection;
    private HashMap<Integer, String> kmlFields;
    private int columnCount = -1;

    public KMLWriterDriver(Connection connection, String tableName, File fileName) {
        this.connection = connection;
        this.tableName = tableName;
        this.fileName = fileName;
    }

    public void write(ProgressVisitor progress) throws SQLException {
        if (FileUtil.isExtensionWellFormated(this.fileName, "kml")) {
            this.writeKML(progress);
        } else if (FileUtil.isExtensionWellFormated(this.fileName, "kmz")) {
            String name = this.fileName.getName();
            int pos = name.lastIndexOf(".");
            this.writeKMZ(progress, name.substring(0, pos) + ".kml");
        } else {
            throw new SQLException("Please use the extensions .kml or kmz.");
        }
    }

    private void writeKML(ProgressVisitor progress) throws SQLException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.fileName);
            this.writeKMLDocument(progress, fos);
        }
        catch (FileNotFoundException ex) {
            throw new SQLException(ex);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException ex) {
                throw new SQLException(ex);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeKMZ(ProgressVisitor progress, String fileNameWithExtension) throws SQLException {
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(new FileOutputStream(this.fileName));
            zos.putNextEntry(new ZipEntry(fileNameWithExtension));
            this.writeKMLDocument(progress, zos);
            return;
        }
        catch (FileNotFoundException ex) {
            throw new SQLException(ex);
        }
        catch (IOException ex) {
            throw new SQLException(ex);
        }
        finally {
            try {
                if (zos != null) {
                    zos.closeEntry();
                    zos.finish();
                }
            }
            catch (IOException ex) {
                throw new SQLException(ex);
            }
            finally {
                try {
                    if (zos != null) {
                        zos.close();
                    }
                }
                catch (IOException ex) {
                    throw new SQLException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeKMLDocument(ProgressVisitor progress, OutputStream outputStream) throws SQLException {
        List spatialFieldNames = SFSUtilities.getGeometryFields((Connection)this.connection, (TableLocation)TableLocation.parse((String)this.tableName, (Boolean)JDBCUtilities.isH2DataBase((DatabaseMetaData)this.connection.getMetaData())));
        if (spatialFieldNames.isEmpty()) {
            throw new SQLException(String.format("The table %s does not contain a geometry field", this.tableName));
        }
        try {
            XMLOutputFactory streamWriterFactory = XMLOutputFactory.newFactory();
            streamWriterFactory.setProperty("escapeCharacters", false);
            XMLStreamWriter xmlOut = streamWriterFactory.createXMLStreamWriter(new BufferedOutputStream(outputStream), "UTF-8");
            xmlOut.writeStartDocument("UTF-8", "1.0");
            xmlOut.writeStartElement("kml");
            xmlOut.writeDefaultNamespace("http://www.opengis.net/kml/2.2");
            xmlOut.writeNamespace("atom", "http://www.w3.org/2005/Atom");
            xmlOut.writeNamespace("kml", "http://www.opengis.net/kml/2.2");
            xmlOut.writeNamespace("gx", "http://www.google.com/kml/ext/2.2");
            xmlOut.writeNamespace("xal", "urn:oasis:names:tc:ciq:xsdschema:xAL:2.0");
            xmlOut.writeStartElement("Document");
            Statement st = this.connection.createStatement();
            try {
                ResultSet rs = st.executeQuery(String.format("select * from %s", this.tableName));
                try {
                    int recordCount = JDBCUtilities.getRowCount((Connection)this.connection, (String)this.tableName);
                    ProgressVisitor copyProgress = progress.subProcess(recordCount);
                    ResultSetMetaData resultSetMetaData = rs.getMetaData();
                    int geoFieldIndex = JDBCUtilities.getFieldIndex((ResultSetMetaData)resultSetMetaData, (String)((String)spatialFieldNames.get(0)));
                    this.writeSchema(xmlOut, resultSetMetaData);
                    xmlOut.writeStartElement("Folder");
                    xmlOut.writeStartElement("name");
                    xmlOut.writeCharacters(this.tableName);
                    xmlOut.writeEndElement();
                    while (rs.next()) {
                        this.writePlacemark(xmlOut, rs, geoFieldIndex, (String)spatialFieldNames.get(0));
                        copyProgress.endStep();
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                st.close();
            }
            xmlOut.writeEndElement();
            xmlOut.writeEndElement();
            xmlOut.writeEndDocument();
            xmlOut.close();
        }
        catch (XMLStreamException ex) {
            throw new SQLException(ex);
        }
    }

    private void writeSchema(XMLStreamWriter xmlOut, ResultSetMetaData metaData) throws XMLStreamException, SQLException {
        this.columnCount = metaData.getColumnCount();
        if (this.columnCount > 1) {
            xmlOut.writeStartElement("Schema");
            xmlOut.writeAttribute("name", this.tableName);
            xmlOut.writeAttribute("id", this.tableName);
            this.kmlFields = new HashMap();
            for (int fieldId = 1; fieldId <= metaData.getColumnCount(); ++fieldId) {
                String fieldTypeName = metaData.getColumnTypeName(fieldId);
                if (fieldTypeName.equalsIgnoreCase("geometry")) continue;
                String fieldName = metaData.getColumnName(fieldId);
                this.writeSimpleField(xmlOut, fieldName, KMLWriterDriver.getKMLType(metaData.getColumnType(fieldId), fieldTypeName));
                this.kmlFields.put(fieldId, fieldName);
            }
            xmlOut.writeEndElement();
        }
    }

    private void writeSimpleField(XMLStreamWriter xmlOut, String columnName, String columnType) throws XMLStreamException {
        xmlOut.writeStartElement("SimpleField");
        xmlOut.writeAttribute("name", columnName);
        xmlOut.writeAttribute("type", columnType);
        xmlOut.writeEndElement();
    }

    public void writePlacemark(XMLStreamWriter xmlOut, ResultSet rs, int geoFieldIndex, String spatialFieldName) throws XMLStreamException, SQLException {
        xmlOut.writeStartElement("Placemark");
        if (this.columnCount > 1) {
            this.writeExtendedData(xmlOut, rs);
        }
        StringBuilder sb = new StringBuilder();
        Geometry geom = (Geometry)rs.getObject(geoFieldIndex);
        int inputSRID = geom.getSRID();
        if (inputSRID == 0) {
            throw new SQLException("A coordinate reference system must be set to save the KML file");
        }
        if (inputSRID != 4326) {
            throw new SQLException("The kml format supports only the WGS84 projection. \nPlease use ST_Transform(" + spatialFieldName + "," + inputSRID + ")");
        }
        KMLGeometry.toKMLGeometry(geom, ExtrudeMode.NONE, 0, sb);
        xmlOut.writeCharacters(sb.toString());
        xmlOut.writeEndElement();
    }

    public void writeExtendedData(XMLStreamWriter xmlOut, ResultSet rs) throws XMLStreamException, SQLException {
        xmlOut.writeStartElement("ExtendedData");
        xmlOut.writeStartElement("SchemaData");
        xmlOut.writeAttribute("schemaUrl", "#" + this.tableName);
        for (Map.Entry<Integer, String> entry : this.kmlFields.entrySet()) {
            Integer fieldIndex = entry.getKey();
            String fieldName = entry.getValue();
            this.writeSimpleData(xmlOut, fieldName, rs.getString(fieldIndex));
        }
        xmlOut.writeEndElement();
        xmlOut.writeEndElement();
    }

    public void writeSimpleData(XMLStreamWriter xmlOut, String columnName, String value) throws XMLStreamException {
        xmlOut.writeStartElement("SimpleData");
        xmlOut.writeAttribute("name", columnName);
        xmlOut.writeCharacters(value);
        xmlOut.writeEndElement();
    }

    private static String getKMLType(int sqlTypeId, String sqlTypeName) throws SQLException {
        switch (sqlTypeId) {
            case 16: {
                return "bool";
            }
            case 8: {
                return "double";
            }
            case 6: {
                return "float";
            }
            case -5: 
            case 4: {
                return "int";
            }
            case 5: {
                return "short";
            }
            case -15: 
            case 1: 
            case 12: 
            case 91: {
                return "string";
            }
        }
        throw new SQLException("Field type not supported by KML : " + sqlTypeName);
    }
}

