/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.drivers.osm;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.h2gis.drivers.osm.OSMParser;
import org.h2gis.h2spatialapi.DriverFunction;
import org.h2gis.h2spatialapi.ProgressVisitor;

public class OSMDriverFunction
implements DriverFunction {
    public static String DESCRIPTION = "OSM file (0.6)";
    public static String DESCRIPTION_GZ = "OSM Gzipped file (0.6)";
    public static String DESCRIPTION_BZ2 = "OSM Bzipped file (0.6)";

    public DriverFunction.IMPORT_DRIVER_TYPE getImportDriverType() {
        return DriverFunction.IMPORT_DRIVER_TYPE.COPY;
    }

    public String[] getExportFormats() {
        return new String[0];
    }

    public String getFormatDescription(String format) {
        if (format.equalsIgnoreCase("osm")) {
            return DESCRIPTION;
        }
        if (format.equalsIgnoreCase("gz")) {
            return DESCRIPTION_GZ;
        }
        if (format.equalsIgnoreCase("bz2")) {
            return DESCRIPTION_BZ2;
        }
        return "";
    }

    public boolean isSpatialFormat(String extension) {
        return extension.equalsIgnoreCase("osm") || extension.equalsIgnoreCase("gz") || extension.equalsIgnoreCase("bz2");
    }

    public void exportTable(Connection connection, String tableReference, File fileName, ProgressVisitor progress) throws SQLException, IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void importFile(Connection connection, String tableReference, File fileName, ProgressVisitor progress) throws SQLException, IOException {
        if (fileName == null || !fileName.getName().endsWith(".osm") && !fileName.getName().endsWith("osm.gz") && !fileName.getName().endsWith("osm.bz2")) {
            throw new IOException(new IllegalArgumentException("This driver handle only osm and osm.gz files"));
        }
        OSMParser osmp = new OSMParser();
        osmp.read(connection, tableReference, fileName, progress);
    }

    public String[] getImportFormats() {
        return new String[]{"osm", "gz", "bz2"};
    }
}

