/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.drivers.osm;

import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.h2gis.drivers.osm.NodeOSMElement;
import org.h2gis.drivers.osm.OSMElement;
import org.h2gis.drivers.osm.OSMTablesFactory;
import org.h2gis.drivers.osm.TAG_LOCATION;
import org.h2gis.drivers.osm.WayOSMElement;
import org.h2gis.h2spatialapi.EmptyProgressVisitor;
import org.h2gis.h2spatialapi.ProgressVisitor;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.TableLocation;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class OSMParser
extends DefaultHandler {
    private static final String TAG = "_tag";
    private static final String NODE = "_node";
    private static final String WAY = "_way";
    private static final String NODE_TAG = "_node_tag";
    private static final String WAY_TAG = "_way_tag";
    private static final String WAY_NODE = "_way_node";
    private static final String RELATION = "_relation";
    private static final String RELATION_TAG = "_relation_tag";
    private static final String NODE_MEMBER = "_node_member";
    private static final String WAY_MEMBER = "_way_member";
    private static final String RELATION_MEMBER = "_relation_member";
    private static final int BATCH_SIZE = 1000;
    private PreparedStatement nodePreparedStmt;
    private PreparedStatement nodeTagPreparedStmt;
    private PreparedStatement wayPreparedStmt;
    private PreparedStatement wayTagPreparedStmt;
    private PreparedStatement relationPreparedStmt;
    private PreparedStatement relationTagPreparedStmt;
    private PreparedStatement nodeMemberPreparedStmt;
    private PreparedStatement wayMemberPreparedStmt;
    private PreparedStatement relationMemberPreparedStmt;
    private PreparedStatement wayNodePreparedStmt;
    private int nodePreparedStmtBatchSize = 0;
    private int nodeTagPreparedStmtBatchSize = 0;
    private int wayPreparedStmtBatchSize = 0;
    private int wayTagPreparedStmtBatchSize = 0;
    private int relationPreparedStmtBatchSize = 0;
    private int relationTagPreparedStmtBatchSize = 0;
    private int nodeMemberPreparedStmtBatchSize = 0;
    private int wayMemberPreparedStmtBatchSize = 0;
    private int relationMemberPreparedStmtBatchSize = 0;
    private int wayNodePreparedStmtBatchSize = 0;
    private Set<String> insertedTagsKeys = new HashSet<String>();
    private int idMemberOrder = 1;
    private TAG_LOCATION tagLocation;
    private final GeometryFactory gf = new GeometryFactory(new PrecisionModel(), 4326);
    private NodeOSMElement nodeOSMElement;
    private WayOSMElement wayOSMElement;
    private OSMElement relationOSMElement;
    private ProgressVisitor progress = new EmptyProgressVisitor();
    private FileChannel fc;
    private long fileSize = 0L;
    private long readFileSizeEachNode = 1L;
    private long nodeCountProgress = 0L;
    private PreparedStatement tagPreparedStmt;
    private static final int AVERAGE_NODE_SIZE = 500;
    private static String TAG_DUPLICATE_EXCEPTION = String.valueOf(23505);

    public boolean read(Connection connection, String tableName, File inputFile, ProgressVisitor progress) throws SQLException {
        this.progress = progress.subProcess(100);
        boolean isH2 = JDBCUtilities.isH2DataBase((DatabaseMetaData)connection.getMetaData());
        boolean success = false;
        TableLocation requestedTable = TableLocation.parse((String)tableName, (Boolean)isH2);
        String osmTableName = requestedTable.getTable();
        this.checkOSMTables(connection, isH2, requestedTable, osmTableName);
        this.createOSMDatabaseModel(connection, isH2, requestedTable, osmTableName);
        FileInputStream fs = null;
        try {
            fs = new FileInputStream(inputFile);
            this.fc = fs.getChannel();
            this.fileSize = this.fc.size();
            this.readFileSizeEachNode = Math.max(1L, this.fileSize / 500L / 100L);
            this.nodeCountProgress = 0L;
            XMLReader parser = XMLReaderFactory.createXMLReader();
            parser.setErrorHandler(this);
            parser.setContentHandler(this);
            if (inputFile.getName().endsWith(".osm")) {
                parser.parse(new InputSource(fs));
            } else if (inputFile.getName().endsWith(".osm.gz")) {
                parser.parse(new InputSource(new GZIPInputStream(fs)));
            } else if (inputFile.getName().endsWith(".osm.bz2")) {
                parser.parse(new InputSource((InputStream)new BZip2CompressorInputStream((InputStream)fs)));
            } else {
                throw new SQLException("Supported formats are .osm, .osm.gz, .osm.bz2");
            }
            success = true;
        }
        catch (SAXException ex) {
            throw new SQLException(ex);
        }
        catch (IOException ex) {
            throw new SQLException("Cannot parse the file " + inputFile.getAbsolutePath(), ex);
        }
        finally {
            try {
                if (fs != null) {
                    fs.close();
                }
            }
            catch (IOException ex) {
                throw new SQLException("Cannot close the file " + inputFile.getAbsolutePath(), ex);
            }
            if (this.nodePreparedStmt != null) {
                this.nodePreparedStmt.close();
            }
            if (this.nodeTagPreparedStmt != null) {
                this.nodeTagPreparedStmt.close();
            }
            if (this.wayPreparedStmt != null) {
                this.wayPreparedStmt.close();
            }
            if (this.wayTagPreparedStmt != null) {
                this.wayTagPreparedStmt.close();
            }
            if (this.wayNodePreparedStmt != null) {
                this.wayNodePreparedStmt.close();
            }
            if (this.relationPreparedStmt != null) {
                this.relationPreparedStmt.close();
            }
            if (this.relationTagPreparedStmt != null) {
                this.relationTagPreparedStmt.close();
            }
            if (this.nodeMemberPreparedStmt != null) {
                this.nodeMemberPreparedStmt.close();
            }
            if (this.wayMemberPreparedStmt != null) {
                this.wayMemberPreparedStmt.close();
            }
            if (this.relationMemberPreparedStmt != null) {
                this.relationMemberPreparedStmt.close();
            }
            if (this.tagPreparedStmt != null) {
                this.tagPreparedStmt.close();
            }
        }
        return success;
    }

    private void checkOSMTables(Connection connection, boolean isH2, TableLocation requestedTable, String osmTableName) throws SQLException {
        String[] omsTables;
        for (String omsTableSuffix : omsTables = new String[]{TAG, NODE, NODE_TAG, WAY, WAY_NODE, WAY_TAG, RELATION, RELATION_TAG, NODE_MEMBER, WAY_MEMBER, RELATION_MEMBER}) {
            String osmTable = OSMParser.caseIdentifier(requestedTable, osmTableName + omsTableSuffix, isH2);
            if (!JDBCUtilities.tableExists((Connection)connection, (String)osmTable)) continue;
            throw new SQLException("The table " + osmTable + " already exists.");
        }
    }

    private static String caseIdentifier(TableLocation requestedTable, String tableName, boolean isH2) {
        return new TableLocation(requestedTable.getCatalog(), requestedTable.getSchema(), TableLocation.parse((String)tableName, (Boolean)isH2).getTable()).toString();
    }

    private void createOSMDatabaseModel(Connection connection, boolean isH2, TableLocation requestedTable, String osmTableName) throws SQLException {
        String tagTableName = OSMParser.caseIdentifier(requestedTable, osmTableName + TAG, isH2);
        this.tagPreparedStmt = OSMTablesFactory.createTagTable(connection, tagTableName);
        String nodeTableName = OSMParser.caseIdentifier(requestedTable, osmTableName + NODE, isH2);
        this.nodePreparedStmt = OSMTablesFactory.createNodeTable(connection, nodeTableName, isH2);
        String nodeTagTableName = OSMParser.caseIdentifier(requestedTable, osmTableName + NODE_TAG, isH2);
        this.nodeTagPreparedStmt = OSMTablesFactory.createNodeTagTable(connection, nodeTagTableName, tagTableName);
        String wayTableName = OSMParser.caseIdentifier(requestedTable, osmTableName + WAY, isH2);
        this.wayPreparedStmt = OSMTablesFactory.createWayTable(connection, wayTableName, isH2);
        String wayTagTableName = OSMParser.caseIdentifier(requestedTable, osmTableName + WAY_TAG, isH2);
        this.wayTagPreparedStmt = OSMTablesFactory.createWayTagTable(connection, wayTagTableName, tagTableName);
        String wayNodeTableName = OSMParser.caseIdentifier(requestedTable, osmTableName + WAY_NODE, isH2);
        this.wayNodePreparedStmt = OSMTablesFactory.createWayNodeTable(connection, wayNodeTableName);
        String relationTableName = OSMParser.caseIdentifier(requestedTable, osmTableName + RELATION, isH2);
        this.relationPreparedStmt = OSMTablesFactory.createRelationTable(connection, relationTableName);
        String relationTagTableName = OSMParser.caseIdentifier(requestedTable, osmTableName + RELATION_TAG, isH2);
        this.relationTagPreparedStmt = OSMTablesFactory.createRelationTagTable(connection, relationTagTableName, tagTableName);
        String nodeMemberTableName = OSMParser.caseIdentifier(requestedTable, osmTableName + NODE_MEMBER, isH2);
        this.nodeMemberPreparedStmt = OSMTablesFactory.createNodeMemberTable(connection, nodeMemberTableName);
        String wayMemberTableName = OSMParser.caseIdentifier(requestedTable, osmTableName + WAY_MEMBER, isH2);
        this.wayMemberPreparedStmt = OSMTablesFactory.createWayMemberTable(connection, wayMemberTableName);
        String relationMemberTableName = OSMParser.caseIdentifier(requestedTable, osmTableName + RELATION_MEMBER, isH2);
        this.relationMemberPreparedStmt = OSMTablesFactory.createRelationMemberTable(connection, relationMemberTableName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String type = attributes.getValue("type");
        if (this.progress.isCanceled()) {
            throw new SAXException("Canceled by user");
        }
        if (localName.compareToIgnoreCase("node") == 0) {
            this.nodeOSMElement = new NodeOSMElement(Double.valueOf(attributes.getValue("lat")), Double.valueOf(attributes.getValue("lon")));
            this.setCommonsAttributes(this.nodeOSMElement, attributes);
            this.tagLocation = TAG_LOCATION.NODE;
            return;
        }
        if (localName.compareToIgnoreCase("way") == 0) {
            this.wayOSMElement = new WayOSMElement();
            this.setCommonsAttributes(this.wayOSMElement, attributes);
            this.tagLocation = TAG_LOCATION.WAY;
            return;
        }
        if (localName.compareToIgnoreCase("tag") == 0) {
            String key = attributes.getValue("k");
            String value = attributes.getValue("v");
            boolean insertTag = true;
            switch (this.tagLocation) {
                case NODE: {
                    insertTag = this.nodeOSMElement.addTag(key, value);
                    break;
                }
                case WAY: {
                    insertTag = this.wayOSMElement.addTag(key, value);
                    break;
                }
                case RELATION: {
                    insertTag = this.relationOSMElement.addTag(key, value);
                }
            }
            try {
                if (!insertTag || this.insertedTagsKeys.contains(key)) return;
                this.tagPreparedStmt.setObject(1, key);
                this.tagPreparedStmt.execute();
                this.insertedTagsKeys.add(key);
                return;
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() == 23505 || TAG_DUPLICATE_EXCEPTION.equals(ex.getSQLState())) return;
                throw new SAXException("Cannot insert the tag :  {" + key + " , " + value + "}", ex);
            }
        }
        if (localName.compareToIgnoreCase("nd") == 0) {
            this.wayOSMElement.addRef(attributes.getValue("ref"));
            return;
        }
        if (localName.compareToIgnoreCase("relation") == 0) {
            this.relationOSMElement = new OSMElement();
            this.setCommonsAttributes(this.relationOSMElement, attributes);
            this.tagLocation = TAG_LOCATION.RELATION;
            return;
        }
        if (localName.compareToIgnoreCase("member") != 0) return;
        if (type.equalsIgnoreCase("node")) {
            try {
                this.nodeMemberPreparedStmt.setObject(1, this.relationOSMElement.getID());
                this.nodeMemberPreparedStmt.setObject(2, Long.valueOf(attributes.getValue("ref")));
                this.nodeMemberPreparedStmt.setObject(3, attributes.getValue("role"));
                this.nodeMemberPreparedStmt.setObject(4, this.idMemberOrder);
                this.nodeMemberPreparedStmt.addBatch();
                ++this.nodeMemberPreparedStmtBatchSize;
                return;
            }
            catch (SQLException ex) {
                throw new SAXException("Cannot insert the node member for the relation :  " + this.relationOSMElement.getID(), ex);
            }
        }
        if (type.equalsIgnoreCase("way")) {
            try {
                this.wayMemberPreparedStmt.setObject(1, this.relationOSMElement.getID());
                this.wayMemberPreparedStmt.setObject(2, Long.valueOf(attributes.getValue("ref")));
                this.wayMemberPreparedStmt.setObject(3, attributes.getValue("role"));
                this.wayMemberPreparedStmt.setObject(4, this.idMemberOrder);
                this.wayMemberPreparedStmt.addBatch();
                ++this.wayMemberPreparedStmtBatchSize;
                return;
            }
            catch (SQLException ex) {
                throw new SAXException("Cannot insert the way member for the relation :  " + this.relationOSMElement.getID(), ex);
            }
        }
        if (!type.equalsIgnoreCase("relation")) return;
        try {
            this.relationMemberPreparedStmt.setObject(1, this.relationOSMElement.getID());
            this.relationMemberPreparedStmt.setObject(2, Long.valueOf(attributes.getValue("ref")));
            this.relationMemberPreparedStmt.setObject(3, attributes.getValue("role"));
            this.relationMemberPreparedStmt.setObject(4, this.idMemberOrder);
            this.relationMemberPreparedStmt.addBatch();
            ++this.relationMemberPreparedStmtBatchSize;
            return;
        }
        catch (SQLException ex) {
            throw new SAXException("Cannot insert the relation member for the relation :  " + this.relationOSMElement.getID(), ex);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.nodePreparedStmtBatchSize = this.insertBatch(this.nodePreparedStmt, this.nodePreparedStmtBatchSize, 1);
            this.nodeTagPreparedStmtBatchSize = this.insertBatch(this.nodeTagPreparedStmt, this.nodeTagPreparedStmtBatchSize, 1);
            this.wayPreparedStmtBatchSize = this.insertBatch(this.wayPreparedStmt, this.wayPreparedStmtBatchSize, 1);
            this.wayTagPreparedStmtBatchSize = this.insertBatch(this.wayTagPreparedStmt, this.wayTagPreparedStmtBatchSize, 1);
            this.relationPreparedStmtBatchSize = this.insertBatch(this.relationPreparedStmt, this.relationPreparedStmtBatchSize, 1);
            this.relationTagPreparedStmtBatchSize = this.insertBatch(this.relationTagPreparedStmt, this.relationTagPreparedStmtBatchSize, 1);
            this.nodeMemberPreparedStmtBatchSize = this.insertBatch(this.nodeMemberPreparedStmt, this.nodeMemberPreparedStmtBatchSize, 1);
            this.wayMemberPreparedStmtBatchSize = this.insertBatch(this.wayMemberPreparedStmt, this.wayMemberPreparedStmtBatchSize, 1);
            this.relationMemberPreparedStmtBatchSize = this.insertBatch(this.relationMemberPreparedStmt, this.relationMemberPreparedStmtBatchSize, 1);
            this.wayNodePreparedStmtBatchSize = this.insertBatch(this.wayNodePreparedStmt, this.wayNodePreparedStmtBatchSize, 1);
        }
        catch (SQLException ex) {
            throw new SAXException("Could not insert sql batch", ex);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        HashMap<String, String> tags;
        if (localName.compareToIgnoreCase("node") == 0) {
            this.tagLocation = TAG_LOCATION.OTHER;
            try {
                this.nodePreparedStmt.setObject(1, this.nodeOSMElement.getID());
                this.nodePreparedStmt.setObject(2, this.nodeOSMElement.getPoint(this.gf));
                this.nodePreparedStmt.setObject(3, this.nodeOSMElement.getElevation());
                this.nodePreparedStmt.setObject(4, this.nodeOSMElement.getUser());
                this.nodePreparedStmt.setObject(5, this.nodeOSMElement.getUID());
                this.nodePreparedStmt.setObject(6, this.nodeOSMElement.getVisible());
                this.nodePreparedStmt.setObject(7, this.nodeOSMElement.getVersion());
                this.nodePreparedStmt.setObject(8, this.nodeOSMElement.getChangeSet());
                this.nodePreparedStmt.setObject(9, (Object)this.nodeOSMElement.getTimeStamp(), 91);
                this.nodePreparedStmt.setString(10, this.nodeOSMElement.getName());
                this.nodePreparedStmt.addBatch();
                ++this.nodePreparedStmtBatchSize;
                tags = this.nodeOSMElement.getTags();
                for (Map.Entry<String, String> entry : tags.entrySet()) {
                    this.nodeTagPreparedStmt.setObject(1, this.nodeOSMElement.getID());
                    this.nodeTagPreparedStmt.setObject(2, entry.getKey());
                    this.nodeTagPreparedStmt.setObject(3, entry.getValue());
                    this.nodeTagPreparedStmt.addBatch();
                    ++this.nodeTagPreparedStmtBatchSize;
                }
            }
            catch (SQLException ex) {
                throw new SAXException("Cannot insert the node  :  " + this.nodeOSMElement.getID(), ex);
            }
        } else if (localName.compareToIgnoreCase("way") == 0) {
            this.tagLocation = TAG_LOCATION.OTHER;
            try {
                this.wayPreparedStmt.setObject(1, this.wayOSMElement.getID());
                this.wayPreparedStmt.setObject(2, this.wayOSMElement.getUser());
                this.wayPreparedStmt.setObject(3, this.wayOSMElement.getUID());
                this.wayPreparedStmt.setObject(4, this.wayOSMElement.getVisible());
                this.wayPreparedStmt.setObject(5, this.wayOSMElement.getVersion());
                this.wayPreparedStmt.setObject(6, this.wayOSMElement.getChangeSet());
                this.wayPreparedStmt.setTimestamp(7, this.wayOSMElement.getTimeStamp());
                this.wayPreparedStmt.setString(8, this.wayOSMElement.getName());
                this.wayPreparedStmt.addBatch();
                ++this.wayPreparedStmtBatchSize;
                tags = this.wayOSMElement.getTags();
                for (Map.Entry<String, String> entry : tags.entrySet()) {
                    this.wayTagPreparedStmt.setObject(1, this.wayOSMElement.getID());
                    this.wayTagPreparedStmt.setObject(2, entry.getKey());
                    this.wayTagPreparedStmt.setObject(3, entry.getValue());
                    this.wayTagPreparedStmt.addBatch();
                    ++this.wayTagPreparedStmtBatchSize;
                }
                int order = 1;
                for (long ref : this.wayOSMElement.getNodesRef()) {
                    this.wayNodePreparedStmt.setObject(1, this.wayOSMElement.getID());
                    this.wayNodePreparedStmt.setObject(2, ref);
                    this.wayNodePreparedStmt.setObject(3, order++);
                    this.wayNodePreparedStmt.addBatch();
                    ++this.wayNodePreparedStmtBatchSize;
                }
            }
            catch (SQLException ex) {
                throw new SAXException("Cannot insert the way  :  " + this.wayOSMElement.getID(), ex);
            }
        } else if (localName.compareToIgnoreCase("relation") == 0) {
            this.tagLocation = TAG_LOCATION.OTHER;
            try {
                this.relationPreparedStmt.setObject(1, this.relationOSMElement.getID());
                this.relationPreparedStmt.setObject(2, this.relationOSMElement.getUser());
                this.relationPreparedStmt.setObject(3, this.relationOSMElement.getUID());
                this.relationPreparedStmt.setObject(4, this.relationOSMElement.getVisible());
                this.relationPreparedStmt.setObject(5, this.relationOSMElement.getVersion());
                this.relationPreparedStmt.setObject(6, this.relationOSMElement.getChangeSet());
                this.relationPreparedStmt.setTimestamp(7, this.relationOSMElement.getTimeStamp());
                this.relationPreparedStmt.addBatch();
                ++this.relationPreparedStmtBatchSize;
                tags = this.relationOSMElement.getTags();
                for (Map.Entry<String, String> entry : tags.entrySet()) {
                    this.relationTagPreparedStmt.setObject(1, this.relationOSMElement.getID());
                    this.relationTagPreparedStmt.setObject(2, entry.getKey());
                    this.relationTagPreparedStmt.setObject(3, entry.getValue());
                    this.relationTagPreparedStmt.addBatch();
                    ++this.relationTagPreparedStmtBatchSize;
                }
                this.idMemberOrder = 0;
            }
            catch (SQLException ex) {
                throw new SAXException("Cannot insert the relation  :  " + this.relationOSMElement.getID(), ex);
            }
        } else if (localName.compareToIgnoreCase("member") == 0) {
            ++this.idMemberOrder;
        }
        try {
            this.insertBatch();
        }
        catch (SQLException ex) {
            throw new SAXException("Could not insert sql batch", ex);
        }
        if (this.nodeCountProgress++ % this.readFileSizeEachNode == 0L) {
            try {
                this.progress.setStep((int)((double)this.fc.position() / (double)this.fileSize * 100.0));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void insertBatch() throws SQLException {
        this.nodePreparedStmtBatchSize = this.insertBatch(this.nodePreparedStmt, this.nodePreparedStmtBatchSize);
        this.nodeTagPreparedStmtBatchSize = this.insertBatch(this.nodeTagPreparedStmt, this.nodeTagPreparedStmtBatchSize);
        this.wayPreparedStmtBatchSize = this.insertBatch(this.wayPreparedStmt, this.wayPreparedStmtBatchSize);
        this.wayTagPreparedStmtBatchSize = this.insertBatch(this.wayTagPreparedStmt, this.wayTagPreparedStmtBatchSize);
        this.relationPreparedStmtBatchSize = this.insertBatch(this.relationPreparedStmt, this.relationPreparedStmtBatchSize);
        this.relationTagPreparedStmtBatchSize = this.insertBatch(this.relationTagPreparedStmt, this.relationTagPreparedStmtBatchSize);
        this.nodeMemberPreparedStmtBatchSize = this.insertBatch(this.nodeMemberPreparedStmt, this.nodeMemberPreparedStmtBatchSize);
        this.wayMemberPreparedStmtBatchSize = this.insertBatch(this.wayMemberPreparedStmt, this.wayMemberPreparedStmtBatchSize);
        this.relationMemberPreparedStmtBatchSize = this.insertBatch(this.relationMemberPreparedStmt, this.relationMemberPreparedStmtBatchSize);
        this.wayNodePreparedStmtBatchSize = this.insertBatch(this.wayNodePreparedStmt, this.wayNodePreparedStmtBatchSize);
    }

    private int insertBatch(PreparedStatement st, int batchSize, int maxBatchSize) throws SQLException {
        if (batchSize >= maxBatchSize) {
            st.executeBatch();
            return 0;
        }
        return batchSize;
    }

    private int insertBatch(PreparedStatement st, int batchSize) throws SQLException {
        return this.insertBatch(st, batchSize, 1000);
    }

    private void setCommonsAttributes(OSMElement osmElement, Attributes attributes) throws SAXException {
        osmElement.setId(attributes.getValue("id"));
        osmElement.setUser(attributes.getValue("user"));
        osmElement.setUid(attributes.getValue("uid"));
        osmElement.setVisible(attributes.getValue("visible"));
        osmElement.setVersion(attributes.getValue("version"));
        osmElement.setChangeset(attributes.getValue("changeset"));
        osmElement.setTimestamp(attributes.getValue("timestamp"));
    }
}

