/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.drivers.shp;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.h2.command.Parser;
import org.h2.command.ddl.CreateTableData;
import org.h2.table.Column;
import org.h2gis.drivers.dbf.DBFEngine;
import org.h2gis.drivers.file_table.FileEngine;
import org.h2gis.drivers.shp.internal.SHPDriver;
import org.h2gis.drivers.shp.internal.ShapeType;

public class SHPEngine
extends FileEngine<SHPDriver> {
    @Override
    protected SHPDriver createDriver(File filePath, List<String> args) throws IOException {
        SHPDriver driver = new SHPDriver();
        driver.initDriverFromFile(filePath, args.size() > 1 ? args.get(1) : null);
        return driver;
    }

    private static int getGeometryTypeCodeFromShapeType(ShapeType shapeType) {
        if (shapeType.isPointType()) {
            return 4;
        }
        if (shapeType.isLineType()) {
            return 5;
        }
        return 6;
    }

    @Override
    protected void feedCreateTableData(SHPDriver driver, CreateTableData data) throws IOException {
        Column geometryColumn = new Column("THE_GEOM", 22);
        Parser parser = new Parser(data.session);
        geometryColumn.addCheckConstraint(data.session, parser.parseExpression("ST_GeometryTypeCode(THE_GEOM) = " + SHPEngine.getGeometryTypeCodeFromShapeType(driver.getShapeFileHeader().getShapeType())));
        data.columns.add(geometryColumn);
        DBFEngine.feedTableDataFromHeader(driver.getDbaseFileHeader(), data);
    }
}

