/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.drivers.shp;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.h2gis.drivers.shp.SHPDriverFunction;
import org.h2gis.drivers.utility.FileUtil;
import org.h2gis.h2spatialapi.AbstractFunction;
import org.h2gis.h2spatialapi.EmptyProgressVisitor;
import org.h2gis.h2spatialapi.ProgressVisitor;
import org.h2gis.h2spatialapi.ScalarFunction;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.URIUtility;

public class SHPRead
extends AbstractFunction
implements ScalarFunction {
    public SHPRead() {
        this.addProperty("remarks", "Read a shape file and copy the content in the specified table.");
    }

    public String getJavaStaticMethod() {
        return "readShape";
    }

    public static void readShape(Connection connection, String fileName, String tableReference, String forceEncoding) throws IOException, SQLException {
        File file = URIUtility.fileFromString((String)fileName);
        if (FileUtil.isFileImportable(file, "shp")) {
            SHPDriverFunction shpDriverFunction = new SHPDriverFunction();
            shpDriverFunction.importFile(connection, TableLocation.parse((String)tableReference, (Boolean)true).toString(true), file, (ProgressVisitor)new EmptyProgressVisitor(), forceEncoding);
        }
    }

    public static void readShape(Connection connection, String fileName, String tableReference) throws IOException, SQLException {
        SHPRead.readShape(connection, fileName, tableReference, null);
    }

    public static void readShape(Connection connection, String fileName) throws IOException, SQLException {
        String name = URIUtility.fileFromString((String)fileName).getName();
        SHPRead.readShape(connection, fileName, name.substring(0, name.lastIndexOf(".")).toUpperCase());
    }
}

