/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.drivers.shp.internal;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import org.h2gis.drivers.shp.internal.ShapefileHeader;
import org.h2gis.drivers.utility.ReadBufferManager;

public class IndexFile {
    private FileChannel channel;
    private ReadBufferManager buf = null;
    private int lastIndex = -1;
    private int recOffset;
    private int recLen;
    private ShapefileHeader header = null;

    public IndexFile(FileChannel channel) throws IOException {
        this.readHeader(channel);
        this.channel = channel;
        this.buf = new ReadBufferManager(channel, 1024);
    }

    public ShapefileHeader getHeader() {
        return this.header;
    }

    private void readHeader(ReadableByteChannel channel) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(100);
        while (buffer.remaining() > 0) {
            channel.read(buffer);
        }
        buffer.flip();
        this.header = new ShapefileHeader();
        this.header.read(buffer);
    }

    private void readRecord(int index) throws IOException {
        int pos = 100 + index * 8;
        this.recOffset = this.buf.getInt(pos);
        this.recLen = this.buf.getInt(pos + 4);
        this.lastIndex = index;
    }

    public void close() throws IOException {
        if (this.channel != null && this.channel.isOpen()) {
            this.channel.close();
        }
        this.buf = null;
    }

    public int getRecordCount() {
        return (this.header.getFileLength() * 2 - 100) / 8;
    }

    public int getOffset(int index) throws IOException {
        int ret = -1;
        if (this.lastIndex != index) {
            this.readRecord(index);
        }
        ret = this.recOffset;
        return 2 * ret;
    }

    public int getOffsetInBytes(int index) throws IOException {
        return this.getOffset(index) * 2;
    }

    public int getContentLength(int index) throws IOException {
        int ret = -1;
        if (this.lastIndex != index) {
            this.readRecord(index);
        }
        ret = this.recLen;
        return ret;
    }
}

