/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.drivers.tsv;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.h2gis.drivers.tsv.TSVDriverFunction;
import org.h2gis.drivers.utility.FileUtil;
import org.h2gis.h2spatialapi.AbstractFunction;
import org.h2gis.h2spatialapi.EmptyProgressVisitor;
import org.h2gis.h2spatialapi.ProgressVisitor;
import org.h2gis.h2spatialapi.ScalarFunction;
import org.h2gis.utilities.URIUtility;

public class TSVRead
extends AbstractFunction
implements ScalarFunction {
    public TSVRead() {
        this.addProperty("remarks", "Read a Tab-separated values file.");
    }

    public String getJavaStaticMethod() {
        return "readTSV";
    }

    public static void readTSV(Connection connection, String fileName, String tableReference) throws SQLException, FileNotFoundException, IOException {
        File file = URIUtility.fileFromString((String)fileName);
        if (FileUtil.isFileImportable(file, "tsv")) {
            TSVDriverFunction tsvDriver = new TSVDriverFunction();
            tsvDriver.importFile(connection, tableReference, file, (ProgressVisitor)new EmptyProgressVisitor());
        }
    }

    public static void readTSV(Connection connection, String fileName) throws IOException, SQLException {
        String name = URIUtility.fileFromString((String)fileName).getName();
        TSVRead.readTSV(connection, fileName, name.substring(0, name.lastIndexOf(".")).toUpperCase());
    }
}

