/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.drivers.utility;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

public final class WriteBufferManager {
    private static final int BUFFER_SIZE = 131072;
    private FileChannel channel;
    private ByteBuffer buffer;

    public WriteBufferManager(FileChannel channel) throws IOException {
        this.channel = channel;
        this.buffer = ByteBuffer.allocate(131072);
    }

    public void put(byte b) throws IOException {
        this.prepareToAddBytes(1);
        this.buffer.put(b);
    }

    private void prepareToAddBytes(int numBytes) throws IOException {
        if (this.buffer.remaining() < numBytes) {
            this.buffer.flip();
            this.channel.write(this.buffer);
            int bufferCapacity = Math.max(131072, numBytes);
            if (bufferCapacity != this.buffer.capacity()) {
                ByteOrder order = this.buffer.order();
                this.buffer = ByteBuffer.allocate(bufferCapacity);
                this.buffer.order(order);
            } else {
                this.buffer.clear();
            }
        }
    }

    public void put(byte[] bs) throws IOException {
        this.prepareToAddBytes(bs.length);
        this.buffer.put(bs);
    }

    public void flush() throws IOException {
        this.buffer.flip();
        this.channel.write(this.buffer);
    }

    public void order(ByteOrder order) {
        this.buffer.order(order);
    }

    public void putInt(int value) throws IOException {
        this.prepareToAddBytes(4);
        this.buffer.putInt(value);
    }

    public void putDouble(double d) throws IOException {
        this.prepareToAddBytes(8);
        this.buffer.putDouble(d);
    }
}

