/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.osgi;

import javax.sql.DataSource;
import org.h2gis.api.DriverFunction;
import org.h2gis.api.Function;
import org.h2gis.functions.factory.H2GISFunctions;
import org.h2gis.functions.osgi.DataSourceTracker;
import org.h2gis.functions.osgi.FunctionTracker;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator {
    private ServiceTracker<DataSource, FunctionTracker> databaseTracker;

    public void start(BundleContext bc) throws Exception {
        for (Function function : H2GISFunctions.getBuiltInsFunctions()) {
            bc.registerService(Function.class, (Object)function, null);
            if (!(function instanceof DriverFunction)) continue;
            bc.registerService(DriverFunction.class, (Object)((DriverFunction)function), null);
        }
        DataSourceTracker dataSourceTracker = new DataSourceTracker(bc);
        this.databaseTracker = new ServiceTracker(bc, DataSource.class, (ServiceTrackerCustomizer)dataSourceTracker);
        this.databaseTracker.open();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.databaseTracker.close();
    }
}

