/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.geojson;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.h2gis.api.DriverFunction;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.functions.io.geojson.GeoJsonReaderDriver;
import org.h2gis.functions.io.geojson.GeoJsonWriteDriver;
import org.h2gis.utilities.JDBCUtilities;

public class GeoJsonDriverFunction
implements DriverFunction {
    public DriverFunction.IMPORT_DRIVER_TYPE getImportDriverType() {
        return DriverFunction.IMPORT_DRIVER_TYPE.COPY;
    }

    public String[] getImportFormats() {
        return new String[]{"geojson"};
    }

    public String[] getExportFormats() {
        return new String[]{"geojson"};
    }

    public String getFormatDescription(String format) {
        if (format.equalsIgnoreCase("geojson")) {
            return "GeoJSON 1.0";
        }
        return "";
    }

    public boolean isSpatialFormat(String extension) {
        return extension.equals("geojson");
    }

    public void exportTable(Connection connection, String tableReference, File fileName, ProgressVisitor progress) throws SQLException, IOException {
        int recordCount = JDBCUtilities.getRowCount((Connection)connection, (String)tableReference);
        ProgressVisitor copyProgress = progress.subProcess(recordCount);
        GeoJsonWriteDriver geoJsonDriver = new GeoJsonWriteDriver(connection, tableReference, fileName);
        geoJsonDriver.write(copyProgress);
    }

    public void importFile(Connection connection, String tableReference, File fileName, ProgressVisitor progress) throws SQLException, IOException {
        GeoJsonReaderDriver geoJsonReaderDriver = new GeoJsonReaderDriver(connection, fileName);
        geoJsonReaderDriver.read(progress, tableReference);
    }
}

