/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.osm;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import org.h2gis.functions.io.osm.OSMElement;

public class NodeOSMElement
extends OSMElement {
    private double latitude;
    private double longitude;
    private Double elevation = null;

    public NodeOSMElement(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public void setElevation(double elevation) {
        this.elevation = elevation;
    }

    public Point getPoint(GeometryFactory gf) {
        return gf.createPoint(new Coordinate(this.longitude, this.latitude));
    }

    public Double getElevation() {
        return this.elevation;
    }

    @Override
    public boolean addTag(String key, String value) {
        if (key.equalsIgnoreCase("ele")) {
            try {
                this.setElevation(Double.valueOf(value));
                return false;
            }
            catch (NumberFormatException ex) {
                return super.addTag(key, value);
            }
        }
        return super.addTag(key, value);
    }
}

