/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.buffer;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.operation.buffer.BufferParameters;
import java.sql.SQLException;
import org.h2gis.api.DeterministicScalarFunction;
import org.h2gis.functions.spatial.create.ST_RingBuffer;

public class ST_RingSideBuffer
extends DeterministicScalarFunction {
    public ST_RingSideBuffer() {
        this.addProperty("remarks", "Return a ring buffer at a given distance on only one side of each input lines of the geometry.\nAvalaible arguments are :\n (1) the geometry, (2) the size of each ring,  (3) the number of rings, (4) optional - \na list of blank-separated key=value pairs (string case) iso used t manage line style parameters.\n  The end cap style for single-sided buffers is always ignored, and forced to the equivalent of flat.\nPlease read the ST_Buffer documention.\n (5) optional - createHole True if you want to keep only difference between buffers Default is true.\nNote : Holes are not supported by this function.");
    }

    public String getJavaStaticMethod() {
        return "ringSideBuffer";
    }

    public static Geometry ringSideBuffer(Geometry geom, double bufferSize, int numBuffer) throws SQLException {
        return ST_RingSideBuffer.ringSideBuffer(geom, bufferSize, numBuffer, "endcap=flat");
    }

    public static Geometry ringSideBuffer(Geometry geom, double bufferDistance, int numBuffer, String parameters) throws SQLException {
        return ST_RingSideBuffer.ringSideBuffer(geom, bufferDistance, numBuffer, parameters, true);
    }

    public static Geometry ringSideBuffer(Geometry geom, double bufferDistance, int numBuffer, String parameters, boolean doDifference) throws SQLException {
        if (geom == null) {
            return null;
        }
        if (geom.getNumGeometries() > 1) {
            throw new SQLException("This function supports only single geometry : point, linestring or polygon.");
        }
        String[] buffParemeters = parameters.split("\\s+");
        BufferParameters bufferParameters = new BufferParameters();
        bufferParameters.setSingleSided(true);
        for (String params : buffParemeters) {
            String param;
            String[] keyValue = params.split("=");
            if (keyValue[0].equalsIgnoreCase("endcap")) {
                param = keyValue[1];
                if (param.equalsIgnoreCase("round")) {
                    bufferParameters.setEndCapStyle(2);
                    continue;
                }
                if (param.equalsIgnoreCase("square")) {
                    bufferParameters.setEndCapStyle(2);
                    continue;
                }
                if (param.equalsIgnoreCase("flat")) {
                    bufferParameters.setEndCapStyle(2);
                    continue;
                }
                throw new IllegalArgumentException("Supported join values are round or square.");
            }
            if (keyValue[0].equalsIgnoreCase("join")) {
                param = keyValue[1];
                if (param.equalsIgnoreCase("bevel")) {
                    bufferParameters.setJoinStyle(3);
                    continue;
                }
                if (param.equalsIgnoreCase("mitre") || param.equalsIgnoreCase("miter")) {
                    bufferParameters.setJoinStyle(2);
                    continue;
                }
                if (param.equalsIgnoreCase("round")) {
                    bufferParameters.setJoinStyle(1);
                    continue;
                }
                throw new IllegalArgumentException("Supported join values are bevel, mitre, miter or round.");
            }
            if (keyValue[0].equalsIgnoreCase("mitre_limit") || keyValue[0].equalsIgnoreCase("miter_limit")) {
                bufferParameters.setMitreLimit(Double.valueOf(keyValue[1]).doubleValue());
                continue;
            }
            if (keyValue[0].equalsIgnoreCase("quad_segs")) {
                bufferParameters.setQuadrantSegments(Integer.valueOf(keyValue[1]).intValue());
                continue;
            }
            throw new IllegalArgumentException("Unknown parameters. Please read the documentation.");
        }
        if (bufferDistance > 0.0) {
            return ST_RingBuffer.computePositiveRingBuffer(geom, bufferDistance, numBuffer, bufferParameters, doDifference);
        }
        if (bufferDistance < 0.0) {
            if (geom instanceof Point) {
                throw new SQLException("Cannot compute a negative ring side buffer on a point.");
            }
            return ST_RingBuffer.computeNegativeRingBuffer(geom, bufferDistance, numBuffer, bufferParameters, doDifference);
        }
        return geom;
    }
}

