/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.clean;

import com.vividsolutions.jts.geom.Geometry;
import java.sql.SQLException;
import org.h2gis.api.DeterministicScalarFunction;
import org.h2gis.functions.spatial.clean.MakeValidOp;

public class ST_MakeValid
extends DeterministicScalarFunction {
    public static final String REMARKS = "Repair an invalid geometry.\n If preserveGeomDim is true, makeValid will remove degenerated geometries from\n the result, i.e geometries which dimension is lower than the input geometry\nA multi-geometry will always produce a multi-geometry (eventually empty or made\n of a single component).\nA simple geometry may produce a multi-geometry (ex. polygon with self-intersection\n will generally produce a multi-polygon). In this case, it is up to the client to\n explode multi-geometries if he needs to.\nIf preserveGeomDim is off, it is up to the client to filter degenerate geometries.\n WARNING : for geometries of dimension 1 (linear), duplicate coordinates are\n preserved as much as possible. For geometries of dimension 2 (areal), duplicate\n coordinates are generally removed due to the use of overlay operations.";

    public ST_MakeValid() {
        this.addProperty("remarks", REMARKS);
    }

    public String getJavaStaticMethod() {
        return "validGeom";
    }

    public static Geometry validGeom(Geometry geometry) throws SQLException {
        return ST_MakeValid.validGeom(geometry, true, true, true);
    }

    public static Geometry validGeom(Geometry geometry, boolean preserveGeomDim) throws SQLException {
        return ST_MakeValid.validGeom(geometry, preserveGeomDim, true, true);
    }

    public static Geometry validGeom(Geometry geometry, boolean preserveGeomDim, boolean preserveDuplicateCoord) throws SQLException {
        return ST_MakeValid.validGeom(geometry, preserveGeomDim, preserveDuplicateCoord, true);
    }

    public static Geometry validGeom(Geometry geometry, boolean preserveGeomDim, boolean preserveDuplicateCoord, boolean preserveCoordDim) throws SQLException {
        if (geometry == null) {
            return null;
        }
        if (geometry.isEmpty()) {
            return geometry;
        }
        MakeValidOp op = new MakeValidOp();
        op.setPreserveGeomDim(preserveGeomDim);
        op.setPreserveDuplicateCoord(preserveDuplicateCoord);
        op.setPreserveCoordDim(preserveCoordDim);
        return op.makeValid(geometry);
    }
}

